/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Preferences;
import sernet.gs.model.Baustein;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.model.BSIConfigFactory;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.bsi.views.OpenCataloguesJob;

public final class BSIKatalogInvisibleRoot {
    private static final Logger LOG = Logger.getLogger(BSIKatalogInvisibleRoot.class);
    private static Pattern kapitelPattern = Pattern.compile("(\\d+)\\.(\\d+)");
    private static final int DEFAULT_LISTENER_AMOUNT = 5;
    private static final int WHOLE_FACTOR = 1000;
    private String language = "";
    private final Preferences.IPropertyChangeListener prefChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("cna_bsizipfile") || event.getProperty().equals("cna_bsiurl") || event.getProperty().equals("cna_gsaccess")) {
                LOG.debug((Object)("Reloading catalogues since catalogue properties changed: " + event.getProperty()));
                try {
                    OpenCataloguesJob job = new OpenCataloguesJob(Messages.BSIMassnahmenView_0, BSIConfigFactory.createStandaloneConfig());
                    job.setUser(true);
                    job.schedule();
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).error((Object)Messages.BSIMassnahmenView_2, (Throwable)e);
                }
            }
        }
    };
    private static volatile BSIKatalogInvisibleRoot instance;
    private List<Baustein> bausteine = new ArrayList<Baustein>();
    private List<ISelectionListener> listeners = new ArrayList<ISelectionListener>(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISelectionListener listener) {
        List<ISelectionListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISelectionListener lst) {
        List<ISelectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(lst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChanged() {
        List<ISelectionListener> list = this.listeners;
        synchronized (list) {
            for (ISelectionListener listener : this.listeners) {
                listener.cataloguesChanged();
            }
        }
    }

    public List<Baustein> getBausteine() {
        if (this.bausteine.isEmpty()) {
            this.bausteine.add(new NullBaustein());
        }
        if (this.language == null || this.language.isEmpty()) {
            this.language = this.determineLanguage(this.bausteine);
        }
        return this.bausteine;
    }

    void setBausteine(List<Baustein> bst) {
        this.bausteine = bst == null ? new ArrayList<Baustein>() : bst;
        this.fireChanged();
    }

    protected void finalize() throws Throwable {
        Activator.getDefault().getPluginPreferences().removePropertyChangeListener(this.prefChangeListener);
    }

    private BSIKatalogInvisibleRoot() {
        Activator.getDefault().getPluginPreferences().addPropertyChangeListener(this.prefChangeListener);
    }

    public static BSIKatalogInvisibleRoot getInstance() {
        if (instance == null) {
            instance = new BSIKatalogInvisibleRoot();
        }
        return instance;
    }

    public Baustein getBaustein(String id) {
        for (Baustein baustein : this.bausteine) {
            if (!baustein.getId().equals(id)) continue;
            return baustein;
        }
        return null;
    }

    public Baustein getBausteinByKapitel(String id) {
        Matcher m = kapitelPattern.matcher(id);
        if (m.find()) {
            int whole = Integer.parseInt(m.group(1));
            int radix = Integer.parseInt(m.group(2));
            int kapitelValue = whole * 1000 + radix;
            for (Baustein baustein : this.bausteine) {
                if (baustein.getKapitelValue() != kapitelValue) continue;
                return baustein;
            }
        }
        return null;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    private String determineLanguage(List<Baustein> bausteine) {
        Baustein firstBaustein = null;
        if (bausteine.size() > 1) {
            firstBaustein = this.getBaustein("B 1.0");
        }
        if (firstBaustein != null && "Sicherheitsmanagement".equals(firstBaustein.getTitel())) {
            return "DE";
        }
        if (firstBaustein != null && "Security management".equals(firstBaustein.getTitel())) {
            return "EN";
        }
        return "";
    }

    public static interface ISelectionListener {
        public void cataloguesChanged();
    }

    private class NullBaustein
    extends Baustein {
        private static final long serialVersionUID = -399972333143198070L;

        private NullBaustein() {
        }

        public String toString() {
            return Messages.BSIKatalogInvisibleRoot_2;
        }
    }
}

