/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenSiegelFilter;
import sernet.gs.ui.rcp.main.bsi.filter.MassnahmenUmsetzungFilter;
import sernet.gs.ui.rcp.main.bsi.views.CnAImageProvider;
import sernet.gs.ui.rcp.main.bsi.views.GenericMassnahmenView;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.bsi.views.actions.AuditViewFilterAction;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.verinice.model.bpm.TodoViewItem;

public class AuditView
extends GenericMassnahmenView {
    public static final String ID = "sernet.gs.ui.rcp.main.bsi.views.auditview";
    private AuditTableSorter tableSorter = new AuditTableSorter();

    @Override
    protected void createPartControlImpl(Composite parent) {
        Table table = this.getViewer().getTable();
        int iconColumnWidth = 25;
        int dateColumnWidth = 200;
        int bearbeiterColumnWidth = 100;
        int siegelColumnWidth = 20;
        int zielColumnWidth = 150;
        int titleColumnWidth = 250;
        this.iconColumn = new TableColumn(table, 16384);
        this.iconColumn.setText(" ");
        this.iconColumn.setWidth(25);
        this.iconColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.iconColumn, 0));
        this.dateColumn = new TableColumn(table, 16384);
        this.dateColumn.setText(Messages.AuditView_8);
        this.dateColumn.setWidth(200);
        this.dateColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.dateColumn, 1));
        this.bearbeiterColumn = new TableColumn(table, 16384);
        this.bearbeiterColumn.setText(Messages.AuditView_9);
        this.bearbeiterColumn.setWidth(100);
        this.bearbeiterColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.bearbeiterColumn, 2));
        this.siegelColumn = new TableColumn(table, 16384);
        this.siegelColumn.setText(Messages.AuditView_10);
        this.siegelColumn.setWidth(20);
        this.siegelColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.siegelColumn, 3));
        this.zielColumn = new TableColumn(table, 16384);
        this.zielColumn.setText(Messages.AuditView_11);
        this.zielColumn.setWidth(150);
        this.zielColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.zielColumn, 4));
        this.titleColumn = new TableColumn(table, 16384);
        this.titleColumn.setText(Messages.AuditView_12);
        this.titleColumn.setWidth(250);
        this.titleColumn.addSelectionListener((SelectionListener)new GenericMassnahmenView.SortSelectionAdapter(this, this.titleColumn, 5));
        this.getViewer().setColumnProperties(new String[]{"_icon", "_date", "_bearbeiter", "_siegel", "_ziel", "_title"});
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    @Override
    protected String[] getUmsetzungPattern() {
        return new String[]{"mnums_umsetzung_ja", "mnums_umsetzung_entbehrlich"};
    }

    @Override
    protected Action createFilterAction(MassnahmenUmsetzungFilter umsetzungFilter, MassnahmenSiegelFilter siegelFilter) {
        return new AuditViewFilterAction(this, (StructuredViewer)this.getViewer(), Messages.AuditView_19, umsetzungFilter, siegelFilter);
    }

    @Override
    protected ILabelProvider createLabelProvider() {
        return new AuditLabelProvider();
    }

    @Override
    protected GenericMassnahmenView.TableSorter createSorter() {
        return this.tableSorter;
    }

    @Override
    protected String getMeasureLoadJobLabel() {
        return Messages.AuditView_4;
    }

    @Override
    protected String getMeasureLoadPlaceholderLabel() {
        return Messages.AuditView_2;
    }

    @Override
    protected String getTaskErrorLabel() {
        return Messages.AuditView_5;
    }

    @Override
    protected String getMeasureLoadTaskLabel() {
        return "Lade Massnahmen";
    }

    @Override
    protected String getSortByProperty() {
        return "mnums_naechsterevisionam";
    }

    @Override
    protected String getDateProperty() {
        return "mnums_naechsterevisionam";
    }

    @Override
    public String getRightID() {
        return "auditview";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    private static class AuditLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy, EE");

        private AuditLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof PlaceHolder) {
                return null;
            }
            TodoViewItem mn = (TodoViewItem)element;
            if (columnIndex == 0) {
                return CnAImageProvider.getImage(mn);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PlaceHolder) {
                if (columnIndex == 1) {
                    PlaceHolder ph = (PlaceHolder)element;
                    return ph.getTitle();
                }
                return "";
            }
            TodoViewItem mn = (TodoViewItem)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    Date date = mn.getNaechsteRevision();
                    if (date == null) {
                        return Messages.TodoView_3;
                    }
                    return this.dateFormat.format(date);
                }
                case 2: {
                    return mn.getRevisionDurch();
                }
                case 3: {
                    return "" + mn.getStufe();
                }
                case 4: {
                    return mn.getParentTitle();
                }
                case 5: {
                    return mn.getTitle();
                }
            }
            return "";
        }
    }

    protected class AuditTableSorter
    extends GenericMassnahmenView.TableSorter {
        private final Logger log = Logger.getLogger(AuditTableSorter.class);

        protected AuditTableSorter() {
        }

        @Override
        public int compare(Viewer viewer, Object o1, Object o2) {
            int rc = 0;
            try {
                TodoViewItem mn1 = (TodoViewItem)o1;
                TodoViewItem mn2 = (TodoViewItem)o2;
                if (o1 == null) {
                    if (o2 != null) {
                        rc = 1;
                    }
                } else if (o2 == null) {
                    rc = -1;
                } else {
                    switch (this.getPropertyIndex()) {
                        case 0: {
                            rc = this.sortByString(mn1.getUmsetzung(), mn2.getUmsetzung());
                            break;
                        }
                        case 1: {
                            rc = this.sortByDate(mn1.getNaechsteRevision(), mn2.getNaechsteRevision());
                            break;
                        }
                        case 2: {
                            rc = this.sortByString(mn1.getRevisionDurch(), mn2.getRevisionDurch());
                            break;
                        }
                        case 3: {
                            rc = this.sortByString(String.valueOf(mn1.getStufe()), String.valueOf(mn2.getStufe()));
                            break;
                        }
                        case 4: {
                            rc = this.sortByString(mn1.getParentTitle(), mn2.getParentTitle());
                            break;
                        }
                        case 5: {
                            rc = this.sortByString(mn1.getTitle(), mn2.getTitle());
                            break;
                        }
                        default: {
                            rc = 0;
                        }
                    }
                }
                if (this.getDirection() == 1) {
                    rc = -rc;
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Error while sorting elements", (Throwable)e);
            }
            return rc;
        }
    }
}

