/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.views;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import sernet.gs.ui.rcp.main.bsi.views.FileView;
import sernet.verinice.model.bsi.Attachment;
import sernet.verinice.rcp.ImageCellProvider;

public class AttachmentImageCellProvider
extends ImageCellProvider {
    private CacheManager manager = null;
    private String cacheId = null;
    private Cache cache = null;

    AttachmentImageCellProvider(int size) {
        super(size);
    }

    @Override
    protected Image getImage(Object element) {
        if (!(element instanceof Attachment)) {
            return null;
        }
        Attachment attachment = (Attachment)element;
        Image thumb = null;
        if (Arrays.asList(Attachment.getImageMimeTypes()).contains(attachment.getMimeType())) {
            Element cacheElement = this.getCache().get((Serializable)attachment.getDbId());
            if (cacheElement != null) {
                if (cacheElement.getObjectValue() != EMPTY_CACHE_ELEMENT) {
                    ImageData imageData = (ImageData)cacheElement.getObjectValue();
                    thumb = new Image((Device)FileView.getDisplay(), imageData);
                }
            } else {
                byte[] fileData = this.loadFileData(attachment);
                thumb = this.createImage(fileData);
                if (thumb != null) {
                    this.getCache().put(new Element((Object)attachment.getDbId(), (Object)thumb.getImageData()));
                } else {
                    this.getCache().put(new Element((Object)attachment.getDbId(), EMPTY_CACHE_ELEMENT));
                }
            }
        }
        return thumb;
    }

    public void dispose(ColumnViewer viewer, ViewerColumn column) {
        super.dispose(viewer, column);
        Optional.ofNullable(this.manager).ifPresent(CacheManager::shutdown);
        this.manager = null;
    }

    protected Cache getCache() {
        this.cache = this.manager == null || Status.STATUS_SHUTDOWN.equals(this.manager.getStatus()) || this.cache == null || !Status.STATUS_ALIVE.equals(this.cache.getStatus()) ? this.createCache() : this.getManager().getCache(this.cacheId);
        return this.cache;
    }

    public void clearCache() {
        this.getCache().removeAll();
    }

    private Cache createCache() {
        int overFlowToDisk = 1000;
        long timeToLive = 3600L;
        long timeToIdle = 3600L;
        this.cacheId = UUID.randomUUID().toString();
        this.cache = new Cache(this.cacheId, 1000, false, false, 3600L, 3600L);
        this.getManager().addCache(this.cache);
        return this.cache;
    }

    public CacheManager getManager() {
        if (this.manager == null || Status.STATUS_SHUTDOWN.equals(this.manager.getStatus())) {
            this.manager = CacheManager.create();
        }
        return this.manager;
    }
}

