/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizard;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizardBrowserUpdateListener;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizardPageSearchFilter;
import sernet.gs.ui.rcp.main.bsi.views.SerializeBrowserLoadingListener;
import sernet.gs.ui.rcp.main.bsi.views.listeners.DisableContextMenuListener;
import sernet.gs.ui.rcp.main.bsi.views.listeners.WhiteListLocationListener;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.OwnGefaehrdung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;

public abstract class RiskAnalysisWizardPage<T extends TableViewer>
extends WizardPage {
    protected Composite rootContainer;
    protected Button buttonOwnGefaehrdungen;
    protected Button buttonGefaehrdungen;
    protected Text textSearch;
    private Browser browser;
    private RiskAnalysisWizardBrowserUpdateListener browserListener;
    protected SerializeBrowserLoadingListener browserLoadingListener;
    protected Button buttonNew;
    protected Button buttonEdit;
    protected Button buttonDelete;
    protected T viewer;
    protected OwnGefaehrdungenFilter ownGefaehrdungFilter = new OwnGefaehrdungenFilter();
    protected GefaehrdungenFilter gefaehrdungFilter = new GefaehrdungenFilter();
    protected RiskAnalysisWizardPageSearchFilter searchFilter = new RiskAnalysisWizardPageSearchFilter();
    private RiskAnalysisWizard riskWizard;
    protected static final Point ADD_EDIT_REMOVE_BUTTON_SIZE = new Point(110, 30);
    protected static final int BUTTONS_GRID_COLUMN_AMOUNT = 5;
    protected static final int NUM_COLS_BUTTONS = 3;
    protected static final int NUM_COLS_FILTERS = 1;
    protected static final int NUM_COLS_CONTROLS = 2;
    protected static final int WIDTH_COL_NAME = 400;
    protected static final int WIZARD_BROWSER_WIDTH = 500;
    protected static final int WIZARD_NUM_COLS_ROOT = 2;
    private static final String DB_NULL = "null";
    protected static final Point DEFAULT_MARGINS = new Point(5, 5);

    protected RiskAnalysisWizardPage(String pageName, String title, String description) {
        super(pageName);
        this.setTitle(title);
        this.setDescription(description);
    }

    protected RiskAnalysisWizard getRiskAnalysisWizard() {
        if (this.riskWizard == null) {
            this.riskWizard = (RiskAnalysisWizard)this.getWizard();
        }
        return this.riskWizard;
    }

    public void createControl(Composite parent) {
        this.rootContainer = new Composite(parent, 0);
        this.setLeftColumn(this.rootContainer);
        this.setRightColumn(this.rootContainer);
        this.addControls(this.rootContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(DEFAULT_MARGINS).generateLayout(this.rootContainer);
        this.setControl((Control)this.rootContainer);
        this.addListeners();
    }

    private void resetSearchField() {
        if (this.textSearch != null) {
            this.textSearch.setText("");
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initContents();
        }
    }

    private void initContents() {
        this.resetSearchField();
        this.doInitContents();
    }

    protected abstract void doInitContents();

    public void refresh() {
        this.viewer.refresh();
        this.browserListener.selectionChanged(new SelectionChangedEvent(this.viewer, this.viewer.getSelection()));
    }

    private void setRightColumn(Composite parent) {
        Composite rightColumn = new Composite(parent, 65536);
        this.browser = new Browser(rightColumn, 2048);
        this.browser.setJavascriptEnabled(false);
        this.browser.addMenuDetectListener((MenuDetectListener)new DisableContextMenuListener());
        this.browser.addLocationListener((LocationListener)WhiteListLocationListener.DEFAULT);
        this.browserLoadingListener = new SerializeBrowserLoadingListener(this.browser);
        this.browser.addProgressListener((ProgressListener)this.browserLoadingListener);
        GridLayoutFactory.fillDefaults().margins(DEFAULT_MARGINS).generateLayout(rightColumn);
        this.browser.setLayoutData((Object)new GridData(1808));
        GridDataFactory.fillDefaults().hint(500, 0x10000000).grab(false, true).applyTo((Control)rightColumn);
    }

    protected void setLeftColumn(Composite parent) {
        Composite leftColumn = new Composite(parent, 0);
        this.viewer = this.initializeViewer(leftColumn);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setColumns();
        table.layout();
        GridLayoutFactory.fillDefaults().margins(DEFAULT_MARGINS).generateLayout(leftColumn);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)leftColumn);
    }

    protected abstract T initializeViewer(Composite var1);

    protected abstract void setColumns();

    protected void addControls(Composite parent) {
        Composite controls = new Composite(parent, 0);
        this.addFilters(controls);
        this.addButtons(controls, Messages.ChooseGefaehrdungPage_11);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(DEFAULT_MARGINS).generateLayout(controls);
    }

    protected void addFilters(Composite parent) {
        Composite compositeFilter = new Composite(parent, 0);
        this.buttonOwnGefaehrdungen = new Button(compositeFilter, 32);
        this.buttonOwnGefaehrdungen.setText(Messages.ChooseGefaehrdungPage_8);
        this.buttonGefaehrdungen = new Button(compositeFilter, 32);
        this.buttonGefaehrdungen.setText(Messages.ChooseGefaehrdungPage_9);
        Composite search = new Composite(compositeFilter, 0);
        new Label(search, 0).setText(Messages.ChooseGefaehrdungPage_10);
        this.textSearch = new Text(search, 2052);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(DEFAULT_MARGINS).generateLayout(search);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(DEFAULT_MARGINS).generateLayout(compositeFilter);
        GridDataFactory.fillDefaults().hint(125, -1).applyTo((Control)this.textSearch);
    }

    protected void addButtons(Composite parent, String groupName) {
        Group groupButtons = new Group(parent, 64);
        groupButtons.setText(groupName);
        this.buttonNew = new Button((Composite)groupButtons, 8);
        this.buttonNew.setText(Messages.ChooseGefaehrdungPage_12);
        GridDataFactory.fillDefaults().hint(ADD_EDIT_REMOVE_BUTTON_SIZE).applyTo((Control)this.buttonNew);
        this.buttonEdit = new Button((Composite)groupButtons, 8);
        this.buttonEdit.setText(Messages.ChooseGefaehrdungPage_17);
        GridDataFactory.fillDefaults().hint(ADD_EDIT_REMOVE_BUTTON_SIZE).applyTo((Control)this.buttonEdit);
        this.buttonDelete = new Button((Composite)groupButtons, 8);
        this.buttonDelete.setText(Messages.ChooseGefaehrdungPage_13);
        GridDataFactory.fillDefaults().hint(ADD_EDIT_REMOVE_BUTTON_SIZE).applyTo((Control)this.buttonDelete);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(DEFAULT_MARGINS).generateLayout((Composite)groupButtons);
        GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)groupButtons);
    }

    protected void addListeners() {
        this.addSpecificListenersForPage();
        this.browserListener = new RiskAnalysisWizardBrowserUpdateListener(this.browserLoadingListener, (StructuredViewer)this.viewer);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.browserListener);
        if (this.buttonDelete != null && this.buttonEdit != null) {
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection() instanceof IStructuredSelection) {
                        Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (element instanceof RisikoMassnahmenUmsetzung || element instanceof OwnGefaehrdung) {
                            RiskAnalysisWizardPage.this.buttonDelete.setEnabled(true);
                            RiskAnalysisWizardPage.this.buttonEdit.setEnabled(true);
                        } else {
                            RiskAnalysisWizardPage.this.buttonDelete.setEnabled(false);
                            RiskAnalysisWizardPage.this.buttonEdit.setEnabled(false);
                        }
                    }
                }
            });
        }
        if (this.textSearch != null) {
            this.textSearch.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String searchText = RiskAnalysisWizardPage.this.textSearch.getText();
                    if (!searchText.isEmpty()) {
                        this.filterItems(searchText);
                    } else {
                        RiskAnalysisWizardPage.this.viewer.removeFilter((ViewerFilter)RiskAnalysisWizardPage.this.searchFilter);
                        RiskAnalysisWizardPage.this.viewer.refresh();
                        RiskAnalysisWizardPage.this.doAfterRemoveSearchFilter();
                    }
                }

                private void filterItems(String text) {
                    ViewerFilter[] filters = RiskAnalysisWizardPage.this.viewer.getFilters();
                    RiskAnalysisWizardPageSearchFilter thisFilter = null;
                    boolean contains = false;
                    ViewerFilter[] viewerFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter item = viewerFilterArray[n2];
                        if (item instanceof RiskAnalysisWizardPageSearchFilter) {
                            contains = true;
                            thisFilter = (RiskAnalysisWizardPageSearchFilter)item;
                        }
                        ++n2;
                    }
                    RiskAnalysisWizardPage.this.updateOrAddFilter(text, thisFilter, contains);
                }
            });
        }
    }

    protected void updateOrAddFilter(String text, RiskAnalysisWizardPageSearchFilter thisFilter, boolean contains) {
        if (contains) {
            thisFilter.setPattern(text);
            this.viewer.refresh();
            this.doAfterUpdateFilter();
        } else {
            this.searchFilter.setPattern(text);
            this.viewer.addFilter((ViewerFilter)this.searchFilter);
            this.viewer.refresh();
        }
    }

    protected abstract void doAfterUpdateFilter();

    protected abstract void addSpecificListenersForPage();

    protected abstract void doAfterRemoveSearchFilter();

    static class GefaehrdungenFilter
    extends ViewerFilter {
        GefaehrdungenFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof GefaehrdungsUmsetzung) {
                return !this.isOwnGefaehrung((GefaehrdungsUmsetzung)element);
            }
            return !(element instanceof OwnGefaehrdung);
        }

        public boolean isOwnGefaehrung(GefaehrdungsUmsetzung gef) {
            return gef.getUrl() == null || gef.getUrl().length() == 0 || gef.getUrl().equals(RiskAnalysisWizardPage.DB_NULL);
        }
    }

    static class OwnGefaehrdungenFilter
    extends ViewerFilter {
        OwnGefaehrdungenFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof OwnGefaehrdung) {
                return true;
            }
            if (element instanceof GefaehrdungsUmsetzung) {
                return this.isOwnGefaehrung((GefaehrdungsUmsetzung)element);
            }
            return false;
        }

        public boolean isOwnGefaehrung(GefaehrdungsUmsetzung gef) {
            return gef.getUrl() == null || gef.getUrl().length() == 0 || gef.getUrl().equals(RiskAnalysisWizardPage.DB_NULL);
        }
    }
}

