/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import sernet.gs.service.GSServiceException;
import sernet.gs.ui.rcp.main.bsi.views.HtmlWriter;
import sernet.gs.ui.rcp.main.bsi.views.SerializeBrowserLoadingListener;

public final class RiskAnalysisWizardBrowserUpdateListener
implements ISelectionChangedListener {
    private StructuredViewer viewer;
    private SerializeBrowserLoadingListener browserLoadingListener;
    private static final Logger LOG = Logger.getLogger(RiskAnalysisWizardBrowserUpdateListener.class);
    private Object viewedElement = null;

    public RiskAnalysisWizardBrowserUpdateListener(SerializeBrowserLoadingListener browserLoadingListener, StructuredViewer viewer) {
        this.viewer = viewer;
        this.browserLoadingListener = browserLoadingListener;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.viewer) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                this.viewedElement = selection.getFirstElement();
            } else {
                this.browserLoadingListener.setText("");
                return;
            }
        }
        if (this.viewedElement == null) {
            LOG.warn((Object)"viewedElement cannot be null at this point");
            this.browserLoadingListener.setText("");
            return;
        }
        this.renderAndSetHtmlDescription(this.viewedElement);
    }

    private void renderAndSetHtmlDescription(Object firstElement) {
        try {
            String htmlText = HtmlWriter.getHtml(firstElement);
            htmlText = htmlText.replaceAll("<hr[^>]*>", "<br><hr width=\"90%\">");
            this.browserLoadingListener.setText(htmlText);
        }
        catch (GSServiceException e) {
            LOG.error((Object)e);
        }
    }
}

