/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.IGSModel;
import sernet.gs.model.Massnahme;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.FinishedRiskAnalysisListsHome;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.OwnGefaehrdungHome;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.RisikoMassnahmeHome;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.RisikoMassnahmenUmsetzungFactory;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.AdditionalSecurityMeasuresPage;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.ChooseGefaehrdungPage;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.EstimateGefaehrdungPage;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskHandlingPage;
import sernet.gs.ui.rcp.main.bsi.views.BSIKatalogInvisibleRoot;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.FinishedRiskAnalysis;
import sernet.verinice.model.bsi.risikoanalyse.FinishedRiskAnalysisLists;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUtil;
import sernet.verinice.model.bsi.risikoanalyse.OwnGefaehrdung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahme;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.crud.LoadChildrenForExpansion;
import sernet.verinice.service.commands.risk.AssociateGefaehrdungsUmsetzung;
import sernet.verinice.service.commands.risk.DisassociateGefaehrdungsUmsetzung;
import sernet.verinice.service.commands.risk.LoadAssociatedGefaehrdungen;
import sernet.verinice.service.commands.risk.StartNewRiskAnalysis;
import sernet.verinice.service.gstoolimport.MassnahmenFactory;

public class RiskAnalysisWizard
extends Wizard
implements IExportWizard {
    private boolean canFinish = false;
    private CnATreeElement cnaElement;
    private static final int WIZARD_WIDTH = 1300;
    private static final int WIZARD_HEIGHT = 600;
    protected static final int WIZARD_BROWSER_WIDTH = 700;
    protected static final int WIZARD_NUM_COLS_ROOT = 2;
    private static final Logger LOG = Logger.getLogger(RiskAnalysisWizard.class);
    private FinishedRiskAnalysis finishedRiskAnalysis = null;
    private List<Gefaehrdung> allGefaehrdungen = new ArrayList<Gefaehrdung>();
    private List<OwnGefaehrdung> allOwnGefaehrdungen = new ArrayList<OwnGefaehrdung>();
    private List<MassnahmenUmsetzung> allMassnahmenUmsetzungen = new ArrayList<MassnahmenUmsetzung>();
    private FinishedRiskAnalysisLists finishedRiskLists;

    public RiskAnalysisWizard(CnATreeElement treeElement) {
        this.cnaElement = treeElement;
    }

    public RiskAnalysisWizard(CnATreeElement parent, FinishedRiskAnalysis analysis) {
        this(parent);
        try {
            LoadChildrenForExpansion command = new LoadChildrenForExpansion((CnATreeElement)analysis);
            command = (LoadChildrenForExpansion)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            this.finishedRiskAnalysis = (FinishedRiskAnalysis)command.getElementWithChildren();
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.RiskAnalysisWizard_0);
        }
    }

    public boolean performFinish() {
        CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
        return true;
    }

    public boolean performCancel() {
        CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            if (this.finishedRiskAnalysis == null) {
                StartNewRiskAnalysis command = new StartNewRiskAnalysis(this.cnaElement);
                command = (StartNewRiskAnalysis)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                this.finishedRiskAnalysis = command.getFinishedRiskAnalysis();
                this.finishedRiskLists = command.getFinishedRiskLists();
            } else {
                this.finishedRiskLists = FinishedRiskAnalysisListsHome.getInstance().loadById(this.finishedRiskAnalysis.getDbId());
            }
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.RiskAnalysisWizard_1);
        }
        this.loadAllGefaehrdungen();
        this.loadAllMassnahmen();
        this.loadAssociatedGefaehrdungen();
        this.loadOwnGefaehrdungen();
        this.addOwnGefaehrdungen();
        this.addRisikoMassnahmenUmsetzungen(RiskAnalysisWizard.loadRisikomassnahmen());
    }

    private static List<RisikoMassnahme> loadRisikomassnahmen() {
        try {
            return RisikoMassnahmeHome.getInstance().loadAll();
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.RiskAnalysisWizard_2);
            return Collections.emptyList();
        }
    }

    public void addPages() {
        this.setWindowTitle(Messages.RiskAnalysisWizard_3);
        ChooseGefaehrdungPage chooseGefaehrdungPage = new ChooseGefaehrdungPage();
        this.addPage((IWizardPage)chooseGefaehrdungPage);
        EstimateGefaehrdungPage estimateGefaehrdungPage = new EstimateGefaehrdungPage();
        this.addPage((IWizardPage)estimateGefaehrdungPage);
        RiskHandlingPage riskHandlingPage = new RiskHandlingPage();
        this.addPage((IWizardPage)riskHandlingPage);
        AdditionalSecurityMeasuresPage additionalSecurityMeasuresPage = new AdditionalSecurityMeasuresPage();
        this.addPage((IWizardPage)additionalSecurityMeasuresPage);
    }

    public List<GefaehrdungsUmsetzung> getAssociatedGefaehrdungen() {
        return this.finishedRiskLists.getAssociatedGefaehrdungen();
    }

    private void loadAllGefaehrdungen() {
        List<Baustein> bausteine = BSIKatalogInvisibleRoot.getInstance().getBausteine();
        for (Baustein baustein : bausteine) {
            if (baustein.getGefaehrdungen() == null) continue;
            for (Gefaehrdung gefaehrdung : baustein.getGefaehrdungen()) {
                Boolean duplicate = false;
                for (IGSModel iGSModel : this.allGefaehrdungen) {
                    if (!iGSModel.getId().equals(gefaehrdung.getId())) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate.booleanValue()) continue;
                this.allGefaehrdungen.add(gefaehrdung);
            }
        }
    }

    private void loadAllMassnahmen() {
        List<Baustein> bausteine = BSIKatalogInvisibleRoot.getInstance().getBausteine();
        MassnahmenFactory massnahmenFactory = new MassnahmenFactory();
        for (Baustein baustein : bausteine) {
            for (Massnahme massnahme : baustein.getMassnahmen()) {
                Boolean duplicate = false;
                for (MassnahmenUmsetzung vorhandeneMassnahmenumsetzung : this.allMassnahmenUmsetzungen) {
                    if (!vorhandeneMassnahmenumsetzung.getName().equals(massnahme.getTitel())) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate.booleanValue()) continue;
                try {
                    MassnahmenUmsetzung massnahmeUmsetzung = massnahmenFactory.createMassnahmenUmsetzung(massnahme, BSIKatalogInvisibleRoot.getInstance().getLanguage());
                    this.allMassnahmenUmsetzungen.add(massnahmeUmsetzung);
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)Messages.RiskAnalysisWizard_4, (Throwable)e);
                }
            }
        }
    }

    private void loadAssociatedGefaehrdungen() {
        try {
            LoadAssociatedGefaehrdungen command = new LoadAssociatedGefaehrdungen(this.cnaElement);
            command = (LoadAssociatedGefaehrdungen)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            List associatedGefaehrdungen = command.getAssociatedGefaehrdungen();
            for (GefaehrdungsUmsetzung gefaehrdung : associatedGefaehrdungen) {
                if (this.associatedGefExistant(gefaehrdung)) continue;
                this.finishedRiskLists.addAssociatedGefahr(gefaehrdung);
            }
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.RiskAnalysisWizard_5);
        }
    }

    private boolean associatedGefExistant(GefaehrdungsUmsetzung gums) {
        for (GefaehrdungsUmsetzung existantGef : this.finishedRiskLists.getAssociatedGefaehrdungen()) {
            if (existantGef.getTitle().equals(gums.getTitle())) {
                LOG.warn((Object)("Gefaehrdungsumsetzung with Title:\t" + gums.getTitle() + "\talready exists in list, not adding this one"));
                return true;
            }
            if (!existantGef.getEntity().getPropertyValue("gefaehrdungsumsetzung_titel").equals(gums.getEntity().getPropertyValue("gefaehrdungsumsetzung_titel"))) continue;
            LOG.warn((Object)("Gefaehrdungsumsetzung with propertyvalue:\t " + gums.getTitle() + "\t for property " + "gefaehrdungsumsetzung_titel" + " already exists in list, not adding this one"));
            return true;
        }
        return false;
    }

    private void loadOwnGefaehrdungen() {
        try {
            this.allOwnGefaehrdungen = OwnGefaehrdungHome.getInstance().loadAll();
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.RiskAnalysisWizard_6);
        }
    }

    public void setAllGefaehrdungen(List<Gefaehrdung> newAllGefaehrdungen) {
        this.allGefaehrdungen = newAllGefaehrdungen;
    }

    public List<Gefaehrdung> getAllGefaehrdungen() {
        return this.allGefaehrdungen;
    }

    public void setAllOwnGefaehrdungen(List<OwnGefaehrdung> newAllOwnGefaehrdungen) {
        this.allOwnGefaehrdungen = newAllOwnGefaehrdungen;
    }

    public List<OwnGefaehrdung> getAllOwnGefaehrdungen() {
        return this.allOwnGefaehrdungen;
    }

    public List<GefaehrdungsUmsetzung> getAllGefaehrdungsUmsetzungen() {
        return this.finishedRiskLists.getAllGefaehrdungsUmsetzungen();
    }

    public FinishedRiskAnalysisLists getFinishedRiskAnalysisLists() {
        return this.finishedRiskLists;
    }

    public void setOldAnalysis(FinishedRiskAnalysis oldAnalysis) {
        this.finishedRiskAnalysis = oldAnalysis;
    }

    public CnATreeElement getCnaElement() {
        return this.cnaElement;
    }

    public void addOwnGefaehrdungen() {
        for (OwnGefaehrdung element : this.allOwnGefaehrdungen) {
            if (this.allGefaehrdungen.contains(element)) continue;
            this.allGefaehrdungen.add((Gefaehrdung)element);
        }
    }

    public void addRisikoMassnahmenUmsetzungen(List<RisikoMassnahme> allRisikoMassnahmen) {
        for (RisikoMassnahme massnahme : allRisikoMassnahmen) {
            this.addRisikoMassnahmeUmsetzung(massnahme);
        }
    }

    public void addRisikoMassnahmeUmsetzung(RisikoMassnahme massnahme) {
        try {
            RisikoMassnahmenUmsetzung massnahmeUmsetzung = RisikoMassnahmenUmsetzungFactory.buildFromRisikomassnahme(massnahme, null, null);
            if (!this.allMassnahmenUmsetzungen.contains(massnahmeUmsetzung)) {
                this.allMassnahmenUmsetzungen.add((MassnahmenUmsetzung)massnahmeUmsetzung);
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"Fehler beim Erstellen der Massnahmenumsetzung: ", (Throwable)e);
        }
    }

    public List<GefaehrdungsUmsetzung> getNotOKGefaehrdungsUmsetzungen() {
        return this.finishedRiskLists.getNotOKGefaehrdungsUmsetzungen();
    }

    public List<MassnahmenUmsetzung> getAllMassnahmenUmsetzungen() {
        return this.allMassnahmenUmsetzungen;
    }

    public void replaceMassnahmenUmsetzung(MassnahmenUmsetzung massnahmenUmsetzung) {
        this.allMassnahmenUmsetzungen.remove(massnahmenUmsetzung);
        this.allMassnahmenUmsetzungen.add(massnahmenUmsetzung);
    }

    public void setAllMassnahmenUmsetzungen(List<MassnahmenUmsetzung> newAllMassnahmenUmsetzungen) {
        this.allMassnahmenUmsetzungen = newAllMassnahmenUmsetzungen;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean newCanFinish) {
        this.canFinish = newCanFinish;
    }

    public CnATreeElement getFinishedRiskAnalysis() {
        return this.finishedRiskAnalysis;
    }

    public void addAssociatedGefaehrdung(Gefaehrdung currentGefaehrdung) {
        try {
            if (!GefaehrdungsUtil.listContainsById((Iterable)this.finishedRiskLists.getAssociatedGefaehrdungen(), (Gefaehrdung)currentGefaehrdung)) {
                AssociateGefaehrdungsUmsetzung command = new AssociateGefaehrdungsUmsetzung(this.finishedRiskLists.getDbId(), currentGefaehrdung, this.finishedRiskAnalysis.getDbId(), BSIKatalogInvisibleRoot.getInstance().getLanguage());
                command = (AssociateGefaehrdungsUmsetzung)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                this.finishedRiskLists = command.getFinishedRiskLists();
            }
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, "");
        }
    }

    public void removeAssociatedGefaehrdung(Gefaehrdung currentGefaehrdung) throws Exception {
        DisassociateGefaehrdungsUmsetzung command = new DisassociateGefaehrdungsUmsetzung(this.finishedRiskAnalysis, this.finishedRiskLists.getDbId(), currentGefaehrdung);
        command = (DisassociateGefaehrdungsUmsetzung)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        this.finishedRiskLists = command.getFinishedRiskLists();
        this.finishedRiskAnalysis = command.getFinishedRiskAnalysis();
    }

    public void setFinishedRiskLists(FinishedRiskAnalysisLists finishedRiskLists) {
        this.finishedRiskLists = finishedRiskLists;
    }

    public int getHeight() {
        return 600;
    }

    public int getBrowserWidth() {
        return 700;
    }

    public int getWidth() {
        return 1300;
    }

    public int getNumColsWizard() {
        return 1300;
    }
}

