/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisDialogItems;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahme;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;

public abstract class RiskAnalysisDialog<T>
extends Dialog {
    protected Text textNumber;
    protected Text textName;
    protected Text textDescription;
    protected Combo textCategory;
    private RiskAnalysisDialogItems<T> items;
    protected Color defaultBackground;
    private static final Logger LOG = Logger.getLogger(RiskAnalysisDialog.class);
    private static final int MAX_DESCRIPTION_LENGTH_FOR_GEFAEHRDUNG = 30000;

    protected RiskAnalysisDialog(Shell parentShell, RiskAnalysisDialogItems<T> items) {
        super(parentShell);
        this.items = items;
    }

    protected boolean isUniqueId(String id, Object element) {
        if (this.items.getGenericType().equals(Gefaehrdung.class) && element instanceof Gefaehrdung) {
            return this.isUniqueGefaehrdung(id, element);
        }
        if (this.items.getGenericType().equals(MassnahmenUmsetzung.class) && element instanceof RisikoMassnahme) {
            return this.isUniqueRisikoMassnahme(id, element);
        }
        if (this.items.getGenericType().equals(MassnahmenUmsetzung.class) && element instanceof RisikoMassnahmenUmsetzung) {
            return this.isUniqueRisikoMassnahmenUmsetzung(id, element);
        }
        LOG.error((Object)"the type of element or list is not supported", (Throwable)new IllegalArgumentException());
        return false;
    }

    private boolean isUniqueRisikoMassnahmenUmsetzung(String id, Object element) {
        RisikoMassnahmenUmsetzung massnahmenUmsetzung = (RisikoMassnahmenUmsetzung)element;
        for (Object item : this.items) {
            boolean isUsed;
            MassnahmenUmsetzung currentMassnahmenUmsetzung = (MassnahmenUmsetzung)item;
            boolean bl = isUsed = currentMassnahmenUmsetzung.getKapitel().equals(id) && !massnahmenUmsetzung.getUuid().equals(currentMassnahmenUmsetzung.getUuid());
            if (!isUsed) continue;
            return false;
        }
        return true;
    }

    private boolean isUniqueRisikoMassnahme(String id, Object element) {
        RisikoMassnahme massnahme = (RisikoMassnahme)element;
        for (Object item : this.items) {
            boolean isUsed;
            MassnahmenUmsetzung currentMassnahmenUmsetzung = (MassnahmenUmsetzung)item;
            boolean bl = isUsed = currentMassnahmenUmsetzung.getKapitel().equals(id) || currentMassnahmenUmsetzung.getId().equals(id) && (!(currentMassnahmenUmsetzung instanceof RisikoMassnahmenUmsetzung) || !massnahme.equals((Object)((RisikoMassnahmenUmsetzung)currentMassnahmenUmsetzung).getRisikoMassnahme()));
            if (!isUsed) continue;
            return false;
        }
        return true;
    }

    private boolean isUniqueGefaehrdung(String id, Object element) {
        Gefaehrdung gefaehrdung = (Gefaehrdung)element;
        for (Object item : this.items) {
            Gefaehrdung currentGefaehrdung = (Gefaehrdung)item;
            if (!currentGefaehrdung.getId().equals(id) || gefaehrdung.equals((Object)currentGefaehrdung)) continue;
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (this.isUniqueId(this.textNumber.getText(), this.getItem())) {
            if (this.descriptionLengthOK()) {
                this.okPressedAndApproved();
                super.okPressed();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.RiskAnalysisDialog_Error_0, (String)NLS.bind((String)Messages.RiskAnalysisDialog_Error_1, (Object)this.textDescription.getText().length(), (Object)this.getMaxDescriptionLength()));
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewGefaehrdungDialog_Error_0, (String)NLS.bind((String)Messages.NewGefaehrdungDialog_Error_1, (Object)this.textNumber.getText()));
        }
    }

    private boolean descriptionLengthOK() {
        return this.textDescription.getText().length() <= this.getMaxDescriptionLength();
    }

    private int getMaxDescriptionLength() {
        return 30000;
    }

    protected abstract Object getItem();

    protected abstract void okPressedAndApproved();

    protected Control createDialogArea(Composite parent) {
        int gridTextDescriptionWidthHint = 400;
        int gridTextDescriptionHeightHint = 200;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label labelNumber = new Label(composite, 0);
        GridData gridLabelNumber = new GridData();
        gridLabelNumber.horizontalAlignment = 16384;
        gridLabelNumber.verticalAlignment = 0x1000000;
        labelNumber.setText(Messages.EditGefaehrdungDialog_0);
        labelNumber.setLayoutData((Object)gridLabelNumber);
        this.textNumber = new Text(composite, 2048);
        GridData gridTextNumber = new GridData();
        gridTextNumber.horizontalAlignment = 4;
        gridTextNumber.verticalAlignment = 0x1000000;
        gridTextNumber.grabExcessHorizontalSpace = true;
        this.textNumber.setLayoutData((Object)gridTextNumber);
        Label labelName = new Label(composite, 0);
        GridData gridLabelName = new GridData();
        gridLabelName.horizontalAlignment = 16384;
        gridLabelName.verticalAlignment = 0x1000000;
        labelName.setText(Messages.EditGefaehrdungDialog_1);
        labelName.setLayoutData((Object)gridLabelName);
        this.textName = new Text(composite, 2048);
        GridData gridTextName = new GridData();
        gridTextName.horizontalAlignment = 4;
        gridTextName.verticalAlignment = 0x1000000;
        gridTextName.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData((Object)gridTextName);
        Label labelDescription = new Label(composite, 0);
        GridData gridLabelDescription = new GridData();
        gridLabelDescription.horizontalAlignment = 16384;
        gridLabelDescription.verticalAlignment = 128;
        labelDescription.setText(Messages.EditGefaehrdungDialog_2);
        labelDescription.setLayoutData((Object)gridLabelDescription);
        this.textDescription = new Text(composite, 2626);
        GridData gridTextDescription = new GridData();
        gridTextDescription.horizontalAlignment = 4;
        gridTextDescription.verticalAlignment = 4;
        gridTextDescription.grabExcessHorizontalSpace = true;
        gridTextDescription.grabExcessVerticalSpace = true;
        gridTextDescription.widthHint = 400;
        gridTextDescription.heightHint = 200;
        this.textDescription.setLayoutData((Object)gridTextDescription);
        this.defaultBackground = this.textDescription.getBackground();
        Label labelCategory = new Label(composite, 0);
        GridData gridLabelCategory = new GridData();
        gridLabelCategory.horizontalAlignment = 16384;
        gridLabelCategory.verticalAlignment = 128;
        labelCategory.setText(Messages.EditGefaehrdungDialog_3);
        labelCategory.setLayoutData((Object)gridLabelCategory);
        this.addCategory(composite);
        this.initContents();
        this.textDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int red = 250;
                int green = 250;
                int blue = 120;
                if (RiskAnalysisDialog.this.descriptionLengthOK()) {
                    RiskAnalysisDialog.this.textDescription.setBackground(RiskAnalysisDialog.this.defaultBackground);
                } else {
                    RiskAnalysisDialog.this.textDescription.setBackground(SWTResourceManager.getColor((int)250, (int)250, (int)120));
                }
            }
        });
        return composite;
    }

    protected void addCategory(Composite parent) {
        this.textCategory = new Combo(parent, 4);
        GridData gridTextCategory = new GridData();
        gridTextCategory.horizontalAlignment = 4;
        gridTextCategory.verticalAlignment = 0x1000000;
        gridTextCategory.grabExcessHorizontalSpace = true;
        this.textCategory.setLayoutData((Object)gridTextCategory);
        this.textCategory.setItems(this.loadCategories());
    }

    protected abstract String[] loadCategories();

    protected abstract void initContents();
}

