/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDHelper;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.risk.AddMassnahmeToGefaherdung;

public class RisikoMassnahmenUmsetzungDropListener
extends ViewerDropAdapter {
    private static final Logger LOG = Logger.getLogger(RisikoMassnahmenUmsetzungDropListener.class);
    private TreeViewer viewer;

    public RisikoMassnahmenUmsetzungDropListener(TreeViewer newViewer) {
        super((Viewer)newViewer);
        this.viewer = newViewer;
    }

    public boolean performDrop(Object data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"performDrop...");
        }
        Object receiver = this.getCurrentTarget();
        Object[] selectedData = null;
        selectedData = data == null ? ((IStructuredSelection)this.getViewer().getSelection()).toArray() : data;
        Iterator iterator = DNDHelper.arrayToList(selectedData).iterator();
        if (iterator.hasNext()) {
            Object toDrop = iterator.next();
            try {
                GefaehrdungsUmsetzung parent = (GefaehrdungsUmsetzung)receiver;
                RisikoMassnahmenUmsetzung child = (RisikoMassnahmenUmsetzung)toDrop;
                List children = parent.getGefaehrdungsBaumChildren();
                if (child instanceof RisikoMassnahmenUmsetzung && parent instanceof GefaehrdungsUmsetzung && !children.contains(child)) {
                    AddMassnahmeToGefaherdung command = new AddMassnahmeToGefaherdung(parent, child);
                    command = (AddMassnahmeToGefaherdung)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    child = command.getChild();
                    parent.addChild((CnATreeElement)child);
                    this.viewer.refresh();
                    this.viewer.setExpandedState((Object)parent, true);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                ExceptionUtil.log(e, Messages.RisikoMassnahmenUmsetzungDropListener_0);
                return false;
            }
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return target instanceof GefaehrdungsUmsetzung;
    }
}

