/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.RisikoMassnahmenUmsetzungFactory;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;
import sernet.verinice.model.common.CnATreeElement;

public class RisikoMassnahmenUmsetzungDragListener
implements DragSourceListener {
    private static final Logger LOG = Logger.getLogger(RisikoMassnahmenUmsetzungDragListener.class);
    private TableViewer viewer;
    private CnATreeElement cnaElement;
    private List<RisikoMassnahmenUmsetzung> risikoMassnahmenUmsetzungen;

    public RisikoMassnahmenUmsetzungDragListener(TableViewer newViewer, CnATreeElement newCnaElement) {
        this.viewer = newViewer;
        this.cnaElement = newCnaElement;
    }

    public void dragStart(DragSourceEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"dragStart...");
        }
        try {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            this.risikoMassnahmenUmsetzungen = new ArrayList<RisikoMassnahmenUmsetzung>();
            if (selection.size() < 1) {
                event.doit = false;
                return;
            }
            for (Object object : selection) {
                RisikoMassnahmenUmsetzung umsetzung;
                if (!(object instanceof RisikoMassnahmenUmsetzung) && !(object instanceof MassnahmenUmsetzung)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"dragStart, wrong object");
                    }
                    event.doit = false;
                    return;
                }
                if (object instanceof RisikoMassnahmenUmsetzung) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"dragStart, RisikoMassnahmenUmsetzung");
                    }
                    umsetzung = RisikoMassnahmenUmsetzungFactory.buildFromRisikomassnahmenUmsetzung((RisikoMassnahmenUmsetzung)object, this.cnaElement, null);
                    this.risikoMassnahmenUmsetzungen.add(umsetzung);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"dragStart, MassnahmenUmsetzung");
                }
                umsetzung = RisikoMassnahmenUmsetzungFactory.buildFromMassnahmenUmsetzung((MassnahmenUmsetzung)object, this.cnaElement, null);
                this.risikoMassnahmenUmsetzungen.add(umsetzung);
            }
            event.doit = true;
            event.data = this.risikoMassnahmenUmsetzungen.toArray(new RisikoMassnahmenUmsetzung[this.risikoMassnahmenUmsetzungen.size()]);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"dragStart finished");
            }
        }
        catch (Exception t) {
            LOG.error((Object)"Error in dragStart", (Throwable)t);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.risikoMassnahmenUmsetzungen.toArray(new RisikoMassnahmenUmsetzung[this.risikoMassnahmenUmsetzungen.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        this.risikoMassnahmenUmsetzungen.clear();
    }
}

