/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TableItem;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizard;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskHandlingPage;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.service.commands.risk.SelectRiskTreatment;

public class PropertiesComboBoxCellModifier
implements ICellModifier {
    private Viewer viewer;
    private RiskAnalysisWizard wizard;
    private RiskHandlingPage page;

    public PropertiesComboBoxCellModifier(Viewer newViewer, RiskAnalysisWizard newWizard, RiskHandlingPage newPage) {
        this.viewer = newViewer;
        this.wizard = newWizard;
        this.page = newPage;
    }

    public boolean canModify(Object element, String property) {
        return "choice".equals(property);
    }

    public Object getValue(Object element, String property) {
        GefaehrdungsUmsetzung gefaehrdungsUmsetzung = (GefaehrdungsUmsetzung)element;
        if ("choice".equals(property)) {
            return gefaehrdungsUmsetzung.getAlternativeIndex();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (element == null) {
            return;
        }
        Object item = ((TableItem)element).getData();
        if (item instanceof GefaehrdungsUmsetzung) {
            GefaehrdungsUmsetzung gefaehrdung = (GefaehrdungsUmsetzung)item;
            if ("choice".equals(property)) {
                int index = (Integer)value;
                String alternative = null;
                switch (index) {
                    case 0: {
                        alternative = "A";
                        break;
                    }
                    case 1: {
                        alternative = "B";
                        break;
                    }
                    case 2: {
                        alternative = "C";
                        break;
                    }
                    case 3: {
                        alternative = "D";
                        break;
                    }
                }
                if (alternative == null) {
                    return;
                }
                try {
                    SelectRiskTreatment command = new SelectRiskTreatment(this.wizard.getFinishedRiskAnalysisLists().getDbId(), this.wizard.getFinishedRiskAnalysis(), gefaehrdung, alternative);
                    command = (SelectRiskTreatment)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    this.wizard.setFinishedRiskLists(command.getFinishedRiskLists());
                    gefaehrdung.setAlternative(alternative);
                }
                catch (CommandException e) {
                    ExceptionUtil.log(e, Messages.PropertiesComboBoxCellModifier_0);
                }
                this.viewer.refresh();
                if (this.wizard.getNotOKGefaehrdungsUmsetzungen().isEmpty()) {
                    this.page.setPageComplete(false);
                } else {
                    this.page.setPageComplete(true);
                }
            }
        }
    }
}

