/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.OwnGefaehrdungHome;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisDialog;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisDialogItems;
import sernet.verinice.model.bsi.risikoanalyse.OwnGefaehrdung;

public class NewGefaehrdungDialog
extends RiskAnalysisDialog<Gefaehrdung> {
    private List<OwnGefaehrdung> ownGefaehrdungen;
    private OwnGefaehrdung ownGefaehrdung = new OwnGefaehrdung();

    public NewGefaehrdungDialog(Shell parentShell, List<OwnGefaehrdung> newOwnGefaehrdungen, RiskAnalysisDialogItems<Gefaehrdung> items) {
        super(parentShell, items);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.ownGefaehrdungen = newOwnGefaehrdungen;
    }

    @Override
    protected String[] loadCategories() {
        ArrayList<String> allCategories = new ArrayList<String>();
        allCategories.add(Messages.NewGefaehrdungDialog_5);
        allCategories.addAll(Gefaehrdung.getAllCategories());
        List<Object> allOwnGefaehrdungen = new ArrayList(0);
        try {
            allOwnGefaehrdungen = OwnGefaehrdungHome.getInstance().loadAll();
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.NewGefaehrdungDialog_6);
        }
        Boolean contains = false;
        for (OwnGefaehrdung ownGefaehrdung : allOwnGefaehrdungen) {
            for (String category : allCategories) {
                if (!category.equalsIgnoreCase(ownGefaehrdung.getKategorieAsString())) continue;
                contains = true;
                break;
            }
            if (!contains.booleanValue()) {
                allCategories.add(ownGefaehrdung.getKategorieAsString());
                continue;
            }
            contains = false;
        }
        return allCategories.toArray(new String[allCategories.size()]);
    }

    @Override
    protected void okPressedAndApproved() {
        this.ownGefaehrdung.setId(this.textNumber.getText());
        this.ownGefaehrdung.setTitel(this.textName.getText());
        this.ownGefaehrdung.setBeschreibung(this.textDescription.getText());
        this.ownGefaehrdung.setOwnkategorie(this.textCategory.getText());
        try {
            this.ownGefaehrdung = OwnGefaehrdungHome.getInstance().save(this.ownGefaehrdung);
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.NewGefaehrdungDialog_7);
        }
        this.ownGefaehrdungen.add(this.ownGefaehrdung);
    }

    @Override
    protected void initContents() {
        this.textNumber.setText("");
        this.textName.setText("");
        this.textDescription.setText("");
        this.textCategory.setText(Messages.NewGefaehrdungDialog_4);
    }

    @Override
    protected Object getItem() {
        return new OwnGefaehrdung();
    }
}

