/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.GefaehrdungsElementImageProvider;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;

public class MassnahmeTableViewerLabelProvider
implements ITableLabelProvider {
    private static final Logger LOG = Logger.getLogger(MassnahmeTableViewerLabelProvider.class);

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof RisikoMassnahmenUmsetzung) {
                return GefaehrdungsElementImageProvider.getImage(element);
            }
            return ImageCache.getInstance().getImage("16-em-check.png");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        try {
            if (element instanceof RisikoMassnahmenUmsetzung) {
                return this.getColumnTextForRisikoMassnahme(element, columnIndex);
            }
            return this.getColumnTextForMassnahme(element, columnIndex);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting column text for element: " + element + " and column: " + columnIndex), (Throwable)e);
            return "";
        }
    }

    private String getColumnTextForMassnahme(Object element, int columnIndex) {
        MassnahmenUmsetzung massnahme = (MassnahmenUmsetzung)element;
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return massnahme.getKapitel();
            }
            case 2: {
                return "[" + massnahme.getStufe() + "] " + massnahme.getName();
            }
        }
        return "";
    }

    private String getColumnTextForRisikoMassnahme(Object element, int columnIndex) {
        RisikoMassnahmenUmsetzung massnahme = (RisikoMassnahmenUmsetzung)element;
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return massnahme.getNumber();
            }
            case 2: {
                return "[" + massnahme.getStufe() + "] " + massnahme.getName();
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

