/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.CheckboxTableViewerLabelProvider;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.GefaehrdungenComparator;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizard;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizardPage;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.service.commands.risk.NegativeEstimateGefaehrdung;
import sernet.verinice.service.commands.risk.PositiveEstimateGefaehrdung;

public class EstimateGefaehrdungPage
extends RiskAnalysisWizardPage<CheckboxTableViewer> {
    private static final Logger LOG = Logger.getLogger(EstimateGefaehrdungPage.class);
    private TableViewerColumn checkboxColumn;
    private TableViewerColumn imageColumn;
    private TableViewerColumn numberColumn;
    private TableViewerColumn nameColumn;
    private TableViewerColumn descriptionColumn;

    protected EstimateGefaehrdungPage() {
        super(Messages.EstimateGefaehrdungPage_0, Messages.EstimateGefaehrdungPage_1, Messages.EstimateGefaehrdungPage_2);
    }

    private void selectAssignedGefaehrdungen() {
        List<GefaehrdungsUmsetzung> associatedGefaehrdungen = ((RiskAnalysisWizard)this.getWizard()).getAssociatedGefaehrdungen();
        for (GefaehrdungsUmsetzung gefaehrdung : associatedGefaehrdungen) {
            if (gefaehrdung.getOkay().booleanValue()) continue;
            ((CheckboxTableViewer)this.viewer).setChecked((Object)gefaehrdung, true);
        }
    }

    @Override
    protected void doInitContents() {
        List<GefaehrdungsUmsetzung> arrListAssociatedGefaehrdungen = this.getRiskAnalysisWizard().getAssociatedGefaehrdungen();
        ((CheckboxTableViewer)this.viewer).setLabelProvider((IBaseLabelProvider)new CheckboxTableViewerLabelProvider());
        ((CheckboxTableViewer)this.viewer).setContentProvider((IContentProvider)new ArrayContentProvider());
        ((CheckboxTableViewer)this.viewer).setInput(arrListAssociatedGefaehrdungen);
        ((CheckboxTableViewer)this.viewer).setComparator((ViewerComparator)new GefaehrdungenComparator());
        this.selectAssignedGefaehrdungen();
        this.packAllColumns();
        this.checkPageComplete();
    }

    private void packAllColumns() {
        this.checkboxColumn.getColumn().pack();
        this.imageColumn.getColumn().pack();
        this.numberColumn.getColumn().pack();
        this.nameColumn.getColumn().pack();
        this.nameColumn.getColumn().setWidth(Math.min(this.nameColumn.getColumn().getWidth(), 400));
        this.descriptionColumn.getColumn().pack();
    }

    private void checkPageComplete() {
        if (((RiskAnalysisWizard)this.getWizard()).getAllGefaehrdungsUmsetzungen().isEmpty()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    @Override
    protected void setColumns() {
        int checkboxColumnWidth = 35;
        int imageColumnWidth = 35;
        int numberColumnWidth = 100;
        int nameColumnWidth = 100;
        int descriptionColumnWidht = 200;
        this.checkboxColumn = new TableViewerColumn(this.viewer, 16384);
        this.checkboxColumn.getColumn().setText("");
        this.checkboxColumn.getColumn().setWidth(35);
        this.imageColumn = new TableViewerColumn(this.viewer, 16384);
        this.imageColumn.getColumn().setText("");
        this.imageColumn.getColumn().setWidth(35);
        this.numberColumn = new TableViewerColumn(this.viewer, 16384);
        this.numberColumn.getColumn().setText(Messages.EstimateGefaehrdungPage_5);
        this.numberColumn.getColumn().setWidth(100);
        this.nameColumn = new TableViewerColumn(this.viewer, 16384);
        this.nameColumn.getColumn().setText(Messages.EstimateGefaehrdungPage_6);
        this.nameColumn.getColumn().setWidth(100);
        this.descriptionColumn = new TableViewerColumn(this.viewer, 16384);
        this.descriptionColumn.getColumn().setText(Messages.EstimateGefaehrdungPage_7);
        this.descriptionColumn.getColumn().setWidth(200);
    }

    @Override
    protected void addSpecificListenersForPage() {
        this.addFilterListeners();
        ((CheckboxTableViewer)this.viewer).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GefaehrdungsUmsetzung gefaehrdungsUmsetzung = (GefaehrdungsUmsetzung)event.getElement();
                Integer raListDbId = EstimateGefaehrdungPage.this.getRiskAnalysisWizard().getFinishedRiskAnalysisLists().getDbId();
                if (event.getChecked()) {
                    try {
                        NegativeEstimateGefaehrdung command = new NegativeEstimateGefaehrdung(raListDbId, gefaehrdungsUmsetzung, EstimateGefaehrdungPage.this.getRiskAnalysisWizard().getFinishedRiskAnalysis());
                        command = (NegativeEstimateGefaehrdung)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        EstimateGefaehrdungPage.this.getRiskAnalysisWizard().setFinishedRiskLists(command.getRaList());
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while selecting", (Throwable)e);
                        ExceptionUtil.log(e, Messages.EstimateGefaehrdungPage_8);
                    }
                } else {
                    try {
                        PositiveEstimateGefaehrdung command = new PositiveEstimateGefaehrdung(raListDbId, gefaehrdungsUmsetzung, EstimateGefaehrdungPage.this.getRiskAnalysisWizard().getFinishedRiskAnalysis());
                        command = (PositiveEstimateGefaehrdung)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        if (command.getLists() != null) {
                            EstimateGefaehrdungPage.this.getRiskAnalysisWizard().setFinishedRiskLists(command.getLists());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while deselecting", (Throwable)e);
                        ExceptionUtil.log(e, Messages.EstimateGefaehrdungPage_9);
                    }
                }
                ((RiskAnalysisWizard)EstimateGefaehrdungPage.this.getWizard()).setCanFinish(false);
                EstimateGefaehrdungPage.this.checkPageComplete();
            }
        });
    }

    private void addFilterListeners() {
        this.buttonGefaehrdungen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    ((CheckboxTableViewer)EstimateGefaehrdungPage.this.viewer).addFilter((ViewerFilter)EstimateGefaehrdungPage.this.gefaehrdungFilter);
                    EstimateGefaehrdungPage.this.refresh();
                    EstimateGefaehrdungPage.this.packAllColumns();
                } else {
                    ((CheckboxTableViewer)EstimateGefaehrdungPage.this.viewer).removeFilter((ViewerFilter)EstimateGefaehrdungPage.this.gefaehrdungFilter);
                    EstimateGefaehrdungPage.this.refresh();
                    EstimateGefaehrdungPage.this.selectAssignedGefaehrdungen();
                    EstimateGefaehrdungPage.this.packAllColumns();
                }
            }
        });
        this.buttonOwnGefaehrdungen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    ((CheckboxTableViewer)EstimateGefaehrdungPage.this.viewer).addFilter((ViewerFilter)EstimateGefaehrdungPage.this.ownGefaehrdungFilter);
                    EstimateGefaehrdungPage.this.refresh();
                    EstimateGefaehrdungPage.this.packAllColumns();
                } else {
                    ((CheckboxTableViewer)EstimateGefaehrdungPage.this.viewer).removeFilter((ViewerFilter)EstimateGefaehrdungPage.this.ownGefaehrdungFilter);
                    EstimateGefaehrdungPage.this.refresh();
                    EstimateGefaehrdungPage.this.selectAssignedGefaehrdungen();
                    EstimateGefaehrdungPage.this.packAllColumns();
                }
            }
        });
    }

    @Override
    protected void doAfterUpdateFilter() {
        this.selectAssignedGefaehrdungen();
    }

    @Override
    protected void doAfterRemoveSearchFilter() {
        this.selectAssignedGefaehrdungen();
    }

    @Override
    protected void addButtons(Composite parent, String groupName) {
    }

    @Override
    protected CheckboxTableViewer initializeViewer(Composite parent) {
        return CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
    }
}

