/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.IGSModel;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.OwnGefaehrdungHome;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.CheckboxTableViewerLabelProvider;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.EditGefaehrdungDialog;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.GefaehrdungenComparator;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.NewGefaehrdungDialog;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisDialogItems;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizardPage;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUtil;
import sernet.verinice.model.bsi.risikoanalyse.OwnGefaehrdung;
import sernet.verinice.service.commands.CheckOwnGefaehrdungInUseCommand;
import sernet.verinice.service.commands.risk.LoadAssociatedGefaehrdungen;
import sernet.verinice.service.commands.risk.UpdateRiskAnalysis;

public class ChooseGefaehrdungPage
extends RiskAnalysisWizardPage<CheckboxTableViewer> {
    private TableViewerColumn checkboxColumn;
    private TableViewerColumn imageColumn;
    private TableViewerColumn numberColumn;
    private TableViewerColumn nameColumn;
    private TableViewerColumn categoryColumn;
    private RiskAnalysisDialogItems<Gefaehrdung> itemsToCheckForUniqueNumber;
    private static final Logger LOG = Logger.getLogger(ChooseGefaehrdungPage.class);

    protected ChooseGefaehrdungPage() {
        super(Messages.ChooseGefaehrdungPage_0, Messages.ChooseGefaehrdungPage_1, Messages.ChooseGefaehrdungPage_2);
    }

    @Override
    protected void setColumns() {
        this.checkboxColumn = new TableViewerColumn(this.viewer, 16384);
        this.checkboxColumn.getColumn().setText("");
        this.imageColumn = new TableViewerColumn(this.viewer, 16384);
        this.imageColumn.getColumn().setText("");
        this.numberColumn = new TableViewerColumn(this.viewer, 16384);
        this.numberColumn.getColumn().setText(Messages.ChooseGefaehrdungPage_5);
        this.nameColumn = new TableViewerColumn(this.viewer, 16384);
        this.nameColumn.getColumn().setText(Messages.ChooseGefaehrdungPage_6);
        this.categoryColumn = new TableViewerColumn(this.viewer, 16384);
        this.categoryColumn.getColumn().setText(Messages.ChooseGefaehrdungPage_7);
    }

    @Override
    protected void addSpecificListenersForPage() {
        this.addButtonListeners();
        this.addFilterListeners();
        ((CheckboxTableViewer)this.viewer).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Gefaehrdung currentGefaehrdung = (Gefaehrdung)event.getElement();
                ChooseGefaehrdungPage.this.associateGefaehrdung(currentGefaehrdung, event.getChecked());
            }
        });
        ((CheckboxTableViewer)this.viewer).addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ChooseGefaehrdungPage.this.editGefaehrdung();
            }
        });
    }

    private void editGefaehrdung() {
        IStructuredSelection selection = (IStructuredSelection)((CheckboxTableViewer)this.viewer).getSelection();
        IGSModel selectedGefaehrdung = (IGSModel)selection.getFirstElement();
        if (selectedGefaehrdung instanceof OwnGefaehrdung) {
            OwnGefaehrdung ownGefSelected = (OwnGefaehrdung)selectedGefaehrdung;
            boolean isEditable = this.isUnusedOwnGefaehrdung(ownGefSelected);
            if (isEditable) {
                this.itemsToCheckForUniqueNumber = new RiskAnalysisDialogItems<Gefaehrdung>(this.getRiskAnalysisWizard().getAllGefaehrdungen(), Gefaehrdung.class);
                EditGefaehrdungDialog dialog = new EditGefaehrdungDialog(this.rootContainer.getShell(), ownGefSelected, this.itemsToCheckForUniqueNumber);
                dialog.open();
                this.refresh();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ChooseGefaehrdungPage_Error_0, (String)NLS.bind((String)Messages.ChooseGefaehrdungPage_Error_2, (Object)ownGefSelected.getId()));
            }
        }
    }

    private boolean isUnusedOwnGefaehrdung(OwnGefaehrdung ownGefaehrdung) {
        boolean isUnused = false;
        CheckOwnGefaehrdungInUseCommand command = new CheckOwnGefaehrdungInUseCommand(ownGefaehrdung);
        try {
            command = (CheckOwnGefaehrdungInUseCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            isUnused = !command.isInUse();
        }
        catch (CommandException e) {
            LOG.warn((Object)"Error while checking if OwnGefaehrdung is used", (Throwable)e);
        }
        return isUnused;
    }

    private void addFilterListeners() {
        this.buttonGefaehrdungen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    ((CheckboxTableViewer)ChooseGefaehrdungPage.this.viewer).addFilter((ViewerFilter)ChooseGefaehrdungPage.this.gefaehrdungFilter);
                    ChooseGefaehrdungPage.this.refresh();
                    ChooseGefaehrdungPage.this.checkAllSelectedGefaehrdungen();
                    ChooseGefaehrdungPage.this.packAllColumns();
                } else {
                    ((CheckboxTableViewer)ChooseGefaehrdungPage.this.viewer).removeFilter((ViewerFilter)ChooseGefaehrdungPage.this.gefaehrdungFilter);
                    ChooseGefaehrdungPage.this.refresh();
                    ChooseGefaehrdungPage.this.assignBausteinGefaehrdungen();
                    ChooseGefaehrdungPage.this.refresh();
                    ChooseGefaehrdungPage.this.checkAllSelectedGefaehrdungen();
                    ChooseGefaehrdungPage.this.packAllColumns();
                }
            }
        });
        this.buttonOwnGefaehrdungen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    this.addFilter();
                } else {
                    this.removeFilter();
                }
            }

            private void removeFilter() {
                ((CheckboxTableViewer)ChooseGefaehrdungPage.this.viewer).removeFilter((ViewerFilter)ChooseGefaehrdungPage.this.ownGefaehrdungFilter);
                ChooseGefaehrdungPage.this.refresh();
                ChooseGefaehrdungPage.this.assignBausteinGefaehrdungen();
                ChooseGefaehrdungPage.this.checkAllSelectedGefaehrdungen();
                ChooseGefaehrdungPage.this.packAllColumns();
            }

            private void addFilter() {
                ((CheckboxTableViewer)ChooseGefaehrdungPage.this.viewer).addFilter((ViewerFilter)ChooseGefaehrdungPage.this.ownGefaehrdungFilter);
                ((CheckboxTableViewer)ChooseGefaehrdungPage.this.viewer).refresh();
                ChooseGefaehrdungPage.this.checkAllSelectedGefaehrdungen();
                ChooseGefaehrdungPage.this.packAllColumns();
            }
        });
    }

    @Override
    protected void doAfterUpdateFilter() {
        this.checkAllSelectedGefaehrdungen();
    }

    @Override
    protected void doAfterRemoveSearchFilter() {
        this.checkAllSelectedGefaehrdungen();
    }

    private void addButtonListeners() {
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)((CheckboxTableViewer)ChooseGefaehrdungPage.this.viewer).getSelection();
                Gefaehrdung selectedGefaehrdung = (Gefaehrdung)selection.getFirstElement();
                if (selectedGefaehrdung instanceof OwnGefaehrdung) {
                    boolean isDeletable = ChooseGefaehrdungPage.this.isUnusedOwnGefaehrdung((OwnGefaehrdung)selectedGefaehrdung);
                    if (isDeletable) {
                        boolean confirmed = MessageDialog.openQuestion((Shell)ChooseGefaehrdungPage.this.rootContainer.getShell(), (String)Messages.ChooseGefaehrdungPage_14, (String)NLS.bind((String)Messages.ChooseGefaehrdungPage_15, (Object)selectedGefaehrdung.getTitel()));
                        if (confirmed) {
                            ChooseGefaehrdungPage.this.deleteOwnGefaehrdung((Gefaehrdung)((OwnGefaehrdung)selectedGefaehrdung));
                            ChooseGefaehrdungPage.this.assignBausteinGefaehrdungen();
                            ChooseGefaehrdungPage.this.refresh();
                        }
                    } else {
                        String message = NLS.bind((String)Messages.ChooseGefaehrdungPage_Error_2, (Object)selectedGefaehrdung.getId());
                        MessageDialog.openError((Shell)ChooseGefaehrdungPage.this.getShell(), (String)Messages.ChooseGefaehrdungPage_Error_1, (String)message);
                    }
                }
            }
        });
        this.buttonNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                List<OwnGefaehrdung> arrListOwnGefaehrdungen = ChooseGefaehrdungPage.this.getRiskAnalysisWizard().getAllOwnGefaehrdungen();
                ChooseGefaehrdungPage.this.itemsToCheckForUniqueNumber = new RiskAnalysisDialogItems<Gefaehrdung>(ChooseGefaehrdungPage.this.getRiskAnalysisWizard().getAllGefaehrdungen(), Gefaehrdung.class);
                NewGefaehrdungDialog dialog = new NewGefaehrdungDialog(ChooseGefaehrdungPage.this.rootContainer.getShell(), arrListOwnGefaehrdungen, ChooseGefaehrdungPage.this.itemsToCheckForUniqueNumber);
                dialog.open();
                ChooseGefaehrdungPage.this.getRiskAnalysisWizard().addOwnGefaehrdungen();
                ChooseGefaehrdungPage.this.refresh();
                ChooseGefaehrdungPage.this.assignBausteinGefaehrdungen();
            }
        });
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChooseGefaehrdungPage.this.editGefaehrdung();
            }
        });
    }

    protected void associateGefaehrdung(Gefaehrdung currentGefaehrdung, boolean select) {
        if (select) {
            this.getRiskAnalysisWizard().addAssociatedGefaehrdung(currentGefaehrdung);
        } else {
            try {
                this.getRiskAnalysisWizard().removeAssociatedGefaehrdung(currentGefaehrdung);
            }
            catch (Exception e) {
                ExceptionUtil.log(e, NLS.bind((String)Messages.ChooseGefaehrdungPage_18, (Object)currentGefaehrdung.getTitel()));
            }
        }
        this.checkPageComplete();
    }

    @Override
    protected void doInitContents() {
        ArrayList arrListAllGefaehrdungen = (ArrayList)this.getRiskAnalysisWizard().getAllGefaehrdungen();
        ((CheckboxTableViewer)this.viewer).setLabelProvider((IBaseLabelProvider)new CheckboxTableViewerLabelProvider());
        ((CheckboxTableViewer)this.viewer).setContentProvider((IContentProvider)new ArrayContentProvider());
        ((CheckboxTableViewer)this.viewer).setInput((Object)arrListAllGefaehrdungen);
        ((CheckboxTableViewer)this.viewer).setComparator((ViewerComparator)new GefaehrdungenComparator());
        this.assignBausteinGefaehrdungen();
        this.checkAllSelectedGefaehrdungen();
        this.packAllColumns();
        this.getRiskAnalysisWizard().setCanFinish(false);
        this.checkPageComplete();
    }

    private void checkAllSelectedGefaehrdungen() {
        ArrayList<Gefaehrdung> toCheck = new ArrayList<Gefaehrdung>();
        for (GefaehrdungsUmsetzung associatedGefaehrdung : this.getRiskAnalysisWizard().getAssociatedGefaehrdungen()) {
            if (associatedGefaehrdung == null) continue;
            for (Gefaehrdung gefaehrdung : this.getRiskAnalysisWizard().getAllGefaehrdungen()) {
                if (gefaehrdung == null || gefaehrdung.getId() == null || !gefaehrdung.getId().equals(associatedGefaehrdung.getId())) continue;
                toCheck.add(gefaehrdung);
            }
        }
        Object[] checkarray = toCheck.toArray(new Gefaehrdung[toCheck.size()]);
        ((CheckboxTableViewer)this.viewer).setCheckedElements(checkarray);
    }

    private void assignBausteinGefaehrdungen() {
        try {
            LoadAssociatedGefaehrdungen command = new LoadAssociatedGefaehrdungen(this.getRiskAnalysisWizard().getCnaElement());
            command = (LoadAssociatedGefaehrdungen)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            List list = command.getAssociatedGefaehrdungen();
            for (GefaehrdungsUmsetzung selectedGefaehrdung : list) {
                if (selectedGefaehrdung == null) continue;
                for (Gefaehrdung gefaehrdung : this.getRiskAnalysisWizard().getAllGefaehrdungen()) {
                    if (gefaehrdung == null || gefaehrdung.getId() == null || !gefaehrdung.getId().equals(selectedGefaehrdung.getId())) continue;
                    this.associateGefaehrdung(gefaehrdung, true);
                }
            }
            UpdateRiskAnalysis updateCommand = new UpdateRiskAnalysis(this.getRiskAnalysisWizard().getFinishedRiskAnalysisLists());
            UpdateRiskAnalysis updateRiskAnalysis = (UpdateRiskAnalysis)ServiceFactory.lookupCommandService().executeCommand((ICommand)updateCommand);
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, "");
        }
    }

    private void packAllColumns() {
        this.checkboxColumn.getColumn().pack();
        this.imageColumn.getColumn().pack();
        this.numberColumn.getColumn().pack();
        this.nameColumn.getColumn().pack();
        this.nameColumn.getColumn().setWidth(Math.min(this.nameColumn.getColumn().getWidth(), 400));
        this.categoryColumn.getColumn().pack();
    }

    private void checkPageComplete() {
        if (this.getRiskAnalysisWizard().getAssociatedGefaehrdungen().isEmpty()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    private void deleteOwnGefaehrdung(Gefaehrdung delGefaehrdung) {
        ArrayList arrListAllGefaehrdungen = (ArrayList)this.getRiskAnalysisWizard().getAllGefaehrdungen();
        List<GefaehrdungsUmsetzung> arrListAssociatedGefaehrdungen = this.getRiskAnalysisWizard().getAssociatedGefaehrdungen();
        List<OwnGefaehrdung> arrListOwnGefaehrdungen = this.getRiskAnalysisWizard().getAllOwnGefaehrdungen();
        try {
            if (arrListOwnGefaehrdungen.contains(delGefaehrdung)) {
                OwnGefaehrdungHome.getInstance().remove((OwnGefaehrdung)delGefaehrdung);
                arrListOwnGefaehrdungen.remove(delGefaehrdung);
                GefaehrdungsUtil.removeBySameId(arrListAssociatedGefaehrdungen, (Gefaehrdung)delGefaehrdung);
                if (arrListAllGefaehrdungen.contains(delGefaehrdung)) {
                    arrListAllGefaehrdungen.remove(delGefaehrdung);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.ChooseGefaehrdungPage_20);
        }
    }

    @Override
    protected CheckboxTableViewer initializeViewer(Composite parent) {
        return CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
    }
}

