/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.model.RisikoMassnahmeHome;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.EditRisikoMassnahmenUmsetzungDialog;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.GefaehrdungTreeViewerContentProvider;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.GefaehrdungTreeViewerLabelProvider;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.MassnahmeTableViewerLabelProvider;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.MassnahmenComparator;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.Messages;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.NewRisikoMassnahmeDialog;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RisikoMassnahmenUmsetzungDragListener;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RisikoMassnahmenUmsetzungDropListener;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RisikoMassnahmenUmsetzungTransfer;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisDialogItems;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizardBrowserUpdateListener;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizardPage;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsBaumRoot;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.IGefaehrdungsBaumElement;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.risk.RemoveMassnahmeFromGefaherdung;

public class AdditionalSecurityMeasuresPage
extends RiskAnalysisWizardPage<TableViewer> {
    private TableColumn imageColumnMassnahme;
    private TableColumn numberColumnMassnahme;
    private TableColumn nameColumnMassnahme;
    private TreeViewer viewerScenario;
    private RiskAnalysisDialogItems<MassnahmenUmsetzung> itemsToCheckForUniqueNumber;
    private static final int IMAGE_CM_WIDTH = 35;
    private static final int NUMBER_CM_WIDTH = 100;
    private static final int NAME_CM_WIDTH = 100;
    private MassnahmenUmsetzungenFilter controlFilter = new MassnahmenUmsetzungenFilter();
    private RisikoMassnahmenUmsetzungenFilter ownControlFilter = new RisikoMassnahmenUmsetzungenFilter();
    private Button buttonRemoveControlFromScenario;
    private static final Logger LOG = Logger.getLogger(AdditionalSecurityMeasuresPage.class);

    protected AdditionalSecurityMeasuresPage() {
        super(Messages.AdditionalSecurityMeasuresPage_0, Messages.AdditionalSecurityMeasuresPage_1, Messages.AdditionalSecurityMeasuresPage_2);
    }

    @Override
    protected void doInitContents() {
        List<GefaehrdungsUmsetzung> arrListGefaehrdungsUmsetzungen = this.getRiskAnalysisWizard().getNotOKGefaehrdungsUmsetzungen();
        GefaehrdungsBaumRoot baum = new GefaehrdungsBaumRoot(arrListGefaehrdungsUmsetzungen);
        this.viewerScenario.setLabelProvider((IBaseLabelProvider)new GefaehrdungTreeViewerLabelProvider());
        this.viewerScenario.setContentProvider((IContentProvider)new GefaehrdungTreeViewerContentProvider());
        this.viewerScenario.setInput((Object)baum);
        this.viewerScenario.expandAll();
        ArrayList arrListMassnahmenUmsetzungen = (ArrayList)this.getRiskAnalysisWizard().getAllMassnahmenUmsetzungen();
        this.viewer.setLabelProvider((IBaseLabelProvider)new MassnahmeTableViewerLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)arrListMassnahmenUmsetzungen);
        this.viewer.setComparator((ViewerComparator)new MassnahmenComparator());
        this.packAllMassnahmeColumns();
        this.getRiskAnalysisWizard().setCanFinish(true);
    }

    private void packAllMassnahmeColumns() {
        this.imageColumnMassnahme.pack();
        this.numberColumnMassnahme.pack();
        this.nameColumnMassnahme.pack();
    }

    private void deleteControlFromTreeViewer(RisikoMassnahmenUmsetzung massnahme) {
        try {
            GefaehrdungsUmsetzung parent = (GefaehrdungsUmsetzung)massnahme.getParent();
            if (massnahme instanceof RisikoMassnahmenUmsetzung && parent instanceof GefaehrdungsUmsetzung) {
                RemoveMassnahmeFromGefaherdung command = new RemoveMassnahmeFromGefaherdung(parent, massnahme);
                command = (RemoveMassnahmeFromGefaherdung)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                parent = command.getParent();
                parent.getChildren().remove(massnahme);
                GefaehrdungsBaumRoot baumElement = (GefaehrdungsBaumRoot)this.viewerScenario.getInput();
                baumElement.replaceChild((IGefaehrdungsBaumElement)parent);
                this.viewerScenario.refresh();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    private void deleteOwnControl(RisikoMassnahmenUmsetzung risikoMassnahmenUmsetzung) {
        ArrayList arrListMassnahmenUmsetzungen = (ArrayList)this.getRiskAnalysisWizard().getAllMassnahmenUmsetzungen();
        try {
            if (arrListMassnahmenUmsetzungen.contains(risikoMassnahmenUmsetzung)) {
                arrListMassnahmenUmsetzungen.remove(risikoMassnahmenUmsetzung);
                RisikoMassnahmeHome.getInstance().initRisikoMassnahmeUmsetzung(risikoMassnahmenUmsetzung);
                RisikoMassnahmeHome.getInstance().remove(risikoMassnahmenUmsetzung.getRisikoMassnahme());
            }
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.AdditionalSecurityMeasuresPage_22);
        }
    }

    protected void editOwnControl() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        MassnahmenUmsetzung selectedMassnahmenUmsetzung = (MassnahmenUmsetzung)selection.getFirstElement();
        if (selectedMassnahmenUmsetzung instanceof RisikoMassnahmenUmsetzung) {
            RisikoMassnahmenUmsetzung selectedRisikoMassnahmenUmsetzung = (RisikoMassnahmenUmsetzung)selectedMassnahmenUmsetzung;
            this.itemsToCheckForUniqueNumber = new RiskAnalysisDialogItems<MassnahmenUmsetzung>(this.getRiskAnalysisWizard().getAllMassnahmenUmsetzungen(), MassnahmenUmsetzung.class);
            EditRisikoMassnahmenUmsetzungDialog dialog = new EditRisikoMassnahmenUmsetzungDialog(this.rootContainer.getShell(), selectedRisikoMassnahmenUmsetzung, this.itemsToCheckForUniqueNumber);
            int result = dialog.open();
            if (result == 0) {
                this.getRiskAnalysisWizard().replaceMassnahmenUmsetzung((MassnahmenUmsetzung)dialog.getRisikoMassnahmenUmsetzung());
                this.refresh();
                this.packAllMassnahmeColumns();
            }
        }
    }

    @Override
    protected void setLeftColumn(Composite parent) {
        Composite leftColumn = new Composite(parent, 0);
        Composite tree = new Composite(leftColumn, 0);
        this.viewerScenario = new TreeViewer(tree, 2);
        this.viewerScenario.getTree().setLayoutData((Object)new GridData(1808));
        GridLayoutFactory.fillDefaults().generateLayout(tree);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        Composite tableComp = new Composite(leftColumn, 0);
        this.viewer = this.initializeViewer(tableComp);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setColumns();
        GridLayoutFactory.fillDefaults().generateLayout(tableComp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComp);
        GridLayoutFactory.fillDefaults().equalWidth(true).numColumns(2).margins(DEFAULT_MARGINS).generateLayout(leftColumn);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)leftColumn);
    }

    @Override
    protected TableViewer initializeViewer(Composite parent) {
        return new TableViewer(parent, 67588);
    }

    @Override
    protected void setColumns() {
        Table tableMassnahme = this.viewer.getTable();
        this.imageColumnMassnahme = new TableColumn(tableMassnahme, 16384);
        this.imageColumnMassnahme.setText("");
        this.imageColumnMassnahme.setWidth(35);
        this.numberColumnMassnahme = new TableColumn(tableMassnahme, 16384);
        this.numberColumnMassnahme.setText(Messages.AdditionalSecurityMeasuresPage_4);
        this.numberColumnMassnahme.setWidth(100);
        this.nameColumnMassnahme = new TableColumn(tableMassnahme, 16384);
        this.nameColumnMassnahme.setText(Messages.AdditionalSecurityMeasuresPage_5);
        this.nameColumnMassnahme.setWidth(100);
    }

    @Override
    protected void addSpecificListenersForPage() {
        this.addButtonListeners();
        this.addFilterListeners();
        RiskAnalysisWizardBrowserUpdateListener browserListener = new RiskAnalysisWizardBrowserUpdateListener(this.browserLoadingListener, (StructuredViewer)this.viewerScenario);
        this.viewerScenario.addSelectionChangedListener((ISelectionChangedListener)browserListener);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AdditionalSecurityMeasuresPage.this.editOwnControl();
            }
        });
        this.buttonRemoveControlFromScenario.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AdditionalSecurityMeasuresPage.this.viewerScenario.getSelection();
                RisikoMassnahmenUmsetzung selectedRisikoMassnahmenUmsetzung = (RisikoMassnahmenUmsetzung)selection.getFirstElement();
                boolean confirmed = MessageDialog.openQuestion((Shell)AdditionalSecurityMeasuresPage.this.rootContainer.getShell(), (String)Messages.AdditionalSecurityMeasuresPage_9, (String)NLS.bind((String)Messages.AdditionalSecurityMeasuresPage_10, (Object)selectedRisikoMassnahmenUmsetzung.getTitle()));
                if (confirmed) {
                    AdditionalSecurityMeasuresPage.this.deleteControlFromTreeViewer(selectedRisikoMassnahmenUmsetzung);
                    AdditionalSecurityMeasuresPage.this.viewerScenario.refresh();
                    AdditionalSecurityMeasuresPage.this.refresh();
                }
            }
        });
        this.viewerScenario.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof RisikoMassnahmenUmsetzung) {
                        AdditionalSecurityMeasuresPage.this.buttonRemoveControlFromScenario.setEnabled(true);
                    } else {
                        AdditionalSecurityMeasuresPage.this.buttonRemoveControlFromScenario.setEnabled(false);
                    }
                }
            }
        });
        CnATreeElement cnaElement = this.getRiskAnalysisWizard().getFinishedRiskAnalysis();
        Transfer[] types = new Transfer[]{RisikoMassnahmenUmsetzungTransfer.getInstance()};
        int operations = 3;
        this.viewerScenario.addDropSupport(operations, types, (DropTargetListener)new RisikoMassnahmenUmsetzungDropListener(this.viewerScenario));
        this.viewer.addDragSupport(operations, types, (DragSourceListener)new RisikoMassnahmenUmsetzungDragListener(this.viewer, cnaElement));
    }

    private void addFilterListeners() {
        this.buttonOwnGefaehrdungen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button thisButton = (Button)event.widget;
                if (thisButton.getSelection()) {
                    AdditionalSecurityMeasuresPage.this.viewer.addFilter((ViewerFilter)AdditionalSecurityMeasuresPage.this.ownControlFilter);
                    AdditionalSecurityMeasuresPage.this.refresh();
                } else {
                    AdditionalSecurityMeasuresPage.this.viewer.removeFilter((ViewerFilter)AdditionalSecurityMeasuresPage.this.ownControlFilter);
                    AdditionalSecurityMeasuresPage.this.refresh();
                }
            }
        });
        this.buttonGefaehrdungen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button thisButton = (Button)event.widget;
                if (thisButton.getSelection()) {
                    AdditionalSecurityMeasuresPage.this.viewer.addFilter((ViewerFilter)AdditionalSecurityMeasuresPage.this.controlFilter);
                    AdditionalSecurityMeasuresPage.this.refresh();
                } else {
                    AdditionalSecurityMeasuresPage.this.viewer.removeFilter((ViewerFilter)AdditionalSecurityMeasuresPage.this.controlFilter);
                    AdditionalSecurityMeasuresPage.this.refresh();
                }
            }
        });
    }

    @Override
    protected void doAfterUpdateFilter() {
    }

    @Override
    protected void doAfterRemoveSearchFilter() {
    }

    private void addButtonListeners() {
        this.buttonNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AdditionalSecurityMeasuresPage.this.itemsToCheckForUniqueNumber = new RiskAnalysisDialogItems<MassnahmenUmsetzung>(AdditionalSecurityMeasuresPage.this.getRiskAnalysisWizard().getAllMassnahmenUmsetzungen(), MassnahmenUmsetzung.class);
                NewRisikoMassnahmeDialog dialog = new NewRisikoMassnahmeDialog(AdditionalSecurityMeasuresPage.this.rootContainer.getShell(), AdditionalSecurityMeasuresPage.this.itemsToCheckForUniqueNumber);
                int result = dialog.open();
                if (result == 0) {
                    AdditionalSecurityMeasuresPage.this.getRiskAnalysisWizard().addRisikoMassnahmeUmsetzung(dialog.getNewRisikoMassnahme());
                    AdditionalSecurityMeasuresPage.this.refresh();
                    AdditionalSecurityMeasuresPage.this.packAllMassnahmeColumns();
                }
            }
        });
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AdditionalSecurityMeasuresPage.this.editOwnControl();
            }
        });
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AdditionalSecurityMeasuresPage.this.viewer.getSelection();
                MassnahmenUmsetzung selectedMassnahmenUmsetzung = (MassnahmenUmsetzung)selection.getFirstElement();
                if (selectedMassnahmenUmsetzung instanceof RisikoMassnahmenUmsetzung) {
                    RisikoMassnahmenUmsetzung rsUmsetzung = (RisikoMassnahmenUmsetzung)selectedMassnahmenUmsetzung;
                    boolean confirmed = MessageDialog.openQuestion((Shell)AdditionalSecurityMeasuresPage.this.rootContainer.getShell(), (String)Messages.AdditionalSecurityMeasuresPage_15, (String)NLS.bind((String)Messages.AdditionalSecurityMeasuresPage_10, (Object)selectedMassnahmenUmsetzung.getTitle()));
                    if (confirmed) {
                        AdditionalSecurityMeasuresPage.this.deleteOwnControl(rsUmsetzung);
                        AdditionalSecurityMeasuresPage.this.refresh();
                    }
                }
            }
        });
    }

    @Override
    protected void addControls(Composite parent) {
        Composite controls = new Composite(parent, 65536);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(controls);
        GridDataFactory.fillDefaults().applyTo((Control)controls);
        this.addDeleteGefaehrdungButton(controls);
        Composite right = new Composite(controls, 0);
        GridLayoutFactory.fillDefaults().margins(DEFAULT_MARGINS).generateLayout(right);
        GridDataFactory.fillDefaults().grab(true, true).align(131072, 128).applyTo((Control)right);
        super.addButtons(right, Messages.AdditionalSecurityMeasuresPage_12);
        this.addFilters(right);
    }

    private void addDeleteGefaehrdungButton(Composite parent) {
        Group groupButtons = new Group(parent, 64);
        groupButtons.setText(Messages.AdditionalSecurityMeasuresPage_7);
        this.buttonRemoveControlFromScenario = new Button((Composite)groupButtons, 8);
        this.buttonRemoveControlFromScenario.setText(Messages.AdditionalSecurityMeasuresPage_8);
        GridDataFactory.fillDefaults().hint(ADD_EDIT_REMOVE_BUTTON_SIZE).applyTo((Control)this.buttonRemoveControlFromScenario);
        GridLayoutFactory.fillDefaults().margins(DEFAULT_MARGINS).generateLayout((Composite)groupButtons);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)groupButtons);
    }

    @Override
    protected void addFilters(Composite parent) {
        Composite compositeFilter = new Composite(parent, 0);
        this.buttonOwnGefaehrdungen = new Button(compositeFilter, 32);
        this.buttonOwnGefaehrdungen.setText(Messages.AdditionalSecurityMeasuresPage_19);
        this.buttonGefaehrdungen = new Button(compositeFilter, 32);
        this.buttonGefaehrdungen.setText(Messages.AdditionalSecurityMeasuresPage_20);
        Composite search = new Composite(compositeFilter, 0);
        new Label(search, 0).setText(Messages.ChooseGefaehrdungPage_10);
        this.textSearch = new Text(search, 2052);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(DEFAULT_MARGINS).generateLayout(search);
        GridLayoutFactory.fillDefaults().generateLayout(compositeFilter);
        GridDataFactory.fillDefaults().applyTo((Control)search);
        GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)compositeFilter);
    }

    class MassnahmenUmsetzungenFilter
    extends ViewerFilter {
        MassnahmenUmsetzungenFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof RisikoMassnahmenUmsetzung);
        }
    }

    class RisikoMassnahmenUmsetzungenFilter
    extends ViewerFilter {
        RisikoMassnahmenUmsetzungenFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof RisikoMassnahmenUmsetzung;
        }
    }
}

