/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.model;

import java.util.List;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.ITypedElement;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahme;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;
import sernet.verinice.service.commands.LoadGenericElementByType;
import sernet.verinice.service.commands.SaveElement;
import sernet.verinice.service.commands.crud.RemoveGenericElement;
import sernet.verinice.service.commands.task.FindRisikomassnahmeByNumber;

public final class RisikoMassnahmeHome {
    private static RisikoMassnahmeHome instance;
    private ICommandService commandService = ServiceFactory.lookupCommandService();

    private RisikoMassnahmeHome() {
    }

    public static synchronized RisikoMassnahmeHome getInstance() {
        if (instance == null) {
            instance = new RisikoMassnahmeHome();
        }
        return instance;
    }

    public RisikoMassnahme save(RisikoMassnahme mn) throws CommandException {
        SaveElement command = new SaveElement((ITypedElement)mn);
        command = (SaveElement)this.commandService.executeCommand((ICommand)command);
        return (RisikoMassnahme)command.getElement();
    }

    public void remove(RisikoMassnahme mn) throws CommandException {
        RemoveGenericElement command = new RemoveGenericElement((ITypedElement)mn);
        this.commandService.executeCommand((ICommand)command);
    }

    public List<RisikoMassnahme> loadAll() throws CommandException {
        LoadGenericElementByType command = new LoadGenericElementByType(RisikoMassnahme.class);
        command = (LoadGenericElementByType)this.commandService.executeCommand((ICommand)command);
        return command.getElements();
    }

    public RisikoMassnahme loadByNumber(String number) throws CommandException {
        FindRisikomassnahmeByNumber command = new FindRisikomassnahmeByNumber(number);
        command = (FindRisikomassnahmeByNumber)this.commandService.executeCommand((ICommand)command);
        return command.getMassnahme();
    }

    public void initRisikoMassnahmeUmsetzung(RisikoMassnahmenUmsetzung umsetzung) {
        if (umsetzung.isInitNeeded()) {
            try {
                umsetzung.setMassnahme(this.loadByNumber(umsetzung.getNumber()));
            }
            catch (CommandException e) {
                ExceptionUtil.log(e, "Fehler beim Datenzugriff");
            }
        }
    }
}

