/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.risikoanalyse.actions;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.risikoanalyse.wizard.RiskAnalysisWizard;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.IBSIStrukturKategorie;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27kElement;

public class NeueRisikoanalyseAction
implements IObjectActionDelegate {
    private static final Logger LOG = Logger.getLogger(NeueRisikoanalyseAction.class);
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction newAction, IWorkbenchPart newTargetPart) {
        this.targetPart = newTargetPart;
    }

    public void run(IAction action) {
        Activator.inheritVeriniceContextState();
        final Object selection = ((IStructuredSelection)this.targetPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (!(selection instanceof IBSIStrukturElement)) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    monitor.beginTask("\u00d6ffne wizard...", 1);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Activator.inheritVeriniceContextState();
                            CnATreeElement element = (CnATreeElement)selection;
                            Shell shell = Display.getDefault().getActiveShell();
                            RiskAnalysisWizard wizard = new RiskAnalysisWizard(element);
                            wizard.init(PlatformUI.getWorkbench(), null);
                            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                            wizardDialog.setPageSize(wizard.getWidth(), wizard.getHeight());
                            wizardDialog.open();
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Error while starting new Risikoanalyse", (Throwable)e);
            ExceptionUtil.log(e, "Fehler beim \u00d6ffnen der Risikoanalyse.");
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Error while starting new Risikoanalyse", (Throwable)e);
            ExceptionUtil.log(e, "Fehler beim \u00d6ffnen der Risikoanalyse.");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object sel = ((IStructuredSelection)selection).getFirstElement();
        if (sel instanceof IBSIStrukturKategorie) {
            action.setEnabled(false);
        } else if (sel instanceof IISO27kElement) {
            action.setEnabled(false);
        } else if (sel instanceof CnATreeElement) {
            boolean b = CnAElementHome.getInstance().isWriteAllowed((CnATreeElement)sel);
            if (action.isEnabled()) {
                action.setEnabled(b);
            }
        }
    }
}

