/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.common.model.PersonEntityOptionWrapper;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.Entity;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.IEntityResolverFactory;
import sernet.hui.common.connect.IReferenceResolver;
import sernet.hui.common.connect.ITypedElement;
import sernet.hui.common.connect.IUrlResolver;
import sernet.hui.common.connect.Property;
import sernet.hui.common.connect.PropertyGroup;
import sernet.hui.common.connect.PropertyOption;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.common.multiselectionlist.IMLPropertyOption;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.Person;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.LoadEntitiesByIds;
import sernet.verinice.service.commands.SaveElement;
import sernet.verinice.service.commands.crud.LoadCnAElementByEntityUuid;
import sernet.verinice.service.commands.crud.LoadCnAElementByType;
import sernet.verinice.service.commands.task.FindAllRoles;
import sernet.verinice.service.commands.task.FindHuiUrls;

public class BSIEntityResolverFactory
implements IEntityResolverFactory {
    private static final Logger LOG = Logger.getLogger(BSIEntityResolverFactory.class);
    private static final String STD_ERR_MSG = "Error while loading data";
    private static IReferenceResolver roleResolver;
    private static IReferenceResolver personResolver;
    private static IUrlResolver urlresolver;

    public void createResolvers(HUITypeFactory typeFactory) {
        BSIEntityResolverFactory.createPersonResolver();
        BSIEntityResolverFactory.createRoleResolver();
        Collection allEntityTypes = typeFactory.getAllEntityTypes();
        for (EntityType entityType : allEntityTypes) {
            List propertyTypes = entityType.getPropertyTypes();
            this.addPersonResolverToTypes(typeFactory, entityType, propertyTypes);
            this.addRoleResolverToTypes(typeFactory, entityType, propertyTypes);
            List groups = entityType.getPropertyGroups();
            for (PropertyGroup group : groups) {
                Collection typesInGroup = group.getPropertyTypes();
                this.addPersonResolverToTypes(typeFactory, entityType, typesInGroup);
                this.addRoleResolverToTypes(typeFactory, entityType, typesInGroup);
            }
        }
        BSIEntityResolverFactory.createUrlResolver(typeFactory);
        List types = typeFactory.getURLPropertyTypes();
        for (PropertyType type : types) {
            type.setUrlResolver(urlresolver);
        }
    }

    private void addPersonResolverToTypes(HUITypeFactory typeFactory, EntityType entityType, Collection<PropertyType> propertyTypes) {
        for (PropertyType propertyType : propertyTypes) {
            if (!propertyType.isReference() || !propertyType.getReferencedEntityTypeId().equals("person")) continue;
            typeFactory.getPropertyType(entityType.getId(), propertyType.getId()).setReferenceResolver(personResolver);
        }
    }

    private void addRoleResolverToTypes(HUITypeFactory typeFactory, EntityType entityType, Collection<PropertyType> propertyTypes) {
        for (PropertyType propertyType : propertyTypes) {
            if (!propertyType.isReference() || !propertyType.getReferencedEntityTypeId().equals("role")) continue;
            typeFactory.getPropertyType(entityType.getId(), propertyType.getId()).setReferenceResolver(roleResolver);
        }
    }

    private static void createUrlResolver(HUITypeFactory typeFactory) {
        HashSet<String> allIDs = new HashSet<String>();
        try {
            List types = typeFactory.getURLPropertyTypes();
            for (PropertyType type : types) {
                allIDs.add(type.getId());
            }
        }
        catch (Exception e) {
            return;
        }
        urlresolver = () -> {
            List result = Collections.emptyList();
            try {
                FindHuiUrls command = new FindHuiUrls(allIDs);
                command = (FindHuiUrls)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                result = command.getList();
            }
            catch (Exception e) {
                LOG.error((Object)STD_ERR_MSG, (Throwable)e);
            }
            return result;
        };
    }

    protected CnATreeElement loadElementByEntityUuid(String entityUuid) throws CommandException {
        LoadCnAElementByEntityUuid command = new LoadCnAElementByEntityUuid(entityUuid);
        command = (LoadCnAElementByEntityUuid)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
        return command.getElement();
    }

    private static void createPersonResolver() {
        if (personResolver == null) {
            personResolver = new IReferenceResolver(){

                public List<IMLPropertyOption> getAllEntitesForType(String entityTypeID) {
                    try {
                        LoadCnAElementByType command = new LoadCnAElementByType(Person.class);
                        command = (LoadCnAElementByType)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        List personen = command.getElements();
                        ArrayList<IMLPropertyOption> result = new ArrayList<IMLPropertyOption>(personen.size());
                        for (Person person : personen) {
                            result.add(new PersonEntityOptionWrapper(person.getEntity()));
                        }
                        return result;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading element", (Throwable)e);
                        throw new RuntimeCommandException(BSIEntityResolverFactory.STD_ERR_MSG, (Throwable)e);
                    }
                }

                public void addNewEntity(Entity parentEntity, String name) {
                }

                public List<IMLPropertyOption> getReferencedEntitesForType(String referencedEntityTypeId, List<Property> references) {
                    ArrayList<IMLPropertyOption> result = new ArrayList<IMLPropertyOption>();
                    ArrayList<Integer> dbIds = new ArrayList<Integer>(references.size());
                    for (Property prop : references) {
                        try {
                            dbIds.add(Integer.parseInt(prop.getPropertyValue()));
                        }
                        catch (NumberFormatException e) {
                            LOG.error((Object)("Error while resolving reference of a Person, the property type is: " + prop.getPropertyTypeID() + " the property value is: " + prop.getPropertyValue() + " the referenced entity type is: " + referencedEntityTypeId));
                            throw e;
                        }
                    }
                    LoadEntitiesByIds command = new LoadEntitiesByIds(dbIds);
                    try {
                        command = (LoadEntitiesByIds)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        List personen = command.getEntities();
                        for (Entity person : personen) {
                            result.add(new PersonEntityOptionWrapper(person));
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading elements", (Throwable)e);
                        throw new RuntimeCommandException(BSIEntityResolverFactory.STD_ERR_MSG, (Throwable)e);
                    }
                    return result;
                }

                public void createLinks(String referencedEntityType, String linkType, String entityUuid) {
                }

                public String getTitlesOfLinkedObjects(String referencedCnaLinkType, String entityUuid) {
                    return null;
                }
            };
        }
    }

    private static void createRoleResolver() {
        if (roleResolver == null) {
            roleResolver = new IReferenceResolver(){

                public List<IMLPropertyOption> getAllEntitesForType(String entityTypeID) {
                    ArrayList<IMLPropertyOption> result = new ArrayList<IMLPropertyOption>();
                    try {
                        FindAllRoles far = new FindAllRoles(false);
                        far = (FindAllRoles)ServiceFactory.lookupCommandService().executeCommand((ICommand)far);
                        for (String role : far.getRoles()) {
                            if (role.length() <= 0) continue;
                            result.add((IMLPropertyOption)new PropertyOption(role, role));
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading roles", (Throwable)e);
                        throw new RuntimeCommandException(BSIEntityResolverFactory.STD_ERR_MSG, (Throwable)e);
                    }
                    return result;
                }

                public void addNewEntity(Entity parentEntity, String newName) {
                    try {
                        PropertyType type = HitroUtil.getInstance().getTypeFactory().getPropertyType("configuration", "configuration_rolle");
                        parentEntity.createNewProperty(type, newName);
                        SaveElement command = new SaveElement((ITypedElement)parentEntity);
                        ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    }
                    catch (CommandException e) {
                        LOG.error((Object)"Error while saving elements", (Throwable)e);
                        throw new RuntimeCommandException(BSIEntityResolverFactory.STD_ERR_MSG, (Throwable)e);
                    }
                }

                public List<IMLPropertyOption> getReferencedEntitesForType(String referencedEntityTypeId, List<Property> references) {
                    return null;
                }

                public String getTitlesOfLinkedObjects(String referencedCnaLinkType, String uuid) {
                    return null;
                }

                public void createLinks(String referencedEntityType, String linkType, String entityUuid) {
                }
            };
        }
    }
}

