/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.filter;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import sernet.gs.ui.rcp.main.bsi.filter.Messages;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.ITVerbund;

public class TagFilter
extends ViewerFilter {
    public static final String NO_TAG = Messages.TagFilter_0;
    private String[] pattern;
    private StructuredViewer viewer;
    private boolean filterItVerbund;

    public TagFilter(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof IBSIStrukturElement) || element instanceof ITVerbund && !this.filterItVerbund) {
            return true;
        }
        IBSIStrukturElement zielobjekt = (IBSIStrukturElement)element;
        String[] stringArray = this.pattern;
        int n = this.pattern.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (tag.equals(NO_TAG) && zielobjekt.getTags().size() < 1) {
                return true;
            }
            for (String zielTag : zielobjekt.getTags()) {
                if (!zielTag.equals(tag)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getPattern() {
        return this.pattern != null ? (String[])this.pattern.clone() : null;
    }

    public void setPattern(String[] newPattern) {
        boolean active;
        boolean bl = active = this.pattern != null;
        if (newPattern != null && newPattern.length > 0) {
            this.pattern = (String[])newPattern.clone();
            if (active) {
                this.viewer.refresh();
            } else {
                this.viewer.addFilter((ViewerFilter)this);
                active = true;
            }
            return;
        }
        this.pattern = null;
        if (active) {
            this.viewer.removeFilter((ViewerFilter)this);
        }
    }

    public boolean isFilterItVerbund() {
        return this.filterItVerbund;
    }

    public void setFilterItVerbund(boolean filterItVerbund) {
        this.filterItVerbund = filterItVerbund;
    }
}

