/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import sernet.hui.common.connect.Entity;
import sernet.verinice.model.common.CnATreeElement;

public class StringPropertyFilter
extends ViewerFilter {
    private StructuredViewer viewer;
    private String pattern = null;
    protected String propertyType;
    protected Pattern regex;

    public StringPropertyFilter(StructuredViewer viewer, String type) {
        this.viewer = viewer;
        this.propertyType = type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String newPattern) {
        boolean active;
        boolean bl = active = this.pattern != null;
        if (newPattern != null && newPattern.length() > 0) {
            this.pattern = newPattern;
            this.regex = Pattern.compile(this.pattern, 2);
            if (active) {
                this.viewer.refresh();
            } else {
                this.viewer.addFilter((ViewerFilter)this);
                active = true;
            }
            return;
        }
        this.pattern = null;
        this.regex = null;
        if (active) {
            this.viewer.removeFilter((ViewerFilter)this);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof CnATreeElement)) {
            return true;
        }
        Entity entity = ((CnATreeElement)element).getEntity();
        String value = entity.getPropertyValue(this.propertyType);
        Matcher matcher = this.regex.matcher(value);
        return matcher.find();
    }
}

