/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.filter;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import sernet.gs.model.Massnahme;
import sernet.verinice.model.bsi.IMassnahmeUmsetzung;

public class MassnahmenSiegelFilter
extends ViewerFilter {
    private StructuredViewer viewer;
    private Set<String> siegelPattern;

    public MassnahmenSiegelFilter(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public Set getPatternSet() {
        return this.siegelPattern;
    }

    public String[] getPattern() {
        return this.siegelPattern != null ? this.siegelPattern.toArray(new String[this.siegelPattern.size()]) : new String[]{};
    }

    public void setPattern(String[] newPattern) {
        boolean active;
        boolean bl = active = this.siegelPattern != null;
        if (newPattern != null && newPattern.length > 0) {
            this.siegelPattern = new HashSet<String>();
            String[] stringArray = newPattern;
            int n = newPattern.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.siegelPattern.add(type);
                ++n2;
            }
            if (active) {
                this.viewer.refresh();
            } else {
                this.viewer.addFilter((ViewerFilter)this);
                active = true;
            }
            return;
        }
        this.siegelPattern = null;
        if (active) {
            this.viewer.removeFilter((ViewerFilter)this);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof IMassnahmeUmsetzung) && !(element instanceof Massnahme)) {
            return true;
        }
        if (element instanceof IMassnahmeUmsetzung) {
            IMassnahmeUmsetzung mn = (IMassnahmeUmsetzung)element;
            return this.siegelPattern.contains(Character.toString(mn.getStufe()));
        }
        Massnahme mn = (Massnahme)element;
        return this.siegelPattern.contains(Character.toString(mn.getSiegelstufe()));
    }
}

