/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.filter;

import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.Massnahme;
import sernet.gs.ui.rcp.main.bsi.filter.TextFilter;

public class BSISearchFilter
extends TextFilter {
    public BSISearchFilter(StructuredViewer viewer) {
        super(viewer);
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.getRegex() == null) {
            return true;
        }
        if (element instanceof Baustein) {
            Baustein bs = (Baustein)element;
            Matcher matcher = this.getRegex().matcher(bs.getTitel());
            if (matcher.find()) {
                return true;
            }
            return this.checkMassnahmen(bs) || this.checkGefaehrdungen(bs);
        }
        if (element instanceof Massnahme) {
            Massnahme mn = (Massnahme)element;
            Matcher matcher = this.getRegex().matcher(mn.getTitel());
            return matcher.find();
        }
        if (element instanceof Gefaehrdung) {
            Gefaehrdung gef = (Gefaehrdung)element;
            Matcher matcher = this.getRegex().matcher(gef.getTitel());
            return matcher.find();
        }
        return false;
    }

    private boolean checkMassnahmen(Baustein bs) {
        List massnahmen = bs.getMassnahmen();
        for (Massnahme mn : massnahmen) {
            Matcher matcher = this.getRegex().matcher(mn.getTitel());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private boolean checkGefaehrdungen(Baustein bs) {
        List gefaehrdungen = bs.getGefaehrdungen();
        for (Gefaehrdung gefaehrdung : gefaehrdungen) {
            Matcher m = this.getRegex().matcher(gefaehrdung.getTitel());
            if (!m.find()) continue;
            return true;
        }
        return false;
    }
}

