/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.filter;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class BSIModelElementFilter
extends ViewerFilter {
    private StructuredViewer viewer;
    private Set<Class<?>> filteredClasses;

    public BSIModelElementFilter(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public Set<Class<?>> getFilteredClasses() {
        if (this.filteredClasses == null) {
            return new HashSet();
        }
        return new HashSet(this.filteredClasses);
    }

    public void setFilteredClasses(Set<Class<?>> newFilteredClasses) {
        boolean active;
        boolean bl = active = this.filteredClasses != null;
        if (newFilteredClasses != null && !newFilteredClasses.isEmpty()) {
            this.filteredClasses = newFilteredClasses;
            if (active) {
                this.viewer.refresh();
            } else {
                this.viewer.addFilter((ViewerFilter)this);
                active = true;
            }
        } else {
            this.filteredClasses = null;
            if (active) {
                this.viewer.removeFilter((ViewerFilter)this);
            }
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return !this.filteredClasses.contains(element.getClass());
    }

    public boolean isEmpty() {
        return this.filteredClasses == null || this.filteredClasses.isEmpty();
    }
}

