/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.editors.LinkMaker;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.verinice.model.common.CnALink;

final class RemoveLinkSelectionListener
implements SelectionListener {
    private static final Logger LOGGER = Logger.getLogger(RemoveLinkSelectionListener.class);
    private final LinkMaker linkMaker;

    public RemoveLinkSelectionListener(LinkMaker linkMaker) {
        this.linkMaker = linkMaker;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.linkMaker.viewer.getSelection().isEmpty()) {
            return;
        }
        List selection = ((IStructuredSelection)this.linkMaker.viewer.getSelection()).toList();
        String msg = NLS.bind((String)Messages.LinkMaker_6, (Object)selection.size());
        boolean confirm = MessageDialog.openConfirm((Shell)this.linkMaker.getShell(), (String)Messages.LinkMaker_5, (String)msg);
        if (!confirm) {
            return;
        }
        CnALink link = null;
        for (Object object : selection) {
            link = (CnALink)object;
            try {
                CnAElementHome.getInstance().remove(link);
                this.linkMaker.inputElmt.removeLinkDown(link);
            }
            catch (Exception e1) {
                LOGGER.error((Object)"Error while removing link", (Throwable)e1);
                ExceptionUtil.log(e1, Messages.LinkMaker_7);
            }
        }
        if (link != null) {
            if (CnAElementFactory.isModelLoaded()) {
                CnAElementFactory.getLoadedModel().linkRemoved(link);
            }
            CnAElementFactory.getInstance().getISO27kModel().linkRemoved(link);
            if (CnAElementFactory.isBpModelLoaded()) {
                CnAElementFactory.getInstance().getBpModel().linkRemoved(link);
            }
        }
    }
}

