/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.gs.ui.rcp.main.bsi.views.RelationTableViewer;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.task.FindRelationsFor;

final class ReloadLinksWorkspaceJob
extends WorkspaceJob {
    private static final Logger LOGGER = Logger.getLogger(ReloadLinksWorkspaceJob.class);
    private final CnATreeElement inputElement;
    private final RelationTableViewer viewer;

    ReloadLinksWorkspaceJob(CnATreeElement inputElement, RelationTableViewer viewer, String name) {
        super(name);
        this.inputElement = inputElement;
        this.viewer = viewer;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        Activator.inheritVeriniceContextState();
        try {
            monitor.setTaskName(Messages.LinkMaker_11);
            FindRelationsFor command = new FindRelationsFor(this.inputElement);
            command = (FindRelationsFor)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            CnATreeElement linkElmt = command.getElmt();
            Display.getDefault().asyncExec(() -> {
                if (!this.viewer.getControl().isDisposed()) {
                    this.viewer.setInput(linkElmt);
                }
            });
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(() -> this.viewer.setInput(new PlaceHolder(Messages.LinkMaker_12)));
            LOGGER.error((Object)"Error while searching relations", (Throwable)e);
            ExceptionUtil.log(e, Messages.LinkMaker_13);
        }
        return Status.OK_STATUS;
    }
}

