/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.editors.EditorRegistry;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.NoteEditorInput;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.IEntityChangedListener;
import sernet.hui.common.connect.PropertyChangedEvent;
import sernet.hui.common.multiselectionlist.IMLPropertyOption;
import sernet.hui.common.multiselectionlist.IMLPropertyType;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.bsi.Addition;
import sernet.verinice.model.bsi.Note;
import sernet.verinice.service.commands.SaveNote;

public class NoteEditor
extends EditorPart {
    private static final Logger LOG = Logger.getLogger(NoteEditor.class);
    public static final String EDITOR_ID = "sernet.gs.ui.rcp.main.bsi.editors.noteeditor";
    private Note note;
    private Text textNote;
    private ICommandService commandService;
    private boolean isModelModified = false;
    private IEntityChangedListener modelListener = new IEntityChangedListener(){

        public void dependencyChanged(IMLPropertyType arg0, IMLPropertyOption arg1) {
        }

        public void selectionChanged(IMLPropertyType arg0, IMLPropertyOption arg1) {
            NoteEditor.this.modelChanged();
        }

        public void propertyChanged(PropertyChangedEvent evt) {
            NoteEditor.this.modelChanged();
        }
    };

    void modelChanged() {
        boolean wasDirty = this.isDirty();
        this.isModelModified = true;
        if (!wasDirty) {
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.isModelModified;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.NoteEditor_0, -1);
        Set listener = this.note.getListener();
        SaveNote command = new SaveNote((Addition)this.note);
        try {
            command = (SaveNote)this.getCommandService().executeCommand((ICommand)command);
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while saving note", (Throwable)e);
            ExceptionUtil.log(e, Messages.NoteEditor_1);
        }
        monitor.done();
        this.note = (Note)command.getAddition();
        this.note.getListener().addAll(listener);
        this.isModelModified = false;
        this.firePropertyChange(257);
        this.note.getEntity().addChangeListener(this.modelListener);
        this.setPartName(this.note.getTitel());
        this.note.fireChange();
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof NoteEditorInput)) {
            throw new PartInitException(Messages.NoteEditor_2);
        }
        NoteEditorInput noteEditorInput = (NoteEditorInput)input;
        this.note = noteEditorInput.getInput();
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(noteEditorInput);
        this.setPartName(noteEditorInput.getName());
        noteEditorInput.getInput().getEntity().addChangeListener(this.modelListener);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        int contentCompLayoutMarginWidth = 5;
        int contentCompLayoutMarginHeight = 5;
        int contentCompLayoutHorizontalSpacing = 5;
        int contentCompLayoutVerticalSpacing = 5;
        int contentCompLayoutNumColumns = 2;
        int gdTextHeightHint = 200;
        Composite contentComp = new Composite(parent, 0);
        GridData contentCompLD = new GridData();
        contentCompLD.grabExcessHorizontalSpace = true;
        contentCompLD.horizontalAlignment = 4;
        contentCompLD.grabExcessHorizontalSpace = true;
        contentComp.setLayoutData((Object)contentCompLD);
        GridLayout contentCompLayout = new GridLayout(2, false);
        contentCompLayout.marginWidth = 5;
        contentCompLayout.marginHeight = 5;
        contentCompLayout.numColumns = 2;
        contentCompLayout.horizontalSpacing = 5;
        contentCompLayout.verticalSpacing = 5;
        contentComp.setLayout((Layout)contentCompLayout);
        GridData gdElement = new GridData();
        gdElement.grabExcessHorizontalSpace = true;
        gdElement.horizontalAlignment = 4;
        gdElement.horizontalSpan = 2;
        Label labelElement = new Label(contentComp, 128);
        labelElement.setText(String.valueOf(Messages.NoteEditor_3) + this.note.getCnAElementTitel());
        labelElement.setLayoutData((Object)gdElement);
        Label labelTitle = new Label(contentComp, 128);
        labelTitle.setText(Messages.NoteEditor_4);
        GridData gdTitel = new GridData();
        gdTitel.grabExcessHorizontalSpace = true;
        gdTitel.grabExcessVerticalSpace = false;
        gdTitel.horizontalAlignment = 4;
        gdTitel.verticalAlignment = 1;
        Text title = new Text(contentComp, 2048);
        title.setLayoutData((Object)gdTitel);
        title.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Text field = (Text)e.widget;
                NoteEditor.this.note.setTitel(field.getText());
            }
        });
        Label labelNote = new Label(contentComp, 128);
        labelNote.setText(Messages.NoteEditor_5);
        GridData gdText = new GridData();
        gdText.grabExcessHorizontalSpace = true;
        gdText.grabExcessVerticalSpace = false;
        gdText.horizontalAlignment = 4;
        gdText.verticalAlignment = 2;
        gdText.heightHint = 200;
        this.textNote = new Text(contentComp, 2626);
        this.textNote.setLayoutData((Object)gdText);
        this.textNote.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Text field = (Text)e.widget;
                NoteEditor.this.note.setText(field.getText());
            }
        });
        if (this.note != null) {
            if (this.note.getTitel() != null) {
                title.setText(this.note.getTitel());
            }
            if (this.note.getText() != null) {
                this.textNote.setText(this.note.getText());
            }
        }
        contentComp.pack();
        contentComp.layout();
    }

    public void setFocus() {
        this.textNote.setFocus();
    }

    public void dispose() {
        EditorRegistry.getInstance().closeEditor(String.valueOf(((NoteEditorInput)this.getEditorInput()).getId()));
        super.dispose();
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }
}

