/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.WorkbenchPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.editors.CreateLinkSelectionListener;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.editors.EntityTypeFilter;
import sernet.gs.ui.rcp.main.bsi.editors.LinkRemover;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.ReloadLinksWorkspaceJob;
import sernet.gs.ui.rcp.main.bsi.editors.RemoveLinkSelectionListener;
import sernet.gs.ui.rcp.main.bsi.views.IRelationTable;
import sernet.gs.ui.rcp.main.bsi.views.RelationComparator;
import sernet.gs.ui.rcp.main.bsi.views.RelationTableViewer;
import sernet.gs.ui.rcp.main.bsi.views.RelationViewContentProvider;
import sernet.gs.ui.rcp.main.bsi.views.RelationViewLabelProvider;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.DirectedHuiRelation;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.HuiRelation;
import sernet.hui.common.connect.HuiRelationUtil;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27KModelListener;

public class LinkMaker
extends Composite
implements IRelationTable {
    static final String LAST_SELECTED_RELATION_PREF_PREFIX = "last_selected_relation_for";
    private static final int COMPOSITE_WIDTH_HINT = 400;
    RelationTableViewer viewer;
    private WorkbenchPart part;
    Combo comboElementType;
    private Button addLinkButton;
    private Button removeLinkButton;
    final ComboViewer relationComboViewer;
    static IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
    private static HUITypeFactory huiTypeFactory = HitroUtil.getInstance().getTypeFactory();
    private EntityTypeFilter entityTypeFilter;
    private LinkRemover linkRemover;
    private RelationViewContentProvider relationViewContentProvider;
    private RelationViewLabelProvider relationViewLabelProvider;
    CnATreeElement inputElmt;
    SortedMap<String, String> elementTypeNamesAndIds;
    String selectedElementTypeId;
    private List<HuiRelation> allPossibleRelations;
    private String[] elementTypeNames;
    private int oldSelection = -1;
    private boolean writeable;
    private IPropertyChangeListener proceedingFilterDisabledToggleListener;
    private Composite composite;

    public LinkMaker(Composite parent, WorkbenchPart part) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout());
        this.part = part;
        this.composite = new Composite((Composite)this, 0);
        GridData gdComposite = new GridData(4, 128, true, false, 1, 1);
        gdComposite.widthHint = 400;
        gdComposite.verticalIndent = 1;
        gdComposite.minimumWidth = 400;
        this.composite.setLayoutData((Object)gdComposite);
        this.composite.setLayout((Layout)new GridLayout(5, false));
        Label label = new Label(this.composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        label.setText(Messages.LinkMaker_0);
        this.comboElementType = new Combo(this.composite, 8);
        this.comboElementType.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.relationComboViewer = new ComboViewer(this.composite, 8);
        Combo combo = this.relationComboViewer.getCombo();
        GridData gdCombo1 = new GridData(4, 0x1000000, false, false, 1, 1);
        combo.setLayoutData((Object)gdCombo1);
        this.relationComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.relationComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DirectedHuiRelation) {
                    DirectedHuiRelation relation = (DirectedHuiRelation)element;
                    return relation.getLabel();
                }
                return "unknown object type";
            }
        });
        combo.setEnabled(false);
        this.relationComboViewer.setInput(Collections.singleton(""));
        this.addRelationComboListener();
        this.addLinkButton = new Button(this.composite, 8);
        this.addLinkButton.setText(Messages.LinkMaker_1);
        this.addLinkButton.setToolTipText(Messages.LinkMaker_2);
        this.addLinkButton.setEnabled(false);
        this.removeLinkButton = new Button(this.composite, 8);
        this.removeLinkButton.setText(Messages.LinkMaker_3);
        this.removeLinkButton.setToolTipText(Messages.LinkMaker_4);
    }

    public void createPartControl(Boolean isWriteAllowed) {
        this.writeable = isWriteAllowed;
        this.removeLinkButton.setEnabled(this.writeable && LinkMaker.checkRights());
        this.initLinkTableViewer();
        CnAElementFactory.getLoadedModel().addBSIModelListener((IBSIModelListener)this.relationViewContentProvider);
        CnAElementFactory.getInstance().getISO27kModel().addISO27KModelListener((IISO27KModelListener)this.relationViewContentProvider);
        CnAElementFactory.getInstance().getBpModel().addModITBOModelListener((IBpModelListener)this.relationViewContentProvider);
        this.proceedingFilterDisabledToggleListener = event -> {
            if ("filter_information_networks_by_proceeding".equals(event.getProperty())) {
                this.viewer.refresh();
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.proceedingFilterDisabledToggleListener);
        this.linkRemover = new LinkRemover(this);
        CnAElementFactory.getLoadedModel().addBSIModelListener((IBSIModelListener)this.linkRemover);
        CnAElementFactory.getInstance().getISO27kModel().addISO27KModelListener((IISO27KModelListener)this.linkRemover);
        CnAElementFactory.getInstance().getBpModel().addModITBOModelListener((IBpModelListener)this.linkRemover);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)1);
        List<RelationTableViewer.PathCellLabelProvider> cellLabelProviders = this.viewer.initToolTips(this.relationViewLabelProvider, this);
        this.addResizeListener(cellLabelProviders);
        CreateLinkSelectionListener linkAction = new CreateLinkSelectionListener(this);
        RemoveLinkSelectionListener unlinkAction = new RemoveLinkSelectionListener(this);
        this.addLinkButton.addSelectionListener((SelectionListener)linkAction);
        this.removeLinkButton.addSelectionListener((SelectionListener)unlinkAction);
        this.createFilter();
        this.hookDoubleClickAction();
    }

    private void initLinkTableViewer() {
        this.viewer = new RelationTableViewer(this, this, 65538, true);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.getTable().setEnabled(this.writeable);
        this.relationViewContentProvider = new RelationViewContentProvider(this, this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.relationViewContentProvider);
        this.relationViewLabelProvider = new RelationViewLabelProvider(this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.relationViewLabelProvider);
        this.viewer.setComparator(new RelationComparator("_title", "_type_img"));
        this.part.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void addResizeListener(final List<RelationTableViewer.PathCellLabelProvider> cellLabelProviders) {
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                for (RelationTableViewer.PathCellLabelProvider c : cellLabelProviders) {
                    c.updateShellWidthAndX(LinkMaker.this.getShell().getBounds().width, LinkMaker.this.getShell().getBounds().x);
                }
            }
        });
    }

    private void createFilter() {
        this.entityTypeFilter = new EntityTypeFilter((StructuredViewer)this.viewer);
        this.comboElementType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinkMaker.this.oldSelection = LinkMaker.this.comboElementType.getSelectionIndex();
                LinkMaker.this.setFilter(LinkMaker.this.comboElementType.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void setFilter(int selectionIndex) {
        if (selectionIndex == 0) {
            this.entityTypeFilter.setEntityType(null);
            this.addLinkButton.setEnabled(false);
            this.relationComboViewer.getCombo().setEnabled(false);
            return;
        }
        Object[] array = this.elementTypeNamesAndIds.entrySet().toArray();
        Map.Entry entry = (Map.Entry)array[selectionIndex];
        this.selectedElementTypeId = (String)entry.getValue();
        this.entityTypeFilter.setEntityType(this.selectedElementTypeId);
        this.addLinkButton.setEnabled(this.writeable && LinkMaker.checkRights());
        this.fillRelationCombo();
    }

    private void fillRelationCombo() {
        String sourceEntityTypeId = this.inputElmt.getEntityType().getId();
        String targetEntityTypeId = this.selectedElementTypeId;
        Set relations = HuiRelationUtil.getAllRelationsBothDirections((String)sourceEntityTypeId, (String)targetEntityTypeId);
        this.relationComboViewer.setInput((Object)relations);
        int relationItemCount = this.relationComboViewer.getCombo().getItemCount();
        if (relationItemCount <= 1) {
            this.relationComboViewer.getCombo().setEnabled(false);
        } else {
            this.relationComboViewer.getCombo().setEnabled(true);
        }
        this.addLinkButton.setEnabled(relationItemCount > 0 && this.writeable && LinkMaker.checkRights());
        this.selectRelationType();
        this.composite.pack(true);
    }

    private void selectRelationType() {
        Object firstElementInRelationCombo = this.relationComboViewer.getElementAt(0);
        this.relationComboViewer.setSelection((ISelection)new StructuredSelection(firstElementInRelationCombo));
        String prefStoreKey = LAST_SELECTED_RELATION_PREF_PREFIX + this.inputElmt.getTypeId() + this.selectedElementTypeId;
        if (prefStore.contains(prefStoreKey)) {
            String relationId = prefStore.getString(prefStoreKey);
            Object comboItems = this.relationComboViewer.getInput();
            if (comboItems instanceof Set) {
                for (Object item : (Set)comboItems) {
                    this.setSelection(item, relationId);
                }
            }
        }
    }

    private void setSelection(Object item, String relationId) {
        DirectedHuiRelation relation;
        if (item instanceof DirectedHuiRelation && (relation = (DirectedHuiRelation)item).getHuiRelation().getId().equals(relationId)) {
            this.relationComboViewer.setSelection((ISelection)new StructuredSelection((Object)relation));
        }
    }

    private void addRelationComboListener() {
        this.relationComboViewer.addSelectionChangedListener(event -> {
            StructuredSelection selection = (StructuredSelection)this.relationComboViewer.getSelection();
            DirectedHuiRelation selectedRelation = (DirectedHuiRelation)selection.getFirstElement();
            this.addLinkButton.setEnabled(this.writeable && selectedRelation != null);
        });
    }

    private void initNamesForElementTypeCombo() {
        this.elementTypeNamesAndIds = new TreeMap<String, String>();
        if (this.allPossibleRelations == null) {
            this.elementTypeNames = new String[0];
        } else {
            for (HuiRelation huiRelation : this.allPossibleRelations) {
                String targetEntityTypeID = huiRelation.getTo();
                String sourceEntityTypeID = huiRelation.getFrom();
                String targetEntityTypeName = huiTypeFactory.getEntityType(targetEntityTypeID).getName();
                String sourceEntityTypeName = huiTypeFactory.getEntityType(sourceEntityTypeID).getName();
                if (sourceEntityTypeID.equals(this.inputElmt.getEntity().getEntityType())) {
                    this.elementTypeNamesAndIds.put(targetEntityTypeName, targetEntityTypeID);
                    continue;
                }
                this.elementTypeNamesAndIds.put(sourceEntityTypeName, sourceEntityTypeID);
            }
        }
        this.elementTypeNamesAndIds.put(Messages.LinkMaker_8, null);
        Set<String> namesSet = this.elementTypeNamesAndIds.keySet();
        this.elementTypeNames = new String[namesSet.size()];
        this.elementTypeNames = namesSet.toArray(new String[namesSet.size()]);
    }

    private void fillPossibleLinkLists() {
        this.allPossibleRelations = new ArrayList<HuiRelation>();
        String entityTypeID = this.inputElmt.getEntity().getEntityType();
        this.allPossibleRelations.addAll(huiTypeFactory.getPossibleRelationsFrom(entityTypeID));
        this.allPossibleRelations.addAll(huiTypeFactory.getPossibleRelationsTo(entityTypeID));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(event -> {
            ISelection selection = event.getViewer().getSelection();
            if (!selection.isEmpty()) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                CnALink link = (CnALink)obj;
                if (CnALink.isDownwardLink((CnATreeElement)this.getInputElmt(), (CnALink)link)) {
                    EditorFactory.getInstance().updateAndOpenObject(link.getDependency());
                } else {
                    EditorFactory.getInstance().updateAndOpenObject(link.getDependant());
                }
            }
        });
    }

    @Override
    public CnATreeElement getInputElmt() {
        return this.inputElmt;
    }

    @Override
    public void reload(CnALink oldLink, CnALink newLink) {
        if (newLink != null) {
            newLink.setDependant(oldLink.getDependant());
            newLink.setDependency(oldLink.getDependency());
        }
        boolean removedLinkDown = this.inputElmt.removeLinkDown(oldLink);
        boolean removedLinkUp = this.inputElmt.removeLinkUp(oldLink);
        if (removedLinkUp) {
            this.inputElmt.addLinkUp(newLink);
        }
        if (removedLinkDown) {
            this.inputElmt.addLinkDown(newLink);
        }
        this.viewer.refresh();
    }

    @Override
    public void setInputElmt(CnATreeElement inputElmt) {
        if (inputElmt == null || this.inputElmt == inputElmt) {
            return;
        }
        if (this.oldSelection == -1) {
            this.oldSelection = this.comboElementType.getSelectionIndex();
        }
        this.inputElmt = inputElmt;
        this.fillPossibleLinkLists();
        this.initNamesForElementTypeCombo();
        this.comboElementType.setItems(this.elementTypeNames);
        if (this.oldSelection != -1 && this.oldSelection < this.comboElementType.getItemCount()) {
            this.comboElementType.select(this.oldSelection);
            this.setFilter(this.comboElementType.getSelectionIndex());
        }
        this.viewer.setInput(inputElmt);
    }

    @Override
    public void reloadAll() {
        this.reloadLinks();
    }

    void reloadLinks() {
        if (!CnAElementHome.getInstance().isOpen() || this.inputElmt == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            if (!this.viewer.getControl().isDisposed()) {
                this.viewer.setInput(new PlaceHolder(Messages.LinkMaker_9));
            }
        });
        ReloadLinksWorkspaceJob job = new ReloadLinksWorkspaceJob(this.inputElmt, this.viewer, Messages.LinkMaker_10);
        job.setUser(false);
        job.schedule();
    }

    public void dispose() {
        CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this.relationViewContentProvider);
        CnAElementFactory.getInstance().getISO27kModel().removeISO27KModelListener((IISO27KModelListener)this.relationViewContentProvider);
        CnAElementFactory.getInstance().getBpModel().removeBpModelListener((IBpModelListener)this.relationViewContentProvider);
        CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this.linkRemover);
        CnAElementFactory.getInstance().getISO27kModel().removeISO27KModelListener((IISO27KModelListener)this.linkRemover);
        CnAElementFactory.getInstance().getBpModel().removeBpModelListener((IBpModelListener)this.linkRemover);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.proceedingFilterDisabledToggleListener);
        super.dispose();
    }

    private static String getRightID() {
        return "editlinks";
    }

    private static boolean checkRights() {
        if (LinkMaker.getRightID() == null) {
            return true;
        }
        if ("".equals(LinkMaker.getRightID())) {
            return false;
        }
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(LinkMaker.getRightID());
    }
}

