/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.PropertyGroup;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.swt.widgets.HitroUIComposite;
import sernet.hui.swt.widgets.IInputHelper;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.model.bsi.Person;
import sernet.verinice.model.bsi.Schutzbedarf;

public final class InputHelperFactory {
    private static IInputHelper schutzbedarfHelper;
    private static IInputHelper tagHelper;
    private static IInputHelper personHelper;

    public static void setInputHelpers(EntityType entityType, HitroUIComposite huiComposite2) {
        if (personHelper == null) {
            personHelper = () -> {
                try {
                    List<Person> personen = CnAElementHome.getInstance().getPersonen();
                    if (personen.isEmpty()) {
                        return new IContentProposal[]{new ContentProposal(Messages.InputHelperFactory_0)};
                    }
                    return (IContentProposal[])personen.stream().map(Person::getTitle).map(ContentProposal::new).toArray(IContentProposal[]::new);
                }
                catch (CommandException e) {
                    ExceptionUtil.log(e, Messages.InputHelperFactory_1);
                    return new IContentProposal[]{new ContentProposal(Messages.InputHelperFactory_0)};
                }
            };
        }
        if (tagHelper == null) {
            tagHelper = () -> {
                try {
                    return (IContentProposal[])CnAElementHome.getInstance().getTags().stream().map(ContentProposal::new).toArray(IContentProposal[]::new);
                }
                catch (CommandException e) {
                    ExceptionUtil.log(e, Messages.InputHelperFactory_5);
                    return new IContentProposal[0];
                }
            };
        }
        if (schutzbedarfHelper == null) {
            schutzbedarfHelper = () -> new IContentProposal[]{new ContentProposal(Messages.InputHelperFactory_4), new ContentProposal(Messages.InputHelperFactory_2), new ContentProposal(Messages.InputHelperFactory_3)};
        }
        boolean showHint = Activator.getDefault().getPluginPreferences().getBoolean("cna_inputhelperhints");
        Stream.of("anwendung_tag", "client_tag", "gebaeude_tag", "netzkomponente_tag", "person_tag", "raum_tag", "server_tag", "sonstit_tag", "tkkomponente_tag", "itverbund_tag", "asset_tag", "audit_tag", "control_tag", "document_tag", "evidence_tag", "exception_tag", "finding_tag", "incident_tag", "incident_scenario_tag", "interview_tag", "person-iso_tag", "process_tag", "record_tag", "requirement_tag", "response_tag", "threat_tag", "vulnerability_tag", "org_tag", "bp_application_tag", "bp_application_group_tag", "bp_document_tag", "bp_document_group_tag", "bp_incident_tag", "bp_incident_group_tag", "bp_person_tag", "bp_person_group_tag", "bp_record_tag", "bp_record_group_tag", "bp_requirement_tag", "bp_requirement_group_tag", "bp_threat_tag", "bp_threat_group_tag", "bp_businessprocess_tag", "bp_businessprocess_group_tag", "bp_device_tag", "bp_device_group_tag", "bp_icssystem_tag", "bp_icssystem_group_tag", "bp_itnetwork_tag", "bp_itsystem_tag", "bp_itsystem_group_tag", "bp_network_tag", "bp_network_group_tag", "bp_room_tag", "bp_room_group_tag", "bp_safeguard_tag", "bp_safeguard_group_tag").forEach(propertyName -> huiComposite2.setInputHelper(propertyName, tagHelper, 1, showHint));
        InputHelperFactory.setSchutzbedarfHelpers(entityType, huiComposite2, showHint);
    }

    private static void setSchutzbedarfHelpers(EntityType entityType, HitroUIComposite huiComposite2, boolean showHint) {
        for (PropertyGroup group : entityType.getPropertyGroups()) {
            for (PropertyType type : group.getPropertyTypes()) {
                if (!Schutzbedarf.isIntegritaetBegruendung((String)type.getId()) && !Schutzbedarf.isVerfuegbarkeitBegruendung((String)type.getId()) && !Schutzbedarf.isVertraulichkeitBegruendung((String)type.getId())) continue;
                huiComposite2.setInputHelper(type.getId(), schutzbedarfHelper, 0, showHint);
            }
        }
    }

    private InputHelperFactory() {
    }
}

