/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import sernet.gs.service.StringUtil;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.verinice.model.bp.DeductionImplementationUtil;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.CnATreeElementLabelGenerator;

public final class EditorUtil {
    private static final Logger logger = Logger.getLogger(EditorUtil.class);
    private static final int MAX_TITLE_LENGTH = 20;
    public static final String EMPTY_EDITOR_ID = "org.eclipse.ui.internal.emptyEditorTab";

    private EditorUtil() {
    }

    public static void closeEditorForElement(String uuid) {
        Stream.of(PlatformUI.getWorkbench().getWorkbenchWindows()).forEach(window -> Stream.of(window.getPages()).forEach(page -> Stream.of(page.getEditorReferences()).forEach(editorReference -> {
            try {
                CnATreeElement element;
                if (editorReference.getEditorInput() instanceof BSIElementEditorInput && uuid.equals((element = ((BSIElementEditorInput)editorReference.getEditorInput()).getCnAElement()).getUuid())) {
                    page.closeEditors(new IEditorReference[]{editorReference}, true);
                }
            }
            catch (PartInitException e) {
                logger.error((Object)"Error while closing element editor.", (Throwable)e);
            }
        })));
    }

    public static List<CnATreeElement> getRelatedObjects(CnATreeElement cnAElement) {
        if ("bp_safeguard".equals(cnAElement.getTypeId())) {
            return cnAElement.getLinksUp().stream().filter(DeductionImplementationUtil::isRelevantLinkForImplementationStateDeduction).map(CnALink::getDependant).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static void updateDependentObjects(CnATreeElement cnAElement) {
        if (cnAElement == null) {
            return;
        }
        if ("bp_requirement".equals(cnAElement.getTypeId()) && DeductionImplementationUtil.isDeductiveImplementationEnabled((CnATreeElement)cnAElement)) {
            EditorUtil.updateRequirementImplementationStatus(cnAElement);
        }
    }

    private static void updateRequirementImplementationStatus(CnATreeElement cnAElement) {
        DeductionImplementationUtil.setImplementationStatusToRequirement((CnATreeElement)cnAElement);
    }

    public static String getEditorName(CnATreeElement cnATreeElement) {
        String elementTitle = EditorUtil.getElementTitle(cnATreeElement);
        return StringUtil.truncate((String)elementTitle, (int)20);
    }

    public static String getEditorToolTipText(CnATreeElement cnATreeElement) {
        return EditorUtil.getElementTitle(cnATreeElement);
    }

    private static String getElementTitle(CnATreeElement cnATreeElement) {
        return CnATreeElementLabelGenerator.getElementTitle((CnATreeElement)cnATreeElement);
    }

    public static void cleanOldEditors() {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            if (win == null) {
                return;
            }
            IWorkbenchWindow[] workbenchWindows = wb.getWorkbenchWindows();
            Arrays.stream(workbenchWindows).forEach(ww -> {
                IWorkbenchPage page = ww.getActivePage();
                Arrays.stream(page.getEditorReferences()).forEach(ref -> {
                    String editorId = ref.getId();
                    if (EMPTY_EDITOR_ID.equals(editorId)) {
                        page.closeEditors(new IEditorReference[]{ref}, false);
                    }
                });
            });
        }
        catch (Exception e) {
            logger.error((Object)"Error closing editors", (Throwable)e);
        }
    }
}

