/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.editors.AttachmentEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorRegistry;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.NoteEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.TaskEditorContext;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.model.bp.elements.Application;
import sernet.verinice.model.bp.elements.BpDocument;
import sernet.verinice.model.bp.elements.BpIncident;
import sernet.verinice.model.bp.elements.BpPerson;
import sernet.verinice.model.bp.elements.BpRecord;
import sernet.verinice.model.bp.elements.BpRequirement;
import sernet.verinice.model.bp.elements.BpThreat;
import sernet.verinice.model.bp.elements.BusinessProcess;
import sernet.verinice.model.bp.elements.Device;
import sernet.verinice.model.bp.elements.IcsSystem;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bp.elements.ItSystem;
import sernet.verinice.model.bp.elements.Network;
import sernet.verinice.model.bp.elements.Room;
import sernet.verinice.model.bp.elements.Safeguard;
import sernet.verinice.model.bp.groups.ApplicationGroup;
import sernet.verinice.model.bp.groups.BpDocumentGroup;
import sernet.verinice.model.bp.groups.BpIncidentGroup;
import sernet.verinice.model.bp.groups.BpPersonGroup;
import sernet.verinice.model.bp.groups.BpRecordGroup;
import sernet.verinice.model.bp.groups.BpRequirementGroup;
import sernet.verinice.model.bp.groups.BpThreatGroup;
import sernet.verinice.model.bp.groups.BusinessProcessGroup;
import sernet.verinice.model.bp.groups.DeviceGroup;
import sernet.verinice.model.bp.groups.IcsSystemGroup;
import sernet.verinice.model.bp.groups.ItSystemGroup;
import sernet.verinice.model.bp.groups.NetworkGroup;
import sernet.verinice.model.bp.groups.RoomGroup;
import sernet.verinice.model.bp.groups.SafeguardGroup;
import sernet.verinice.model.bpm.TodoViewItem;
import sernet.verinice.model.bsi.Anwendung;
import sernet.verinice.model.bsi.Attachment;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.Client;
import sernet.verinice.model.bsi.Gebaeude;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.NetzKomponente;
import sernet.verinice.model.bsi.Note;
import sernet.verinice.model.bsi.Person;
import sernet.verinice.model.bsi.Raum;
import sernet.verinice.model.bsi.Server;
import sernet.verinice.model.bsi.SonstIT;
import sernet.verinice.model.bsi.TelefonKomponente;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.RisikoMassnahmenUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.ds.Datenverarbeitung;
import sernet.verinice.model.ds.Personengruppen;
import sernet.verinice.model.ds.StellungnahmeDSB;
import sernet.verinice.model.ds.VerantwortlicheStelle;
import sernet.verinice.model.ds.Verarbeitungsangaben;
import sernet.verinice.model.iso27k.Asset;
import sernet.verinice.model.iso27k.AssetGroup;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.AuditGroup;
import sernet.verinice.model.iso27k.Control;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.iso27k.Document;
import sernet.verinice.model.iso27k.DocumentGroup;
import sernet.verinice.model.iso27k.Evidence;
import sernet.verinice.model.iso27k.EvidenceGroup;
import sernet.verinice.model.iso27k.Exception;
import sernet.verinice.model.iso27k.ExceptionGroup;
import sernet.verinice.model.iso27k.Finding;
import sernet.verinice.model.iso27k.FindingGroup;
import sernet.verinice.model.iso27k.Incident;
import sernet.verinice.model.iso27k.IncidentGroup;
import sernet.verinice.model.iso27k.IncidentScenario;
import sernet.verinice.model.iso27k.IncidentScenarioGroup;
import sernet.verinice.model.iso27k.Interview;
import sernet.verinice.model.iso27k.InterviewGroup;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.model.iso27k.PersonGroup;
import sernet.verinice.model.iso27k.PersonIso;
import sernet.verinice.model.iso27k.Process;
import sernet.verinice.model.iso27k.ProcessGroup;
import sernet.verinice.model.iso27k.Record;
import sernet.verinice.model.iso27k.RecordGroup;
import sernet.verinice.model.iso27k.Requirement;
import sernet.verinice.model.iso27k.RequirementGroup;
import sernet.verinice.model.iso27k.Response;
import sernet.verinice.model.iso27k.ResponseGroup;
import sernet.verinice.model.iso27k.Threat;
import sernet.verinice.model.iso27k.ThreatGroup;
import sernet.verinice.model.iso27k.Vulnerability;
import sernet.verinice.model.iso27k.VulnerabilityGroup;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.rcp.linktable.LinkTableEditor;
import sernet.verinice.rcp.linktable.LinkTableEditorInput;

public final class EditorFactory {
    private final Logger log = Logger.getLogger(EditorFactory.class);
    private static EditorFactory instance;
    private static Map<Class<?>, IEditorTypeFactory> typedFactories;
    private IEditorTypeFactory linkTableEditorFactory = new LinkTableEditorFactory();

    static {
        typedFactories = new HashMap();
    }

    private EditorFactory() {
        this.registerCnaTreeElements();
        this.registerGefaehrdung();
        this.registerTodoViewItem();
        this.registerAttachment();
        this.registerNote();
        typedFactories.put(LinkTableEditorInput.class, this.linkTableEditorFactory);
    }

    public static EditorFactory getInstance() {
        if (instance == null) {
            instance = new EditorFactory();
        }
        return instance;
    }

    public void openEditor(Object o) {
        IEditorTypeFactory factory = typedFactories.get(o.getClass());
        if (factory != null) {
            try {
                factory.openEditorFor(o);
            }
            catch (java.lang.Exception e) {
                this.log.error((Object)"Error while opening editor.", (Throwable)e);
                ExceptionUtil.log(e, Messages.EditorFactory_2);
            }
        }
    }

    public void updateAndOpenObject(Object o) {
        EditorFactory.getInstance().openEditor(o);
    }

    public void updateAndOpenObject(CnATreeElement element, boolean readOnly) {
        BSIElementEditorInput input = new BSIElementEditorInput(element, readOnly);
        try {
            EditorFactory.openEditor(input.getId(), input, "sernet.gs.ui.rcp.main.bsi.editors.bsielementeditor");
        }
        catch (java.lang.Exception e) {
            this.log.error((Object)"Error while opening editor.", (Throwable)e);
            ExceptionUtil.log(e, Messages.EditorFactory_2);
        }
    }

    private void registerNote() {
        IEditorTypeFactory noteEditorFactory = new IEditorTypeFactory(){

            @Override
            public void openEditorFor(Object o) throws PartInitException {
                Note selection = (Note)o;
                NoteEditorInput input = new NoteEditorInput(selection);
                EditorFactory.openEditor(String.valueOf(input.getId()), input, "sernet.gs.ui.rcp.main.bsi.editors.noteeditor");
            }
        };
        typedFactories.put(Note.class, noteEditorFactory);
    }

    private void registerAttachment() {
        IEditorTypeFactory attachmentEditorFactory = new IEditorTypeFactory(){

            @Override
            public void openEditorFor(Object o) throws PartInitException {
                Attachment attachment = (Attachment)o;
                AttachmentEditorInput input = new AttachmentEditorInput(attachment);
                EditorFactory.openEditor(String.valueOf(input.getId()), input, "sernet.gs.ui.rcp.main.bsi.editors.attachmenteditor");
            }
        };
        typedFactories.put(Attachment.class, attachmentEditorFactory);
    }

    private void registerTodoViewItem() {
        IEditorTypeFactory todoItemEditorFactory = new IEditorTypeFactory(){

            @Override
            public void openEditorFor(Object o) throws PartInitException {
                TodoViewItem selection = (TodoViewItem)o;
                try {
                    CnATreeElement element = CnAElementHome.getInstance().loadById("mnums", selection.getDbId());
                    EditorFactory.openEditor(element.getId(), new BSIElementEditorInput(element), "sernet.gs.ui.rcp.main.bsi.editors.bsielementeditor");
                }
                catch (CommandException e) {
                    EditorFactory.this.log.error((Object)"Error while opening editor.", (Throwable)e);
                    ExceptionUtil.log(e, Messages.EditorFactory_2);
                }
            }
        };
        typedFactories.put(TodoViewItem.class, todoItemEditorFactory);
    }

    private void registerGefaehrdung() {
        IEditorTypeFactory gefaehrdungsUmsetzungFactory = new IEditorTypeFactory(){

            @Override
            public void openEditorFor(Object o) throws PartInitException {
                GefaehrdungsUmsetzung gefaehrdung = (GefaehrdungsUmsetzung)o;
                String id = gefaehrdung.getEntity() == null ? "ENTITY_" + gefaehrdung.getUuid() : gefaehrdung.getEntity().getId();
                EditorFactory.openEditor(id, new BSIElementEditorInput((CnATreeElement)gefaehrdung), "sernet.gs.ui.rcp.main.bsi.editors.bsielementeditor");
            }
        };
        typedFactories.put(GefaehrdungsUmsetzung.class, gefaehrdungsUmsetzungFactory);
    }

    private void registerCnaTreeElements() {
        IEditorTypeFactory bsiEditorFactory = new IEditorTypeFactory(){

            @Override
            public void openEditorFor(Object o) throws PartInitException {
                BSIElementEditorInput input;
                if (o instanceof CnATreeElement) {
                    input = new BSIElementEditorInput((CnATreeElement)o);
                } else {
                    TaskEditorContext context = (TaskEditorContext)o;
                    input = new BSIElementEditorInput(context.getElement(), context.getTask());
                }
                EditorFactory.openEditor(input.getId(), input, "sernet.gs.ui.rcp.main.bsi.editors.bsielementeditor");
            }
        };
        typedFactories.put(ITVerbund.class, bsiEditorFactory);
        typedFactories.put(Client.class, bsiEditorFactory);
        typedFactories.put(SonstIT.class, bsiEditorFactory);
        typedFactories.put(NetzKomponente.class, bsiEditorFactory);
        typedFactories.put(TelefonKomponente.class, bsiEditorFactory);
        typedFactories.put(Raum.class, bsiEditorFactory);
        typedFactories.put(Server.class, bsiEditorFactory);
        typedFactories.put(Person.class, bsiEditorFactory);
        typedFactories.put(Gebaeude.class, bsiEditorFactory);
        typedFactories.put(Anwendung.class, bsiEditorFactory);
        typedFactories.put(BausteinUmsetzung.class, bsiEditorFactory);
        typedFactories.put(MassnahmenUmsetzung.class, bsiEditorFactory);
        typedFactories.put(RisikoMassnahmenUmsetzung.class, bsiEditorFactory);
        typedFactories.put(Verarbeitungsangaben.class, bsiEditorFactory);
        typedFactories.put(VerantwortlicheStelle.class, bsiEditorFactory);
        typedFactories.put(Personengruppen.class, bsiEditorFactory);
        typedFactories.put(Datenverarbeitung.class, bsiEditorFactory);
        typedFactories.put(StellungnahmeDSB.class, bsiEditorFactory);
        typedFactories.put(Organization.class, bsiEditorFactory);
        typedFactories.put(AssetGroup.class, bsiEditorFactory);
        typedFactories.put(Asset.class, bsiEditorFactory);
        typedFactories.put(PersonGroup.class, bsiEditorFactory);
        typedFactories.put(PersonIso.class, bsiEditorFactory);
        typedFactories.put(AuditGroup.class, bsiEditorFactory);
        typedFactories.put(Audit.class, bsiEditorFactory);
        typedFactories.put(ControlGroup.class, bsiEditorFactory);
        typedFactories.put(Control.class, bsiEditorFactory);
        typedFactories.put(ExceptionGroup.class, bsiEditorFactory);
        typedFactories.put(Exception.class, bsiEditorFactory);
        typedFactories.put(RequirementGroup.class, bsiEditorFactory);
        typedFactories.put(Requirement.class, bsiEditorFactory);
        typedFactories.put(IncidentGroup.class, bsiEditorFactory);
        typedFactories.put(Incident.class, bsiEditorFactory);
        typedFactories.put(IncidentScenarioGroup.class, bsiEditorFactory);
        typedFactories.put(IncidentScenario.class, bsiEditorFactory);
        typedFactories.put(ResponseGroup.class, bsiEditorFactory);
        typedFactories.put(Response.class, bsiEditorFactory);
        typedFactories.put(ThreatGroup.class, bsiEditorFactory);
        typedFactories.put(Threat.class, bsiEditorFactory);
        typedFactories.put(VulnerabilityGroup.class, bsiEditorFactory);
        typedFactories.put(Vulnerability.class, bsiEditorFactory);
        typedFactories.put(DocumentGroup.class, bsiEditorFactory);
        typedFactories.put(Document.class, bsiEditorFactory);
        typedFactories.put(InterviewGroup.class, bsiEditorFactory);
        typedFactories.put(Interview.class, bsiEditorFactory);
        typedFactories.put(EvidenceGroup.class, bsiEditorFactory);
        typedFactories.put(Evidence.class, bsiEditorFactory);
        typedFactories.put(FindingGroup.class, bsiEditorFactory);
        typedFactories.put(Finding.class, bsiEditorFactory);
        typedFactories.put(Process.class, bsiEditorFactory);
        typedFactories.put(ProcessGroup.class, bsiEditorFactory);
        typedFactories.put(Record.class, bsiEditorFactory);
        typedFactories.put(RecordGroup.class, bsiEditorFactory);
        typedFactories.put(ItNetwork.class, bsiEditorFactory);
        typedFactories.put(Application.class, bsiEditorFactory);
        typedFactories.put(ApplicationGroup.class, bsiEditorFactory);
        typedFactories.put(BpPerson.class, bsiEditorFactory);
        typedFactories.put(BpPersonGroup.class, bsiEditorFactory);
        typedFactories.put(BpRequirement.class, bsiEditorFactory);
        typedFactories.put(BpRequirementGroup.class, bsiEditorFactory);
        typedFactories.put(BpThreat.class, bsiEditorFactory);
        typedFactories.put(BpThreatGroup.class, bsiEditorFactory);
        typedFactories.put(BusinessProcess.class, bsiEditorFactory);
        typedFactories.put(BusinessProcessGroup.class, bsiEditorFactory);
        typedFactories.put(Device.class, bsiEditorFactory);
        typedFactories.put(DeviceGroup.class, bsiEditorFactory);
        typedFactories.put(IcsSystem.class, bsiEditorFactory);
        typedFactories.put(IcsSystemGroup.class, bsiEditorFactory);
        typedFactories.put(ItSystem.class, bsiEditorFactory);
        typedFactories.put(ItSystemGroup.class, bsiEditorFactory);
        typedFactories.put(Network.class, bsiEditorFactory);
        typedFactories.put(NetworkGroup.class, bsiEditorFactory);
        typedFactories.put(Room.class, bsiEditorFactory);
        typedFactories.put(RoomGroup.class, bsiEditorFactory);
        typedFactories.put(Safeguard.class, bsiEditorFactory);
        typedFactories.put(SafeguardGroup.class, bsiEditorFactory);
        typedFactories.put(BpDocument.class, bsiEditorFactory);
        typedFactories.put(BpDocumentGroup.class, bsiEditorFactory);
        typedFactories.put(BpIncident.class, bsiEditorFactory);
        typedFactories.put(BpIncidentGroup.class, bsiEditorFactory);
        typedFactories.put(BpRecord.class, bsiEditorFactory);
        typedFactories.put(BpRecordGroup.class, bsiEditorFactory);
        typedFactories.put(SamtTopic.class, bsiEditorFactory);
        typedFactories.put(TaskEditorContext.class, bsiEditorFactory);
    }

    private static IEditorPart openEditor(String id, IEditorInput input, String editorId) throws PartInitException {
        IEditorPart editor = EditorRegistry.getInstance().getOpenEditor(id);
        if (editor == null) {
            editor = EditorFactory.getPage().openEditor(input, editorId);
            EditorRegistry.getInstance().registerOpenEditor(id, editor);
        } else {
            editor = EditorFactory.getPage().openEditor(editor.getEditorInput(), editorId);
        }
        return editor;
    }

    private static IWorkbenchPage getPage() {
        IWorkbenchPage page = Activator.getActivePage();
        if (page == null) {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return page;
    }

    private static interface IEditorTypeFactory {
        public void openEditorFor(Object var1) throws PartInitException;
    }

    private static class LinkTableEditorFactory
    implements IEditorTypeFactory {
        private LinkTableEditorFactory() {
        }

        @Override
        public void openEditorFor(Object o) throws PartInitException {
            LinkTableEditorInput input = (LinkTableEditorInput)o;
            EditorFactory.openEditor(input.getId(), input, LinkTableEditor.EDITOR_ID);
        }
    }
}

