/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Optional;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.hui.common.connect.Entity;
import sernet.hui.swt.widgets.Colors;
import sernet.verinice.model.common.CnATreeElement;

public class ChangeMetadata
extends Composite {
    private Text createdBy;
    private Text createdAt;
    private Text changedBy;
    private Text changedAt;

    public ChangeMetadata(Composite parent) {
        super(parent, 2048);
        GridLayout gridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        this.createLabel(Messages.CreatedBy);
        this.createdBy = this.createText();
        this.createLabel(Messages.CreatedAt);
        this.createdAt = this.createText();
        this.createLabel(Messages.ChangedBy);
        this.changedBy = this.createText();
        this.createLabel(Messages.ChangedAt);
        this.changedAt = this.createText();
    }

    private Label createLabel(String text) {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText(text);
        return label;
    }

    private Text createText() {
        Text text = new Text((Composite)this, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ChangeMetadata.makeReadOnly(text);
        return text;
    }

    protected static void makeReadOnly(Text field) {
        field.setEditable(false);
        field.setBackground(Colors.GREY);
    }

    public void setElement(CnATreeElement cnAElement) {
        Entity entity = cnAElement.getEntity();
        this.createdBy.setText(Optional.ofNullable(entity.getCreatedBy()).orElse(""));
        this.updateField(this.createdAt, entity.getCreatedAt());
        this.changedBy.setText(Optional.ofNullable(entity.getChangedBy()).orElse(""));
        this.updateField(this.changedAt, entity.getChangedAt());
    }

    private void updateField(Text field, Date date) {
        if (date != null) {
            ZonedDateTime dt = date.toInstant().atZone(ZoneId.systemDefault());
            String formattedDate = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.MEDIUM).format(dt);
            field.setText(formattedDate);
        } else {
            field.setText("");
        }
    }
}

