/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.WorkbenchPart;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.ChangeMetadata;
import sernet.gs.ui.rcp.main.bsi.editors.EditorRegistry;
import sernet.gs.ui.rcp.main.bsi.editors.EditorUtil;
import sernet.gs.ui.rcp.main.bsi.editors.InputHelperFactory;
import sernet.gs.ui.rcp.main.bsi.editors.LinkMaker;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.gs.ui.rcp.main.bsi.views.CnAImageProvider;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.Entity;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.IEntityChangedListener;
import sernet.hui.common.connect.Property;
import sernet.hui.common.connect.PropertyChangedEvent;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.common.multiselectionlist.IMLPropertyOption;
import sernet.hui.common.multiselectionlist.IMLPropertyType;
import sernet.hui.swt.widgets.HitroUIComposite;
import sernet.hui.swt.widgets.IHuiControlFactory;
import sernet.snutils.AssertException;
import sernet.snutils.FormInputParser;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bp.rcp.bcm.BCMUiUtils;
import sernet.verinice.bp.rcp.risk.ui.FrequencyConfigurator;
import sernet.verinice.bp.rcp.risk.ui.ImpactConfigurator;
import sernet.verinice.bp.rcp.risk.ui.RiskConfigurationUpdateResultDialog;
import sernet.verinice.bp.rcp.risk.ui.RiskMatrixConfigurator;
import sernet.verinice.bp.rcp.risk.ui.RiskUiUtils;
import sernet.verinice.bp.rcp.risk.ui.RiskValuesConfigurator;
import sernet.verinice.bp.rcp.risk.ui.StackConfigurator;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskService;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bp.risk.RiskPropertyValue;
import sernet.verinice.model.bp.risk.configuration.DefaultRiskConfiguration;
import sernet.verinice.model.bp.risk.configuration.RiskConfiguration;
import sernet.verinice.model.bp.risk.configuration.RiskConfigurationUpdateContext;
import sernet.verinice.model.bp.risk.configuration.RiskConfigurationUpdateResult;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.Preferences;
import sernet.verinice.service.bp.risk.RiskService;
import sernet.verinice.service.commands.crud.LoadElementForEditor;

public class BSIElementEditorMultiPage
extends MultiPageEditorPart {
    private static final Logger LOG = Logger.getLogger(BSIElementEditorMultiPage.class);
    public static final String EDITOR_ID = "sernet.gs.ui.rcp.main.bsi.editors.bsielementeditor";
    private HitroUIComposite huiComposite;
    private boolean isModelModified = false;
    private ITask task;
    private Map<String, String> changedElementProperties = new HashMap<String, String>();
    private @NonNull RiskConfiguration riskConfigurationState = DefaultRiskConfiguration.getInstance();
    private RiskService riskService;
    private RightsServiceClient rightsService;
    private Boolean isWriteAllowed = null;
    public static final String SAMT_PERSPECTIVE_ID = "sernet.verinice.samt.rcp.SamtPerspective";
    private static final String SAMT_PERSPECTIVE_DEFAULT_TAGS = "VDA-ISA";
    private ImpactConfigurator impactsConfigurator;
    private FrequencyConfigurator frequenciesConfigurator;
    private RiskValuesConfigurator riskValuesConfigurator;
    private RiskMatrixConfigurator riskMatrixConfigurator;
    private int matrixPageIndex = -1;
    private int riskCategoriesPageIndex = -1;
    private int impactsPageIndex = -1;
    private int frequenciesPageIndex = -1;
    private IEntityChangedListener modelListener = new IEntityChangedListener(){

        public void selectionChanged(IMLPropertyType arg0, IMLPropertyOption arg1) {
            this.saveMultiselectElementProperties(arg0);
            this.modelChanged();
        }

        public void propertyChanged(PropertyChangedEvent evt) {
            this.saveChangedElementProperties(evt);
            this.modelChanged();
        }

        private void saveChangedElementProperties(PropertyChangedEvent event) {
            if (BSIElementEditorMultiPage.this.isTaskEditorContext() && StringUtils.isNotEmpty((String)event.getProperty().getPropertyType())) {
                PropertyType propertyType = HUITypeFactory.getInstance().getPropertyType(BSIElementEditorMultiPage.this.cnAElement.getEntityType().getId(), event.getProperty().getPropertyType());
                if (propertyType.isSingleSelect()) {
                    BSIElementEditorMultiPage.this.changedElementProperties.put(event.getProperty().getPropertyType(), event.getProperty().getPropertyValue());
                } else if (propertyType.isDate()) {
                    this.saveChangedDateElementProperties(event);
                } else if (!propertyType.isMultiselect() && !propertyType.isReference()) {
                    BSIElementEditorMultiPage.this.changedElementProperties.put(event.getProperty().getPropertyType(), event.getProperty().getPropertyValue());
                }
            }
        }

        private void saveChangedDateElementProperties(PropertyChangedEvent event) {
            try {
                String date = FormInputParser.dateToString((Date)new Date(Long.parseLong(event.getProperty().getPropertyValue())));
                BSIElementEditorMultiPage.this.changedElementProperties.put(event.getProperty().getPropertyType(), date);
            }
            catch (NumberFormatException | AssertException e) {
                LOG.error((Object)"Exception while getting the value of a date property", e);
            }
        }

        private void saveMultiselectElementProperties(IMLPropertyType arg0) {
            if (BSIElementEditorMultiPage.this.isTaskEditorContext() && StringUtils.isNotEmpty((String)arg0.getId())) {
                PropertyType propertyType = HUITypeFactory.getInstance().getPropertyType(BSIElementEditorMultiPage.this.cnAElement.getEntityType().getId(), arg0.getId());
                List properties = BSIElementEditorMultiPage.this.cnAElement.getEntity().getProperties(propertyType.getId()).getProperties();
                StringBuilder sb = new StringBuilder();
                for (Property property : properties) {
                    sb.append(property.getPropertyValue()).append(",");
                }
                BSIElementEditorMultiPage.this.changedElementProperties.put(propertyType.getId(), sb.toString());
            }
        }

        private void modelChanged() {
            boolean wasDirty = BSIElementEditorMultiPage.this.isDirty();
            BSIElementEditorMultiPage.this.isModelModified = true;
            if (!wasDirty) {
                BSIElementEditorMultiPage.this.firePropertyChange(257);
            }
        }
    };
    private CnATreeElement cnAElement;
    private LinkMaker linkMaker;
    private ChangeMetadata changeMetadata;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof BSIElementEditorInput)) {
            throw new PartInitException("invalid input");
        }
        Activator.inheritVeriniceContextState();
        this.rightsService = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        if (((BSIElementEditorInput)input).isReadOnly()) {
            this.isWriteAllowed = false;
        }
    }

    private void initContent() {
        try {
            BSIElementEditorInput editorInput = (BSIElementEditorInput)this.getEditorInput();
            CnATreeElement element = editorInput.getCnAElement();
            this.task = editorInput.getTask();
            CnATreeElement elementWithChildren = Retriever.checkRetrieveChildren((CnATreeElement)element);
            LoadElementForEditor command = new LoadElementForEditor(element);
            command = (LoadElementForEditor)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            this.cnAElement = command.getElement();
            this.cnAElement.setChildren(elementWithChildren.getChildren());
            Entity entity = this.cnAElement.getEntity();
            EntityType entityType = HitroUtil.getInstance().getTypeFactory().getEntityType(entity.getEntityType());
            if (this.isTaskEditorContext()) {
                this.loadChangedElementPropertiesFromTask();
                this.setPartName(String.valueOf(this.getPartName()) + Messages.BSIElementEditor_9);
            }
            if (this.getIsWriteAllowed().booleanValue()) {
                entity.addChangeListener(this.modelListener);
            } else {
                this.setPartName(String.valueOf(this.getPartName()) + Messages.BSIElementEditor_7);
            }
            String[] tags = Preferences.getEditorTags();
            boolean strict = Activator.getDefault().getPluginPreferences().getBoolean("hui_tags_strict");
            if (this.isSamtPerspective()) {
                tags = new String[]{SAMT_PERSPECTIVE_DEFAULT_TAGS};
                strict = true;
            }
            Map<String, IHuiControlFactory> overrides = RiskUiUtils.createHuiControlFactories(element);
            this.huiComposite.createView(entity, this.getIsWriteAllowed().booleanValue(), true, tags, strict, ServiceFactory.lookupValidationService().getPropertyTypesToValidate(entity, this.cnAElement.getDbId()), Activator.getDefault().getPreferenceStore().getBoolean("use_validation_gui_hints"), overrides);
            InputHelperFactory.setInputHelpers(entityType, this.huiComposite);
            if (Arrays.stream(tags).anyMatch("BSI-200-3"::equals)) {
                RiskUiUtils.addSelectionListener(this.huiComposite, this.cnAElement);
            }
            if (Arrays.stream(tags).anyMatch("BCM"::equals)) {
                BCMUiUtils.addSelectionListener(this.huiComposite, this.cnAElement);
                BCMUiUtils.addControlHints(this.huiComposite, this.cnAElement);
                BCMUiUtils.addInputHelper(this.huiComposite, this.cnAElement);
            }
            this.huiComposite.resetInitialFocus();
            if (this.linkMaker != null) {
                this.linkMaker.createPartControl(this.getIsWriteAllowed());
                this.linkMaker.setInputElmt(this.cnAElement);
            }
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.BSIElementEditor_8);
        }
    }

    protected void pageChange(int newPageIndex) {
        if (this.matrixPageIndex == newPageIndex) {
            this.riskMatrixConfigurator.setEditorState(this.riskConfigurationState);
            this.riskMatrixConfigurator.refresh();
        }
        if (this.riskCategoriesPageIndex == newPageIndex) {
            this.riskValuesConfigurator.setEditorState(this.riskConfigurationState.getRisks());
            this.riskValuesConfigurator.refresh();
        }
        if (this.frequenciesPageIndex == newPageIndex) {
            this.frequenciesConfigurator.setEditorState(this.riskConfigurationState.getFrequencies());
            this.frequenciesConfigurator.refresh();
        }
        if (this.impactsPageIndex == newPageIndex) {
            this.impactsConfigurator.setEditorState(this.riskConfigurationState.getImpacts());
            this.impactsConfigurator.refresh();
        }
        super.pageChange(newPageIndex);
    }

    private boolean isTaskEditorContext() {
        return this.task != null && this.task.isWithAReleaseProcess();
    }

    private void loadChangedElementPropertiesFromTask() {
        Map changedElementPropertiesForTask = this.getTaskService().loadChangedElementProperties(this.task.getId());
        for (Map.Entry entry : changedElementPropertiesForTask.entrySet()) {
            this.cnAElement.setPropertyValue((String)entry.getKey(), (String)entry.getValue());
        }
        this.setPartName(EditorUtil.getEditorName(this.cnAElement));
        this.setTitleToolTip(EditorUtil.getEditorToolTipText(this.cnAElement));
        LOG.info((Object)"Loaded changes for element properties from task.");
    }

    public void doSave(IProgressMonitor monitor) {
        Activator.inheritVeriniceContextState();
        if (this.isTaskEditorContext()) {
            this.updateTaskWithChangedElementProperties();
            LOG.info((Object)"Sciped save cnAElement.");
        } else {
            monitor.beginTask(Messages.BSIElementEditor_1, -1);
            this.save(true);
            Optional.ofNullable(this.changeMetadata).ifPresent(value -> value.setElement(this.cnAElement));
            RefreshJob job = new RefreshJob("Refresh application...", EditorUtil.getRelatedObjects(this.cnAElement));
            job.setRule(new RefreshJobRule());
            job.schedule();
            IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            ArrayList<IEditorReference> closeOthers = new ArrayList<IEditorReference>();
            BSIElementEditorInput myInput = (BSIElementEditorInput)this.getEditorInput();
            IEditorReference[] iEditorReferenceArray = editorReferences;
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                try {
                    BSIElementEditorInput bsiInput;
                    IEditorInput input;
                    if (!editorReference.isPinned() && !editorReference.isDirty() && (input = editorReference.getEditorInput()) instanceof BSIElementEditorInput && !(bsiInput = (BSIElementEditorInput)input).getId().equals(myInput.getId())) {
                        closeOthers.add(editorReference);
                    }
                }
                catch (PartInitException e) {
                    ExceptionUtil.log(e, Messages.BSIElementEditor_2);
                }
                ++n2;
            }
            IEditorReference[] closeArray = closeOthers.toArray(new IEditorReference[closeOthers.size()]);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(closeArray, true);
            monitor.done();
        }
    }

    private void save(boolean trackChange) {
        if (!this.getIsWriteAllowed().booleanValue()) {
            ExceptionUtil.log(new IllegalStateException(), Messages.BSIElementEditor_3);
            return;
        }
        try {
            if (this.cnAElement.isItNetwork() && this.riskConfiguationIsDirty()) {
                ItNetwork itNetwork = (ItNetwork)this.cnAElement;
                if (this.riskConfiguationWasReset()) {
                    itNetwork.setRiskConfiguration(null);
                } else {
                    this.validateAllLabelsUniqueAndNonEmpty(this.riskConfigurationState);
                    itNetwork.setRiskConfiguration(this.riskConfigurationState);
                }
                RiskConfigurationUpdateContext updateContext = new RiskConfigurationUpdateContext(this.cnAElement.getUuid(), this.riskConfigurationState, this.frequenciesConfigurator.getDeleted(), this.impactsConfigurator.getDeleted(), this.riskValuesConfigurator.getDeleted());
                RiskConfigurationUpdateResult updateResult = this.getRiskService().updateRiskConfiguration(updateContext);
                RiskConfigurationUpdateResultDialog.openUpdateResultDialog(updateResult);
                Stream.of(new StackConfigurator[]{this.frequenciesConfigurator, this.impactsConfigurator, this.riskValuesConfigurator}).forEach(StackConfigurator::reset);
            }
            if (trackChange) {
                this.cnAElement.getEntity().trackChange(ServiceFactory.lookupAuthService().getUsername());
            }
            CnAElementHome.getInstance().updateEntity(this.cnAElement);
            EditorUtil.updateDependentObjects(this.cnAElement);
            this.isModelModified = false;
            this.setPartName(EditorUtil.getEditorName(this.cnAElement));
            this.setTitleToolTip(EditorUtil.getEditorToolTipText(this.cnAElement));
            this.setIcon();
            this.firePropertyChange(257);
        }
        catch (RiskPropertyValueLabelNotUniqueException e) {
            this.setActivePage(e.indexOfFirstErrorPage);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BSIElementEditorMultiPage_risk_configuration_invalid, (String)Messages.BSIElementEditorMultiPage_risk_property_value_labels_not_unique);
        }
        catch (Exception se) {
            ExceptionUtil.log(se, Messages.BSIElementEditor_5);
        }
    }

    private void validateAllLabelsUniqueAndNonEmpty(@NonNull RiskConfiguration riskConfiguration) throws RiskPropertyValueLabelNotUniqueException {
        if (!BSIElementEditorMultiPage.allLabelsUniqueAndNonEmpty(riskConfiguration.getFrequencies())) {
            throw new RiskPropertyValueLabelNotUniqueException(this.frequenciesPageIndex);
        }
        if (!BSIElementEditorMultiPage.allLabelsUniqueAndNonEmpty(riskConfiguration.getImpacts())) {
            throw new RiskPropertyValueLabelNotUniqueException(this.impactsPageIndex);
        }
        if (!BSIElementEditorMultiPage.allLabelsUniqueAndNonEmpty(riskConfiguration.getRisks())) {
            throw new RiskPropertyValueLabelNotUniqueException(this.riskCategoriesPageIndex);
        }
    }

    private static boolean allLabelsUniqueAndNonEmpty(List<? extends RiskPropertyValue> riskPropertyValues) {
        int numberOfUniqueNonEmptyLabels = (int)riskPropertyValues.stream().map(RiskPropertyValue::getLabel).filter(s -> !s.isEmpty()).distinct().count();
        return numberOfUniqueNonEmptyLabels == riskPropertyValues.size();
    }

    private RiskService getRiskService() {
        if (this.riskService == null) {
            this.riskService = (RiskService)VeriniceContext.get((String)"itbpRiskService");
        }
        return this.riskService;
    }

    private void updateTaskWithChangedElementProperties() {
        if (!this.changedElementProperties.isEmpty()) {
            this.getTaskService().updateChangedElementProperties(this.task.getId(), this.changedElementProperties);
            this.changedElementProperties.clear();
            LOG.info((Object)"Updated task: saved changes in element properties.");
        }
        this.isModelModified = false;
        this.setPartName(String.valueOf(EditorUtil.getEditorName(this.cnAElement)) + Messages.BSIElementEditor_9);
        this.setTitleToolTip(EditorUtil.getEditorToolTipText(this.cnAElement));
        this.firePropertyChange(257);
    }

    protected ITaskService getTaskService() {
        return (ITaskService)VeriniceContext.get((String)"taskService");
    }

    public void doSaveAs() {
    }

    private void setIcon() {
        Image icon = ImageCache.getInstance().getImage("generic_element.gif");
        if (this.cnAElement != null) {
            icon = CnAImageProvider.getImage(this.cnAElement, true);
        }
        this.setTitleImage(icon);
    }

    public boolean isDirty() {
        if (this.isModelModified) {
            return true;
        }
        if (!this.cnAElement.isItNetwork()) {
            return false;
        }
        return this.riskConfiguationIsDirty();
    }

    private boolean riskConfiguationIsDirty() {
        if (!this.rightsService.isEnabled("editriskconfiguration")) {
            return false;
        }
        RiskConfiguration storedRiskConfiguration = ((ItNetwork)this.cnAElement).getRiskConfiguration();
        return !this.keptDefaultRiskConfiguation() && (this.riskConfiguationWasReset() || !this.riskConfigurationState.deepEquals((Object)storedRiskConfiguration));
    }

    private boolean keptDefaultRiskConfiguation() {
        RiskConfiguration storedRiskConfiguration = ((ItNetwork)this.cnAElement).getRiskConfiguration();
        return storedRiskConfiguration == null && this.riskConfigurationState == DefaultRiskConfiguration.getInstance();
    }

    private boolean riskConfiguationWasReset() {
        RiskConfiguration storedRiskConfiguration = ((ItNetwork)this.cnAElement).getRiskConfiguration();
        return storedRiskConfiguration != null && this.riskConfigurationState == DefaultRiskConfiguration.getInstance();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setIsWriteAllowed(Boolean isWriteAllowed) {
        this.isWriteAllowed = isWriteAllowed;
    }

    public Boolean getIsWriteAllowed() {
        if (this.isWriteAllowed == null) {
            this.isWriteAllowed = this.createIsWriteAllowed();
        }
        return this.isWriteAllowed;
    }

    public Boolean createIsWriteAllowed() {
        this.isWriteAllowed = CnAElementHome.getInstance().isWriteAllowed(this.cnAElement);
        return this.isWriteAllowed;
    }

    private boolean isSamtPerspective() {
        IPerspectiveDescriptor perspective = this.getSite().getWorkbenchWindow().getActivePage().getPerspective();
        return perspective.getId().equals(SAMT_PERSPECTIVE_ID);
    }

    public boolean isNotAskAndSave() {
        return true;
    }

    public void setFocus() {
        IWorkbenchPage page;
        IEditorPart active;
        if (this.getActivePage() == 0 && (active = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getActiveEditor()) == this) {
            this.huiComposite.resetInitialFocus();
        }
    }

    public void dispose() {
        if (this.linkMaker != null) {
            this.linkMaker.dispose();
        }
        Optional.ofNullable(this.changeMetadata).ifPresent(Widget::dispose);
        this.huiComposite.closeView();
        this.cnAElement.getEntity().removeListener(this.modelListener);
        EditorRegistry.getInstance().closeEditor(((BSIElementEditorInput)this.getEditorInput()).getId());
        super.dispose();
    }

    protected void createPages() {
        this.createBsiPage();
        this.createLinkMakerPage();
        if (this.cnAElement.isItNetwork() && this.rightsService.isEnabled("editriskconfiguration")) {
            ItNetwork itn = (ItNetwork)this.cnAElement;
            this.riskConfigurationState = itn.getRiskConfigurationOrDefault();
            ScrolledComposite scrolledComposite = BSIElementEditorMultiPage.createScrollableComposite(this.getContainer());
            this.riskMatrixConfigurator = new RiskMatrixConfigurator((Composite)scrolledComposite, this.riskConfigurationState, this::riskConfigurationChanged, this::restoreRiskConfiguration);
            scrolledComposite.setContent((Control)this.riskMatrixConfigurator);
            this.matrixPageIndex = this.addNewPage((Composite)scrolledComposite, Messages.BSIElementEditorMultiPage_page_name_risk_matrix);
            scrolledComposite = BSIElementEditorMultiPage.createScrollableComposite(this.getContainer());
            this.riskValuesConfigurator = new RiskValuesConfigurator((Composite)scrolledComposite, this.riskConfigurationState.getRisks(), this::riskConfigurationChanged);
            scrolledComposite.setContent((Control)this.riskValuesConfigurator);
            this.riskCategoriesPageIndex = this.addNewPage((Composite)scrolledComposite, Messages.BSIElementEditorMultiPage_page_name_risk_values);
            scrolledComposite = BSIElementEditorMultiPage.createScrollableComposite(this.getContainer());
            this.impactsConfigurator = new ImpactConfigurator((Composite)scrolledComposite, this.riskConfigurationState.getImpacts(), this::riskConfigurationChanged);
            scrolledComposite.setContent((Control)this.impactsConfigurator);
            this.impactsPageIndex = this.addNewPage((Composite)scrolledComposite, Messages.BSIElementEditorMultiPage_page_name_risk_impact);
            scrolledComposite = BSIElementEditorMultiPage.createScrollableComposite(this.getContainer());
            this.frequenciesConfigurator = new FrequencyConfigurator((Composite)scrolledComposite, this.riskConfigurationState.getFrequencies(), this::riskConfigurationChanged);
            scrolledComposite.setContent((Control)this.frequenciesConfigurator);
            this.frequenciesPageIndex = this.addNewPage((Composite)scrolledComposite, Messages.BSIElementEditorMultiPage_page_name_risk_frequency);
        }
        if (!CnAElementHome.getInstance().isCatalogElement(this.cnAElement)) {
            this.createChangeMetadataPage();
        }
        if (this.isDirty()) {
            this.save(false);
        }
    }

    private void riskConfigurationChanged() {
        this.riskConfigurationState = this.riskMatrixConfigurator.getEditorState().withValues(this.frequenciesConfigurator.getEditorState(), this.impactsConfigurator.getEditorState(), this.riskValuesConfigurator.getEditorState());
        this.firePropertyChange(257);
    }

    private void restoreRiskConfiguration() {
        this.riskConfigurationState = DefaultRiskConfiguration.getInstance();
        this.riskMatrixConfigurator.setEditorState(this.riskConfigurationState);
        this.riskValuesConfigurator.setEditorState(this.riskConfigurationState.getRisks());
        this.frequenciesConfigurator.setEditorState(this.riskConfigurationState.getFrequencies());
        this.impactsConfigurator.setEditorState(this.riskConfigurationState.getImpacts());
        this.riskMatrixConfigurator.refresh();
        this.firePropertyChange(257);
    }

    private int addNewPage(Composite page, String title) {
        int index = this.addPage((Control)page);
        this.setPageText(index, title);
        return index;
    }

    private void createLinkMakerPage() {
        this.linkMaker = new LinkMaker(this.getContainer(), (WorkbenchPart)this);
        this.linkMaker.createPartControl(this.getIsWriteAllowed());
        this.linkMaker.setInputElmt(this.cnAElement);
        this.addNewPage(this.linkMaker, Messages.BSIElementEditorMultiPage_page_name_links);
    }

    private void createBsiPage() {
        this.huiComposite = new HitroUIComposite(this.getContainer(), false);
        this.initContent();
        this.setIcon();
        this.addNewPage((Composite)this.huiComposite, Messages.BSIElementEditorMultiPage_page_name_data);
    }

    private void createChangeMetadataPage() {
        this.changeMetadata = new ChangeMetadata(this.getContainer());
        this.changeMetadata.setElement(this.cnAElement);
        this.addNewPage(this.changeMetadata, Messages.BSIElementEditorMultiPage_page_name_change_metadata);
    }

    private static ScrolledComposite createScrollableComposite(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        return scrolledComposite;
    }

    private final class RefreshJob
    extends Job {
        private List<CnATreeElement> objects;

        private RefreshJob(String name) {
            super(name);
        }

        public RefreshJob(String name, List<CnATreeElement> dependentObjects) {
            super(name);
            this.objects = dependentObjects;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.setTaskName("Refresh application...");
            Activator.inheritVeriniceContextState();
            this.refresh();
            return Status.OK_STATUS;
        }

        private void refresh() {
            CnAElementFactory.getModel(BSIElementEditorMultiPage.this.cnAElement).childChanged(BSIElementEditorMultiPage.this.cnAElement);
            if (this.objects != null) {
                for (CnATreeElement cnATreeElement : this.objects) {
                    try {
                        CnAElementHome.getInstance().refresh(cnATreeElement);
                        CnAElementFactory.getModel(cnATreeElement).childChanged(cnATreeElement);
                    }
                    catch (CommandException e) {
                        LOG.error((Object)"Error synchronizing dependent model elements.");
                    }
                }
            }
        }
    }

    private final class RefreshJobRule
    implements ISchedulingRule {
        private RefreshJobRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule.getClass() == RefreshJobRule.class;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule.getClass() == RefreshJobRule.class;
        }
    }

    private static class RiskPropertyValueLabelNotUniqueException
    extends Exception {
        private static final long serialVersionUID = 4147192368139573141L;
        private final int indexOfFirstErrorPage;

        private RiskPropertyValueLabelNotUniqueException(int indexOfFirstErrorPage) {
            this.indexOfFirstErrorPage = indexOfFirstErrorPage;
        }
    }
}

