/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.bsi.editors.EditorUtil;
import sernet.hui.common.connect.Entity;
import sernet.verinice.model.bpm.TaskInformation;
import sernet.verinice.model.common.CnATreeElement;

public class BSIElementEditorInput
implements IEditorInput {
    private static final Logger LOG = Logger.getLogger(BSIElementEditorInput.class);
    private CnATreeElement element;
    private TaskInformation task;
    private boolean readOnly = false;

    public BSIElementEditorInput(CnATreeElement element) {
        this.element = element;
    }

    public BSIElementEditorInput(CnATreeElement element, TaskInformation task) {
        this.element = element;
        this.task = task;
    }

    public BSIElementEditorInput(CnATreeElement element, boolean isReadOnly) {
        this.element = element;
        this.readOnly = isReadOnly;
    }

    public boolean exists() {
        return true;
    }

    public CnATreeElement getCnAElement() {
        return this.element;
    }

    public Entity getEntity() {
        return this.element.getEntity();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS");
    }

    public String getId() {
        return this.element.getId();
    }

    public String getName() {
        return EditorUtil.getEditorName(this.element);
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return EditorUtil.getEditorToolTipText(this.element);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public static CnATreeElement extractElement(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof BSIElementEditorInput)) {
            return null;
        }
        BSIElementEditorInput elementInput = (BSIElementEditorInput)input;
        if (elementInput.getCnAElement() == null) {
            LOG.warn((Object)"Element in editor input is null.");
            return null;
        }
        return elementInput.getCnAElement();
    }

    public TaskInformation getTask() {
        return this.task;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

