/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.editors.AttachmentEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorRegistry;
import sernet.gs.ui.rcp.main.bsi.editors.InputHelperFactory;
import sernet.gs.ui.rcp.main.bsi.editors.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.NoteEditorInput;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.IEntityChangedListener;
import sernet.hui.common.connect.PropertyChangedEvent;
import sernet.hui.common.multiselectionlist.IMLPropertyOption;
import sernet.hui.common.multiselectionlist.IMLPropertyType;
import sernet.hui.swt.widgets.HitroUIComposite;
import sernet.snutils.DBException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.bsi.Addition;
import sernet.verinice.model.bsi.Attachment;
import sernet.verinice.service.commands.AttachmentFileCreationFactory;
import sernet.verinice.service.commands.SaveNote;

public class AttachmentEditor
extends EditorPart {
    private static final Logger LOG = Logger.getLogger(AttachmentEditor.class);
    public static final String EDITOR_ID = "sernet.gs.ui.rcp.main.bsi.editors.attachmenteditor";
    Attachment attachment;
    Composite parent;
    HitroUIComposite huiComposite;
    Composite contentComp;
    FileDialog fd;
    Text fileName;
    Text textNote;
    Label date;
    private ICommandService commandService;
    private boolean isModelModified = false;
    private IEntityChangedListener modelListener = new IEntityChangedListener(){

        public void dependencyChanged(IMLPropertyType arg0, IMLPropertyOption arg1) {
        }

        public void selectionChanged(IMLPropertyType arg0, IMLPropertyOption arg1) {
            AttachmentEditor.this.modelChanged();
        }

        public void propertyChanged(PropertyChangedEvent evt) {
            AttachmentEditor.this.modelChanged();
        }
    };

    void modelChanged() {
        boolean wasDirty = this.isDirty();
        this.isModelModified = true;
        if (!wasDirty) {
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.isModelModified;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.AttachmentEditor_1, -1);
        boolean isNew = this.attachment.getDbId() == null;
        Set listener = this.attachment.getListener();
        SaveNote command = new SaveNote((Addition)this.attachment);
        try {
            command = (SaveNote)this.getCommandService().executeCommand((ICommand)command);
            this.attachment = (Attachment)command.getAddition();
            this.huiComposite.dispose();
            this.huiComposite = new HitroUIComposite(this.parent, false);
            this.huiComposite.createView(this.attachment.getEntity(), true, true, new String[0], false, ServiceFactory.lookupValidationService().getPropertyTypesToValidate(this.attachment.getEntity(), this.attachment.getDbId()), Activator.getDefault().getPreferenceStore().getBoolean("use_validation_gui_hints"));
            this.parent.layout();
            if (isNew) {
                AttachmentFileCreationFactory.createAttachmentFile((Attachment)this.attachment, (byte[])FileUtils.readFileToByteArray((File)new File(this.attachment.getFilePath())));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving file", (Throwable)e);
            ExceptionUtil.log(e, Messages.AttachmentEditor_3);
        }
        monitor.done();
        this.attachment.getListener().addAll(listener);
        this.isModelModified = false;
        this.firePropertyChange(257);
        this.attachment.getEntity().addChangeListener(this.modelListener);
        this.setPartName(this.attachment.getTitel());
        this.attachment.fireChange();
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof AttachmentEditorInput)) {
            throw new PartInitException(Messages.AttachmentEditor_4);
        }
        AttachmentEditorInput noteEditorInput = (AttachmentEditorInput)input;
        this.attachment = noteEditorInput.getInput();
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(noteEditorInput);
        this.setPartName(noteEditorInput.getName());
        noteEditorInput.getInput().getEntity().addChangeListener(this.modelListener);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.huiComposite = new HitroUIComposite(parent, false);
        try {
            this.huiComposite.createView(this.attachment.getEntity(), true, true, new String[0], false, new ArrayList(0), Activator.getDefault().getPreferenceStore().getBoolean("use_validation_gui_hints"));
        }
        catch (DBException e) {
            LOG.error((Object)"Error while creating editor", (Throwable)e);
        }
        InputHelperFactory.setInputHelpers(HitroUtil.getInstance().getTypeFactory().getEntityType(this.attachment.getEntity().getEntityType()), this.huiComposite);
    }

    public void setFocus() {
    }

    public void dispose() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof NoteEditorInput) {
            EditorRegistry.getInstance().closeEditor(String.valueOf(((NoteEditorInput)editorInput).getId()));
        }
        if (editorInput instanceof AttachmentEditorInput) {
            EditorRegistry.getInstance().closeEditor(String.valueOf(((AttachmentEditorInput)editorInput).getId()));
        }
        super.dispose();
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }
}

