/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd.transfer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.dnd.TransferData;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionModelingTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.VeriniceElementTransfer;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bp.IBpGroup;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.IMassnahmeUmsetzung;
import sernet.verinice.model.iso27k.IISO27kElement;

public class TransferUtil {
    private static final Logger LOG = Logger.getLogger(TransferUtil.class);

    private TransferUtil() {
    }

    public static void iSO27KtoNative(VeriniceElementTransfer transfer, Object data, TransferData transferData) {
        if (data == null || !transfer.validateData(data)) {
            return;
        }
        if (transfer.isSupportedType(transferData)) {
            ArrayList<IISO27kElement> elements = new ArrayList<IISO27kElement>();
            if (data instanceof IISO27kElement[]) {
                elements.addAll(Arrays.asList((IISO27kElement[])data));
            } else if (data instanceof IISO27kElement) {
                elements.add((IISO27kElement)data);
            }
            TransferUtil.write(transfer, transferData, elements);
        }
    }

    public static void baseProtectionElementToNative(BaseProtectionElementTransfer transfer, Object data, TransferData transferData) {
        if (data == null || !transfer.validateData(data)) {
            return;
        }
        if (transfer.isSupportedType(transferData)) {
            ArrayList<IBpElement> elements = new ArrayList<IBpElement>();
            if (data instanceof IBpElement[]) {
                elements.addAll(Arrays.asList((IBpElement[])data));
            } else if (data instanceof IBpElement) {
                elements.add((IBpElement)data);
            }
            TransferUtil.write(transfer, transferData, elements);
        }
    }

    public static void baseProtectionGroupToNative(BaseProtectionModelingTransfer transfer, Object data, TransferData transferData) {
        if (data == null || !transfer.validateData(data)) {
            return;
        }
        if (transfer.isSupportedType(transferData)) {
            List<Object> elements = new LinkedList<IBpGroup>();
            if (data instanceof IBpGroup[]) {
                elements.addAll(Arrays.asList((IBpGroup[])data));
            } else if (data instanceof Object[]) {
                elements = TransferUtil.convertToBpGroupList(data);
            } else if (data instanceof IBpGroup) {
                elements.add((IBpGroup)data);
            }
            TransferUtil.write(transfer, transferData, elements);
        }
    }

    protected static List<IBpGroup> convertToBpGroupList(Object data) {
        LinkedList<IBpGroup> elements = new LinkedList<IBpGroup>();
        Object[] objectArray = (Object[])data;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IBpGroup) {
                elements.add((IBpGroup)o);
            } else {
                LOG.warn((Object)("Element in drag and drop transfer data is not IBpGroup: " + o));
            }
            ++n2;
        }
        return elements;
    }

    public static void bSIStrukturElementToNative(VeriniceElementTransfer transfer, Object data, TransferData transferData) {
        if (data == null || !transfer.validateData(data)) {
            return;
        }
        if (transfer.isSupportedType(transferData)) {
            ArrayList<IBSIStrukturElement> elements = new ArrayList<IBSIStrukturElement>();
            if (data instanceof IBSIStrukturElement[]) {
                elements.addAll(Arrays.asList((IBSIStrukturElement[])data));
                TransferUtil.write(transfer, transferData, elements);
            } else if (data instanceof IBSIStrukturElement) {
                elements.add((IBSIStrukturElement)data);
                TransferUtil.write(transfer, transferData, elements);
            }
            ArrayList<IMassnahmeUmsetzung> massnahmen = new ArrayList<IMassnahmeUmsetzung>();
            if (data instanceof IMassnahmeUmsetzung[]) {
                massnahmen.addAll(Arrays.asList((IMassnahmeUmsetzung[])data));
                TransferUtil.write(transfer, transferData, massnahmen);
            } else if (data instanceof IMassnahmeUmsetzung) {
                massnahmen.add((IMassnahmeUmsetzung)data);
                TransferUtil.write(transfer, transferData, massnahmen);
            }
            ArrayList<BausteinUmsetzung> bausteine = new ArrayList<BausteinUmsetzung>();
            if (data instanceof BausteinUmsetzung[]) {
                bausteine.addAll(Arrays.asList((BausteinUmsetzung[])data));
                TransferUtil.write(transfer, transferData, bausteine);
            } else if (data instanceof BausteinUmsetzung) {
                bausteine.add((BausteinUmsetzung)data);
                TransferUtil.write(transfer, transferData, bausteine);
            }
        }
    }

    private static void write(VeriniceElementTransfer transfer, TransferData transferData, List<?> elements) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(elements.toArray(new Object[elements.size()]));
            transfer.doJavaToNative(out.toByteArray(), transferData);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while serializing object for dnd", (Throwable)e);
        }
    }
}

