/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd.transfer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import sernet.verinice.service.iso27k.Item;

public final class ItemTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME_ITEMELEMENT = Item.class.getCanonicalName();
    private static final int TYPEID_ITEMELEMENT = ItemTransfer.registerType((String)TYPENAME_ITEMELEMENT);
    private static Logger log = Logger.getLogger(ItemTransfer.class);
    private static ItemTransfer instance = new ItemTransfer();

    public static ItemTransfer getInstance() {
        return instance;
    }

    private ItemTransfer() {
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME_ITEMELEMENT};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID_ITEMELEMENT};
    }

    public void javaToNative(Object data, TransferData transferData) {
        block18: {
            if (data == null || !this.validateData(data)) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                ArrayList<Item> elements = new ArrayList<Item>(0);
                if (data instanceof Item[]) {
                    Item[] itemElements;
                    Item[] itemArray = itemElements = (Item[])data;
                    int n = itemElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Item b = itemArray[n2];
                        elements.add(b);
                        ++n2;
                    }
                } else if (data instanceof Item) {
                    elements.add((Item)data);
                }
                ByteArrayOutputStream out = null;
                ObjectOutputStream objectOut = null;
                try {
                    try {
                        out = new ByteArrayOutputStream();
                        objectOut = new ObjectOutputStream(out);
                        objectOut.writeObject(elements.toArray(new Object[elements.size()]));
                        super.javaToNative((Object)out.toByteArray(), transferData);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while serializing object for dnd", (Throwable)e);
                        if (out == null || objectOut == null) break block18;
                        try {
                            out.close();
                            objectOut.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)"Error while closing stream", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (out != null && objectOut != null) {
                        try {
                            out.close();
                            objectOut.close();
                        }
                        catch (IOException e) {
                            log.error((Object)"Error while closing stream", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        Object o = null;
        if (transferData == null) {
            log.error((Object)"transferData is null");
        }
        if (this.isSupportedType(transferData)) {
            byte[] bs = (byte[])super.nativeToJava(transferData);
            if (bs != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(bs);
                try {
                    ObjectInputStream in = new ObjectInputStream(bis);
                    o = in.readObject();
                    bis.close();
                    in.close();
                }
                catch (OptionalDataException e) {
                    log.error((Object)"Wrong data", (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)"Error while transfering dnd object back to java", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Error while transfering dnd object back to java", (Throwable)e);
                }
            } else {
                log.error((Object)"bs is null");
                if (transferData == null) {
                    log.error((Object)"transferData also");
                }
            }
        }
        return o;
    }

    private boolean validateData(Object data) {
        return data instanceof Item || data instanceof Item[];
    }
}

