/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd.transfer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import sernet.verinice.model.iso27k.IISO27kGroup;

public final class ISO27kGroupTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME_ISOGROUP = IISO27kGroup.class.getCanonicalName();
    private static final int TYPEID_ISOGROUP = ISO27kGroupTransfer.registerType((String)TYPENAME_ISOGROUP);
    private static Logger log = Logger.getLogger(ISO27kGroupTransfer.class);
    private static ISO27kGroupTransfer instance = new ISO27kGroupTransfer();

    public static ISO27kGroupTransfer getInstance() {
        return instance;
    }

    private ISO27kGroupTransfer() {
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME_ISOGROUP};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID_ISOGROUP};
    }

    public void javaToNative(Object data, TransferData transferData) {
        block18: {
            if (data == null || !this.validateData(data)) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                ArrayList<IISO27kGroup> groups = new ArrayList<IISO27kGroup>(0);
                if (data instanceof IISO27kGroup[]) {
                    IISO27kGroup[] groupElements;
                    IISO27kGroup[] iISO27kGroupArray = groupElements = (IISO27kGroup[])data;
                    int n = groupElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IISO27kGroup b = iISO27kGroupArray[n2];
                        groups.add(b);
                        ++n2;
                    }
                } else if (data instanceof IISO27kGroup) {
                    groups.add((IISO27kGroup)data);
                }
                ByteArrayOutputStream out = null;
                ObjectOutputStream objectOut = null;
                try {
                    try {
                        out = new ByteArrayOutputStream();
                        objectOut = new ObjectOutputStream(out);
                        objectOut.writeObject(groups.toArray(new Object[groups.size()]));
                        super.javaToNative((Object)out.toByteArray(), transferData);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while serializing object for dnd", (Throwable)e);
                        if (out == null || objectOut == null) break block18;
                        try {
                            out.close();
                            objectOut.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)"Error while closing stream", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (out != null && objectOut != null) {
                        try {
                            out.close();
                            objectOut.close();
                        }
                        catch (IOException e) {
                            log.error((Object)"Error while closing stream", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        Object o = null;
        if (this.isSupportedType(transferData)) {
            byte[] bs = (byte[])super.nativeToJava(transferData);
            ByteArrayInputStream bis = new ByteArrayInputStream(bs);
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                o = in.readObject();
                bis.close();
                in.close();
            }
            catch (OptionalDataException e) {
                log.error((Object)"Wrong data", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error while transfering dnd object back to java", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while transfering dnd object back to java", (Throwable)e);
            }
        }
        return o;
    }

    private boolean validateData(Object data) {
        return data instanceof IISO27kGroup[] || data instanceof IISO27kGroup;
    }
}

