/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd.transfer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import sernet.verinice.model.bsi.BausteinUmsetzung;

public final class BausteinUmsetzungTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME_BAUSTEINELEMENT = BausteinUmsetzung.class.getCanonicalName();
    private static final int TYPEID_BAUSTEINELEMENT = BausteinUmsetzungTransfer.registerType((String)TYPENAME_BAUSTEINELEMENT);
    private static final Logger LOG = Logger.getLogger(BausteinUmsetzungTransfer.class);
    private static BausteinUmsetzungTransfer instance = new BausteinUmsetzungTransfer();

    public static BausteinUmsetzungTransfer getInstance() {
        return instance;
    }

    private BausteinUmsetzungTransfer() {
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME_BAUSTEINELEMENT};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID_BAUSTEINELEMENT};
    }

    public void javaToNative(Object data, TransferData transferData) {
        block18: {
            if (data == null || !this.validateData(data)) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                ArrayList<BausteinUmsetzung> bausteine = new ArrayList<BausteinUmsetzung>(0);
                if (data instanceof BausteinUmsetzung[]) {
                    BausteinUmsetzung[] bausteinElements;
                    BausteinUmsetzung[] bausteinUmsetzungArray = bausteinElements = (BausteinUmsetzung[])data;
                    int n = bausteinElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BausteinUmsetzung b = bausteinUmsetzungArray[n2];
                        bausteine.add(b);
                        ++n2;
                    }
                } else if (data instanceof BausteinUmsetzung) {
                    bausteine.add((BausteinUmsetzung)data);
                }
                ByteArrayOutputStream out = null;
                ObjectOutputStream objectOut = null;
                try {
                    try {
                        out = new ByteArrayOutputStream();
                        objectOut = new ObjectOutputStream(out);
                        objectOut.writeObject(bausteine.toArray(new Object[bausteine.size()]));
                        super.javaToNative((Object)out.toByteArray(), transferData);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error while serializing object for dnd", (Throwable)e);
                        if (out == null || objectOut == null) break block18;
                        try {
                            out.close();
                            objectOut.close();
                        }
                        catch (IOException e2) {
                            LOG.error((Object)"Error while closing stream", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (out != null && objectOut != null) {
                        try {
                            out.close();
                            objectOut.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Error while closing stream", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        Object o = null;
        if (this.isSupportedType(transferData)) {
            byte[] bs = (byte[])super.nativeToJava(transferData);
            ByteArrayInputStream bis = new ByteArrayInputStream(bs);
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                o = in.readObject();
                bis.close();
                in.close();
            }
            catch (OptionalDataException e) {
                LOG.error((Object)"Wrong data", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"Error while transfering dnd object back to java", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Error while transfering dnd object back to java", (Throwable)e);
            }
        }
        return o;
    }

    private boolean validateData(Object data) {
        return data instanceof BausteinUmsetzung || data instanceof BausteinUmsetzung[];
    }
}

