/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd.transfer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import sernet.gs.model.Baustein;

public final class BausteinElementTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME_BAUSTEINELEMENT = "baumstein_gs_model";
    private static final int TYPEID_BAUSTEINELEMENT = BausteinElementTransfer.registerType((String)"baumstein_gs_model");
    private static Logger log = Logger.getLogger(BausteinElementTransfer.class);
    private static BausteinElementTransfer instance = new BausteinElementTransfer();

    public static BausteinElementTransfer getInstance() {
        return instance;
    }

    private BausteinElementTransfer() {
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME_BAUSTEINELEMENT};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID_BAUSTEINELEMENT};
    }

    public void javaToNative(Object data, TransferData transferData) {
        block18: {
            if (data == null || !this.validateData(data)) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                ArrayList<Baustein> bausteine = new ArrayList<Baustein>(0);
                if (data instanceof Baustein[]) {
                    Baustein[] bausteinElements;
                    Baustein[] bausteinArray = bausteinElements = (Baustein[])data;
                    int n = bausteinElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Baustein b = bausteinArray[n2];
                        bausteine.add(b);
                        ++n2;
                    }
                } else if (data instanceof Baustein) {
                    bausteine.add((Baustein)data);
                }
                ByteArrayOutputStream out = null;
                ObjectOutputStream objectOut = null;
                try {
                    try {
                        out = new ByteArrayOutputStream();
                        objectOut = new ObjectOutputStream(out);
                        objectOut.writeObject(bausteine.toArray(new Object[bausteine.size()]));
                        super.javaToNative((Object)out.toByteArray(), transferData);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while serializing object for dnd", (Throwable)e);
                        if (out == null || objectOut == null) break block18;
                        try {
                            out.close();
                            objectOut.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)"Error while closing stream", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (out != null && objectOut != null) {
                        try {
                            out.close();
                            objectOut.close();
                        }
                        catch (IOException e) {
                            log.error((Object)"Error while closing stream", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        Object o = null;
        if (this.isSupportedType(transferData)) {
            byte[] bs = (byte[])super.nativeToJava(transferData);
            ByteArrayInputStream bis = new ByteArrayInputStream(bs);
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                o = in.readObject();
                bis.close();
                in.close();
            }
            catch (OptionalDataException e) {
                log.error((Object)"Wrong data", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error while transfering dnd object back to java", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while transfering dnd object back to java", (Throwable)e);
            }
        }
        return o;
    }

    private boolean validateData(Object data) {
        return data instanceof Baustein[] || data instanceof Baustein;
    }
}

