/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import sernet.gs.ui.rcp.main.bsi.dnd.LinkDropper;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.action.DropPerformer;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.service.commands.LoadElementByUuid;

public class SearchViewDropListener
extends ViewerDropAdapter
implements DropPerformer,
RightEnabledUserInteraction {
    private static final Logger log = Logger.getLogger(SearchViewDropListener.class);
    private boolean isActive = false;
    private Object target = null;

    public SearchViewDropListener(TableViewer viewer) {
        super((Viewer)viewer);
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "bsidnd";
    }

    @Override
    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("validateDrop, \n\t transfer type class: " + transferType.getClass().getName()));
        }
        if (!this.checkRights()) {
            return false;
        }
        if (target == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"target null - false");
            }
            this.isActive = false;
            return this.isActive;
        }
        this.target = target;
        this.isActive = target instanceof VeriniceSearchResultRow;
        if (log.isDebugEnabled()) {
            log.debug((Object)("validation returns " + this.isActive));
        }
        return this.isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean performDrop(Object toDrop) {
        Object[] dataToDrop = (Object[])toDrop;
        if (dataToDrop == null || dataToDrop.length == 0) {
            log.error((Object)"data missing");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"performDrop");
        }
        Object firstObject = dataToDrop[0];
        if (this.isActive()) {
            return this.handleDrop(dataToDrop);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(firstObject + " not supported element"));
        }
        return false;
    }

    private boolean handleDrop(Object[] data) {
        CnATreeElement element;
        if (log.isDebugEnabled()) {
            log.debug((Object)"BSI");
        }
        ArrayList<CnATreeElement> toDrop = new ArrayList<CnATreeElement>(data.length);
        Object[] objectArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            toDrop.add((CnATreeElement)object);
            ++n2;
        }
        LoadElementByUuid command = new LoadElementByUuid(((VeriniceSearchResultRow)this.target).getIdentifier());
        try {
            command = (LoadElementByUuid)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            element = command.getElement();
        }
        catch (CommandException e) {
            log.error((Object)e);
            return false;
        }
        LinkDropper dropper = new LinkDropper();
        return dropper.dropLink(toDrop, element);
    }

    @Override
    public boolean performDrop(Object data, Object target, Viewer viewer) {
        return this.performDrop(data);
    }

    public void drop(DropTargetEvent event) {
        log.debug((Object)("entered drop(DropTargetEvent event) with event:" + event.toString()));
        this.target = this.determineTarget(event);
        super.drop(event);
    }
}

