/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDHelper;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.SearchViewElementTransfer;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.service.commands.LoadElementsByUuid;

public class SearchViewDragListener
implements DragSourceListener {
    private static final Logger LOG = Logger.getLogger(SearchViewDragListener.class);
    TableViewer viewer;

    public SearchViewDragListener(TableViewer viewer) {
        this.viewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null) {
            event.doit = false;
            return;
        }
        for (Object o : selection) {
            if (o instanceof VeriniceSearchResultRow) continue;
            event.doit = false;
            return;
        }
        event.doit = true;
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.validateDrag(event)) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Object[] elements = this.getElements(selection);
            event.data = DNDHelper.castDataArray(elements);
        }
    }

    private CnATreeElement[] getElements(IStructuredSelection selection) {
        HashSet elements = new HashSet();
        ArrayList<String> uuidList = new ArrayList<String>();
        for (Object object : selection.toList()) {
            if (!(object instanceof VeriniceSearchResultRow)) continue;
            VeriniceSearchResultRow resultRow = (VeriniceSearchResultRow)object;
            uuidList.add(resultRow.getIdentifier());
        }
        LoadElementsByUuid command = new LoadElementsByUuid(uuidList, RetrieveInfo.getPropertyInstance());
        try {
            command = (LoadElementsByUuid)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            elements.addAll(command.getElements());
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while loading elements.", (Throwable)e);
        }
        return elements.toArray(new CnATreeElement[elements.size()]);
    }

    private boolean validateDrag(DragSourceEvent event) {
        return SearchViewElementTransfer.getInstance().isSupportedType(event.dataType);
    }

    public void dragFinished(DragSourceEvent event) {
    }
}

