/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;
import sernet.gs.model.Baustein;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.dialogs.SanityCheckDialog;
import sernet.gs.ui.rcp.main.bsi.dnd.CnPItems;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDItems;
import sernet.gs.ui.rcp.main.bsi.dnd.LinkDropper;
import sernet.gs.ui.rcp.main.bsi.dnd.Messages;
import sernet.gs.ui.rcp.main.common.model.BuildInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.common.CnATreeElement;

public class PasteBsiModelViewAction
extends Action {
    private TreeViewer view;

    public PasteBsiModelViewAction(TreeViewer view, String text) {
        super(text);
        this.view = view;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setToolTipText(Messages.getString("PasteBsiModelViewAction.0"));
    }

    public void run() {
        List items = CnPItems.getItems();
        if (items.size() == 0) {
            return;
        }
        if (items.get(0) instanceof Baustein) {
            for (Object item : items) {
                if (item instanceof Baustein) continue;
                return;
            }
            try {
                IStructuredSelection sel = (IStructuredSelection)this.view.getSelection();
                if (!this.checkLayers(items, sel)) {
                    return;
                }
                Job dropJob = this.bausteinDropJob(sel);
                dropJob.setUser(true);
                dropJob.setSystem(false);
                dropJob.schedule();
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)Messages.getString("PasteBsiModelViewAction.1"), (Throwable)e);
            }
        }
        if (items.get(0) instanceof IBSIStrukturElement) {
            for (Object object : items) {
                if (object instanceof IBSIStrukturElement) continue;
                return;
            }
            IStructuredSelection targets = (IStructuredSelection)this.view.getSelection();
            LinkDropper dropper = new LinkDropper();
            for (Object target : targets) {
                if (!(target instanceof IBSIStrukturElement)) continue;
                dropper.dropLink(items, (CnATreeElement)target);
            }
        }
    }

    private Job bausteinDropJob(final IStructuredSelection targets) {
        Job dropJob = new Job(Messages.getString("PasteBsiModelViewAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                Activator.inheritVeriniceContextState();
                monitor.beginTask(Messages.getString("PasteBsiModelViewAction.3"), targets.size());
                try {
                    CnATreeElement saveNew = null;
                    for (Object o : targets) {
                        if (o instanceof CnATreeElement) {
                            CnATreeElement target = (CnATreeElement)o;
                            saveNew = PasteBsiModelViewAction.this.pasteBausteine(target, monitor);
                        }
                        monitor.worked(1);
                    }
                    CnAElementFactory.getLoadedModel().databaseChildAdded(saveNew);
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"Drop failed", (Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                DNDItems.clear();
                return Status.OK_STATUS;
            }
        };
        return dropJob;
    }

    private boolean checkLayers(List items, IStructuredSelection sel) {
        block0: for (Object o : sel) {
            if (!(o instanceof CnATreeElement)) continue;
            CnATreeElement target = (CnATreeElement)o;
            for (Object sourceObject : items) {
                Baustein sourceBst;
                int targetSchicht = 0;
                if (target instanceof IBSIStrukturElement) {
                    targetSchicht = ((IBSIStrukturElement)target).getSchicht();
                }
                if (!(sourceObject instanceof Baustein) || !target.canContain(sourceObject) || (sourceBst = (Baustein)sourceObject).getSchicht() == targetSchicht) continue;
                if (SanityCheckDialog.checkLayer(this.view.getControl().getShell(), sourceBst.getSchicht(), targetSchicht)) break block0;
                return false;
            }
        }
        return true;
    }

    private CnATreeElement pasteBausteine(CnATreeElement target, IProgressMonitor mon) {
        List items = CnPItems.getItems();
        CnATreeElement saveNew = null;
        for (Object o : items) {
            Baustein baustein;
            if (!(o instanceof Baustein) || !target.canContain((Object)(baustein = (Baustein)o))) continue;
            try {
                mon.subTask(baustein.getTitel());
                saveNew = CnAElementFactory.getInstance().saveNew(target, "bstumsetzung", new BuildInput<Baustein>(baustein), false, false);
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)Messages.getString("PasteBsiModelViewAction.5"), (Throwable)e);
            }
        }
        return saveNew;
    }
}

