/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.dnd.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.verinice.model.common.CnATreeElement;

public class LinkDropper {
    private static final Logger LOG = Logger.getLogger(LinkDropper.class);

    public boolean dropLink(final List<CnATreeElement> toDrop, final CnATreeElement target) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"dropLink...");
            this.logParameter(toDrop, target);
        }
        if (!CnAElementHome.getInstance().isWriteAllowed(target)) {
            return false;
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            Job dropJob = new Job(Messages.getString("LinkDropper.0")){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Activator.inheritVeriniceContextState();
                        CnAElementHome.getInstance().createLinksAccordingToBusinessLogic(target, toDrop);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Drop failed", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            dropJob.schedule();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.getString("LinkDropper.2"), (Throwable)e);
            return false;
        }
        return true;
    }

    private void logParameter(List<CnATreeElement> droppedElements, CnATreeElement target) {
        LOG.debug((Object)"Dropped elements:");
        for (CnATreeElement element : droppedElements) {
            LOG.debug((Object)element);
        }
        LOG.debug((Object)("Drop target: " + target));
    }
}

