/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.Massnahme;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.IMassnahmeUmsetzung;
import sernet.verinice.model.iso27k.IISO27kElement;
import sernet.verinice.service.iso27k.Item;

public final class DNDHelper {
    private static final Logger LOG = Logger.getLogger(DNDHelper.class);
    private static Class<?>[] classes = new Class[]{Baustein.class, BausteinUmsetzung.class, Massnahme.class, Gefaehrdung.class, IBSIStrukturElement.class, IISO27kElement.class, IMassnahmeUmsetzung.class, Item.class, IBpElement.class};
    private static final String STD_ERR_MSG = "Error while casting dnd list";

    private DNDHelper() {
    }

    public static List arrayToList(Object data) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (data instanceof Object[]) {
            Object[] o;
            Object[] objectArray = o = (Object[])data;
            int n = o.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                list.add(object);
                ++n2;
            }
        } else if (data instanceof Collection) {
            Collection tmp = (Collection)data;
            for (Object tmpO : tmp) {
                list.add(tmpO);
            }
        } else if (data instanceof Object) {
            list.add(data);
        }
        return list;
    }

    public static Object[] castDataArray(Object[] source) {
        Class type = Object.class;
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (source.length > 0 && c.isInstance(source[0])) {
                type = c;
                break;
            }
            ++n2;
        }
        ArrayList dest = new ArrayList();
        Object[] objectArray = source;
        int n3 = source.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray[n];
            if (type.isInstance(o)) {
                try {
                    dest.add(type.cast(o));
                }
                catch (SecurityException e) {
                    LOG.error((Object)STD_ERR_MSG, (Throwable)e);
                }
            } else {
                LOG.warn((Object)"DND source contains multiple types. Return an empty array");
                return new Object[0];
            }
            ++n;
        }
        return dest.toArray((Object[])Array.newInstance(type, dest.size()));
    }
}

