/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.IGSModel;
import sernet.gs.model.Massnahme;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.dialogs.SanityCheckDialog;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDHelper;
import sernet.gs.ui.rcp.main.bsi.dnd.LinkDropper;
import sernet.gs.ui.rcp.main.bsi.dnd.Messages;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionModelingTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BausteinElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BausteinUmsetzungTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IBSIStrukturElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IGSModelElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ISO27kElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ISO27kGroupTransfer;
import sernet.gs.ui.rcp.main.bsi.views.BSIKatalogInvisibleRoot;
import sernet.gs.ui.rcp.main.common.model.BuildInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.ITypedElement;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.CnATreeElementBuildException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.RcpModelUpdater;
import sernet.verinice.iso27k.rcp.action.DropPerformer;
import sernet.verinice.iso27k.service.IModelUpdater;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.IBSIStrukturKategorie;
import sernet.verinice.model.bsi.IMassnahmeUmsetzung;
import sernet.verinice.model.bsi.MassnahmenUmsetzung;
import sernet.verinice.model.bsi.risikoanalyse.GefaehrdungsUmsetzung;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Permission;
import sernet.verinice.model.iso27k.IISO27kElement;
import sernet.verinice.model.iso27k.IISO27kGroup;
import sernet.verinice.service.commands.SaveElement;
import sernet.verinice.service.commands.crud.GetElementPathCommand;
import sernet.verinice.service.gstoolimport.GefaehrdungsUmsetzungFactory;
import sernet.verinice.service.gstoolimport.MassnahmenFactory;

public class BSIModelViewDropListener
extends ViewerDropAdapter
implements RightEnabledUserInteraction,
DropPerformer {
    private TreeViewer viewer;
    private static final Logger LOG = Logger.getLogger(BSIModelViewDropListener.class);
    private boolean isActive = false;
    private Object target = null;
    private IAuthService authService;
    private ICommandService commandService;
    private IModelUpdater modelUpdater;

    public BSIModelViewDropListener(TreeViewer viewer) {
        super((Viewer)viewer);
        this.viewer = viewer;
        this.modelUpdater = new RcpModelUpdater();
    }

    public boolean performDrop(Object data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("performDrop, data: " + data));
        }
        Object[] toDrop = data;
        Object[] selectedData = null;
        if (data == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"data is null - setting to selected Object");
            }
            selectedData = ((IStructuredSelection)this.getViewer().getSelection()).toArray();
        } else {
            if (data instanceof Object[] && ((Object[])data).length == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No items in drag list");
                }
                return false;
            }
            selectedData = data;
        }
        List items = DNDHelper.arrayToList(selectedData);
        Object firstOne = items.get(0);
        if (toDrop != null && toDrop instanceof Object[]) {
            Object[] o = toDrop;
            if (o.length > 0) {
                firstOne = o[0];
            }
        } else if (toDrop != null && toDrop instanceof Object) {
            firstOne = toDrop;
        }
        if (this.isActive()) {
            if (firstOne instanceof Baustein && this.target.getClass().getPackage().getName().contains("model.bsi")) {
                ArrayList<Baustein> list = new ArrayList<Baustein>(0);
                for (Object object : items) {
                    if (!(object instanceof Baustein)) continue;
                    list.add((Baustein)object);
                }
                return this.dropBaustein((CnATreeElement)this.target, (Viewer)this.viewer, list.toArray(new Baustein[list.size()]));
            }
            if (firstOne instanceof IGSModel && this.target instanceof BausteinUmsetzung) {
                ArrayList<Gefaehrdung> scenarios = new ArrayList<Gefaehrdung>(0);
                ArrayList<Massnahme> controls = new ArrayList<Massnahme>(0);
                for (Object object : items) {
                    if (object instanceof Gefaehrdung) {
                        scenarios.add((Gefaehrdung)object);
                        continue;
                    }
                    if (!(object instanceof Massnahme)) continue;
                    controls.add((Massnahme)object);
                }
                return this.dropScenarios((BausteinUmsetzung)this.target, (Viewer)this.viewer, scenarios) && this.dropControls((BausteinUmsetzung)this.target, (Viewer)this.viewer, controls);
            }
            if (firstOne != null && this.isLinkableElement(firstOne)) {
                CnATreeElement element = (CnATreeElement)this.target;
                LinkDropper dropper = new LinkDropper();
                ArrayList<CnATreeElement> list = new ArrayList<CnATreeElement>();
                for (Object object : items) {
                    if (!(object instanceof CnATreeElement)) continue;
                    list.add((CnATreeElement)object);
                }
                return dropper.dropLink(list, element);
            }
        }
        return false;
    }

    protected boolean isLinkableElement(Object element) {
        return element instanceof IBSIStrukturElement || element instanceof BausteinUmsetzung || element instanceof IISO27kElement || element instanceof IMassnahmeUmsetzung || element instanceof IBpElement;
    }

    public void drop(DropTargetEvent event) {
        LOG.debug((Object)"entered drop(DropTargetEvent event)");
        this.target = this.determineTarget(event);
        super.drop(event);
    }

    @Override
    public boolean validateDrop(Object target, int operation, TransferData transferData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("validateDrop, target: " + target));
        }
        if (!this.checkRights()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ChechRights() failed  ... return false");
            }
            return false;
        }
        if (BaseProtectionModelingTransfer.getInstance().isSupportedType(transferData)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Elements dragged from base protection catalog view return false");
            }
            this.isActive = false;
            return this.isActive;
        }
        if (target == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Target is null ... return false");
            }
            this.isActive = false;
            return this.isActive;
        }
        this.target = target;
        if (!(target instanceof CnATreeElement)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Target is no CnATreeElement ... return false");
            }
            this.isActive = false;
            return this.isActive;
        }
        if (target instanceof IBSIStrukturKategorie) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Target is BSI category ... return false");
            }
            this.isActive = false;
            return this.isActive;
        }
        if (target instanceof BausteinUmsetzung && ISO27kElementTransfer.getInstance().isSupportedType(transferData)) {
            this.isActive = true;
            return this.isActive;
        }
        if (target instanceof BausteinUmsetzung && !IBSIStrukturElementTransfer.getInstance().isSupportedType(transferData)) {
            if (IGSModelElementTransfer.getInstance().isSupportedType(transferData) && ((BausteinUmsetzung)target).isOwnModule()) {
                this.isActive = true;
            } else {
                this.isActive = false;
                LOG.debug((Object)"target is BausteinUmsetzung, transferType not supported; return false");
            }
            return this.isActive;
        }
        if (target instanceof IBSIStrukturElement && this.isSupportedData(transferData)) {
            this.isActive = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"target is IBSIStrukturElement,  isSupportedData return false");
            }
            return this.isActive;
        }
        if (target instanceof IISO27kGroup && BausteinElementTransfer.getInstance().isSupportedType(transferData)) {
            this.isActive = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"target is IISO27kGroup,  IISO27kGroup return true");
            }
            return this.isActive;
        }
        if (IGSModelElementTransfer.getInstance().isSupportedType(transferData)) {
            this.isActive = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"IGSModelElementTransfer.getInstance().isSupportedType(..) return true");
            }
            return this.isActive;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"validateDrop, returning default: true");
        }
        this.isActive = true;
        return this.isActive;
    }

    public boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "bsidnd";
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    private boolean dropBaustein(final CnATreeElement target, Viewer viewer, final Baustein[] bausteine) {
        if (!CnAElementHome.getInstance().isNewChildAllowed(target)) {
            return false;
        }
        Baustein[] bausteinArray = bausteine;
        int n = bausteine.length;
        int n2 = 0;
        while (n2 < n) {
            Baustein baustein = bausteinArray[n2];
            int targetSchicht = 0;
            if (target instanceof IBSIStrukturElement) {
                targetSchicht = ((IBSIStrukturElement)target).getSchicht();
            }
            if (baustein.getSchicht() != targetSchicht) {
                if (SanityCheckDialog.checkLayer(viewer.getControl().getShell(), baustein.getSchicht(), targetSchicht)) break;
                return false;
            }
            ++n2;
        }
        try {
            Job dropJob = new Job(Messages.getString("BSIModelViewDropListener.3")){

                protected IStatus run(IProgressMonitor monitor) {
                    Activator.inheritVeriniceContextState();
                    try {
                        BSIModelViewDropListener.this.createBausteinUmsetzung(bausteine, target);
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"Drop failed", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            dropJob.setUser(true);
            dropJob.setSystem(false);
            dropJob.schedule();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.getString("BSIModelViewDropListener.5"), (Throwable)e);
            return false;
        }
        return true;
    }

    private void createBausteinUmsetzung(Baustein[] toDrop, CnATreeElement target) throws CnATreeElementBuildException, CommandException {
        CnATreeElement saveNew = null;
        Baustein[] bausteinArray = toDrop;
        int n = toDrop.length;
        int n2 = 0;
        while (n2 < n) {
            Baustein baustein = bausteinArray[n2];
            saveNew = CnAElementFactory.getInstance().saveNew(target, "bstumsetzung", new BuildInput<Baustein>(baustein), false, false);
            ++n2;
        }
        if (saveNew != null) {
            CnAElementFactory.getLoadedModel().childAdded(target, saveNew);
        }
    }

    private boolean dropControls(final BausteinUmsetzung targetModule, Viewer viewer, final List<Massnahme> controls) {
        if (!CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)targetModule)) {
            return false;
        }
        try {
            Job dropJob = new Job(Messages.getString("BSIModelViewDropListener.6")){

                protected IStatus run(IProgressMonitor monitor) {
                    Activator.inheritVeriniceContextState();
                    try {
                        BSIModelViewDropListener.this.addControlsToModule(controls, targetModule);
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"Drop failed", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            dropJob.setUser(true);
            dropJob.setSystem(false);
            dropJob.schedule();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.getString("BSIModelViewDropListener.5"), (Throwable)e);
            return false;
        }
        return true;
    }

    private void addControlsToModule(List<Massnahme> controlsToDrop, BausteinUmsetzung targetModule) throws CnATreeElementBuildException, CommandException {
        for (Massnahme controlToDrop : controlsToDrop) {
            if (targetModule.containsControl(controlToDrop.getId())) {
                GetElementPathCommand pathLoader = new GetElementPathCommand(targetModule.getUuid(), targetModule.getTypeId());
                String elementPath = ((GetElementPathCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)pathLoader)).getResult();
                LOG.error((Object)("ElementContainer:\t" + elementPath + "(" + targetModule.getDbId() + ")" + "\twith TypeId:\t" + targetModule.getTypeId() + " contains already a control with id:\t" + controlToDrop.getId() + "\t" + controlToDrop.getTitel() + " is skipped because of this"));
                continue;
            }
            this.addControlToModule(controlToDrop, targetModule);
        }
    }

    private CnATreeElement addControlToModule(Massnahme controlToDrop, BausteinUmsetzung targetModule) {
        MassnahmenFactory mFactory = new MassnahmenFactory();
        MassnahmenUmsetzung control = mFactory.createMassnahmenUmsetzung(targetModule, controlToDrop, BSIKatalogInvisibleRoot.getInstance().getLanguage());
        this.setNewPermissions((CnATreeElement)control);
        control = this.saveElementAndAddToModule(targetModule, (CnATreeElement)control);
        this.modelUpdater.childAdded((CnATreeElement)targetModule, (CnATreeElement)control);
        return control;
    }

    private boolean dropScenarios(final BausteinUmsetzung targetModule, Viewer viewer, final List<Gefaehrdung> scenarios) {
        if (!CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)targetModule)) {
            return false;
        }
        try {
            Job dropJob = new Job(Messages.getString("BSIModelViewDropListener.7")){

                protected IStatus run(IProgressMonitor monitor) {
                    Activator.inheritVeriniceContextState();
                    try {
                        BSIModelViewDropListener.this.addScenariosToModule(scenarios, targetModule);
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"Drop failed", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            dropJob.setUser(true);
            dropJob.setSystem(false);
            dropJob.schedule();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.getString("BSIModelViewDropListener.5"), (Throwable)e);
            return false;
        }
        return true;
    }

    private void addScenariosToModule(List<Gefaehrdung> scenariosToDrop, BausteinUmsetzung targetModule) throws CnATreeElementBuildException, CommandException {
        for (Gefaehrdung scenarioToDrop : scenariosToDrop) {
            if (targetModule.containsScenario(scenarioToDrop.getId())) {
                GetElementPathCommand pathLoader = new GetElementPathCommand(targetModule.getUuid(), targetModule.getTypeId());
                String elementPath = ((GetElementPathCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)pathLoader)).getResult();
                LOG.error((Object)("ElementContainer:\t" + elementPath + "(" + targetModule.getDbId() + ")" + "\twith TypeId:\t" + targetModule.getTypeId() + " contains already a scenario with id:\t" + scenarioToDrop.getId() + "\t" + scenarioToDrop.getTitel() + " is skipped because of this"));
                continue;
            }
            this.addScenarioToModule(scenarioToDrop, targetModule);
        }
    }

    private CnATreeElement addScenarioToModule(Gefaehrdung scenarioToDrop, BausteinUmsetzung targetModule) {
        GefaehrdungsUmsetzung scenario = GefaehrdungsUmsetzungFactory.createScenario((BausteinUmsetzung)targetModule, (Gefaehrdung)scenarioToDrop, (String)BSIKatalogInvisibleRoot.getInstance().getLanguage());
        this.setNewPermissions((CnATreeElement)scenario);
        scenario = this.saveElementAndAddToModule(targetModule, (CnATreeElement)scenario);
        this.modelUpdater.childAdded((CnATreeElement)targetModule, (CnATreeElement)scenario);
        return scenario;
    }

    private void setNewPermissions(CnATreeElement element) {
        HashSet<Permission> newperms = new HashSet<Permission>();
        newperms.add(Permission.createPermission((CnATreeElement)element, (String)this.getAuthService().getUsername(), (boolean)true, (boolean)true));
        element.setPermissions(newperms);
    }

    private CnATreeElement saveElementAndAddToModule(BausteinUmsetzung targetModule, CnATreeElement element) {
        try {
            SaveElement command = new SaveElement((ITypedElement)element);
            command = (SaveElement)this.getCommandService().executeCommand((ICommand)command);
            element = (CnATreeElement)command.getElement();
            element.setParentAndScope((CnATreeElement)targetModule);
            targetModule.addChild(element);
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while inserting scenario", (Throwable)e);
            throw new RuntimeException("Error while inserting scenario", e);
        }
        return element;
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private boolean isSupportedData(TransferData transferType) {
        boolean retVal = IGSModelElementTransfer.getInstance().isSupportedType(transferType) || IBSIStrukturElementTransfer.getInstance().isSupportedType(transferType) || BausteinUmsetzungTransfer.getInstance().isSupportedType(transferType);
        retVal = retVal || ISO27kElementTransfer.getInstance().isSupportedType(transferType) || ISO27kGroupTransfer.getInstance().isSupportedType(transferType);
        return retVal;
    }

    @Override
    public boolean performDrop(Object data, Object target, Viewer viewer) {
        return this.performDrop(data);
    }

    private IAuthService getAuthService() {
        if (this.authService == null) {
            this.authService = this.createAuthService();
        }
        return this.authService;
    }

    private IAuthService createAuthService() {
        return ServiceFactory.lookupAuthService();
    }

    private ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }
}

