/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDHelper;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BausteinElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BausteinUmsetzungTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IBSIStrukturElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ISO27kElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ISO27kGroupTransfer;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.bsi.BausteinUmsetzung;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.IMassnahmeUmsetzung;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.iso27k.IISO27kElement;

public class BSIModelViewDragListener
implements DragSourceListener {
    private TreeViewer viewer;

    public BSIModelViewDragListener(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (this.validateDrag(event)) {
            event.data = DNDHelper.castDataArray(selection.toArray());
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null) {
            event.doit = false;
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (this.isDragableElement(iter.next())) continue;
            event.doit = false;
            return;
        }
        event.doit = true;
    }

    protected boolean isDragableElement(Object element) {
        return (element instanceof BausteinUmsetzung || element instanceof IBSIStrukturElement || element instanceof IISO27kElement || element instanceof IMassnahmeUmsetzung || element instanceof IBpElement) && !(element instanceof ITVerbund);
    }

    private boolean validateDrag(DragSourceEvent event) {
        return BausteinElementTransfer.getInstance().isSupportedType(event.dataType) || IBSIStrukturElementTransfer.getInstance().isSupportedType(event.dataType) || IBSIStrukturElementTransfer.getInstance().isSupportedType(event.dataType) || BausteinUmsetzungTransfer.getInstance().isSupportedType(event.dataType) || ISO27kElementTransfer.getInstance().isSupportedType(event.dataType) || ISO27kGroupTransfer.getInstance().isSupportedType(event.dataType) || BaseProtectionElementTransfer.getInstance().isSupportedType(event.dataType);
    }
}

