/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dnd;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.Massnahme;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDHelper;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IGSModelElementTransfer;

public class BSIMassnahmenViewDragListener
implements DragSourceListener {
    private TreeViewer viewer;
    private static final Logger LOG = Logger.getLogger(BSIMassnahmenViewDragListener.class);

    public BSIMassnahmenViewDragListener(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("selection: " + (TreeSelection)this.viewer.getSelection()));
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (this.validateDrag(event)) {
            event.data = DNDHelper.castDataArray(selection.toArray());
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null) {
            event.doit = false;
            return;
        }
        ArrayList selectionList = new ArrayList(selection.size());
        for (Object o : selection) {
            selectionList.add(o);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("validateDrag, selection: " + o.toString()));
            }
            if (o instanceof Baustein || o instanceof Gefaehrdung || o instanceof Massnahme) continue;
            event.doit = false;
            return;
        }
        event.doit = true;
    }

    private boolean validateDrag(DragSourceEvent event) {
        return IGSModelElementTransfer.getInstance().isSupportedType(event.dataType);
    }
}

