/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.encryption.EncryptionException;
import sernet.verinice.interfaces.encryption.IEncryptionService;
import sernet.verinice.interfaces.encryption.PasswordException;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.Mutex;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.SWTElementFactory;
import sernet.verinice.service.commands.SyncCommand;
import sernet.verinice.service.commands.SyncParameter;
import sernet.verinice.service.commands.SyncParameterException;
import sernet.verinice.service.sync.VnaSchemaException;

public class XMLImportDialog
extends Dialog {
    private static final Logger LOG = Logger.getLogger(XMLImportDialog.class);
    private static final String SYNC_REQUEST = "syncRequest>";
    private boolean insert;
    private boolean update;
    private boolean delete;
    private boolean integrate;
    private boolean importAsCatalog;
    private Button integrateButton;
    private Button insertButton;
    private Button updateButton;
    private Button deleteCheck;
    private Text dataPathText;
    private boolean dataPathFlag;
    private File dataFile;
    private ISchedulingRule iSchedulingRule = new Mutex();
    private boolean usePasswordEncryption = false;
    private String password = "";
    private boolean useDefaultFolder;
    private String defaultFolder;
    private Integer format = SyncParameter.EXPORT_FORMAT_DEFAULT;
    private int fileDialogFilterIndex = 0;
    private static final int PASSWORD_INDEX = 2;
    private static final int NOCRYPT_INDEX = 0;
    private SyncCommand syncCommand;

    public XMLImportDialog(Shell shell) {
        super(shell);
    }

    public XMLImportDialog(Shell shell, boolean catalogImport) {
        super(shell);
        this.importAsCatalog = catalogImport;
    }

    public void okPressed() {
        final SyncParameter syncParameter = this.tryCreateSyncParameter();
        if (!this.dataPathFlag && syncParameter == null) {
            this.createErrorMessage(3);
        } else if (!this.dataPathFlag) {
            this.createErrorMessage(1);
        } else if (syncParameter == null) {
            this.createErrorMessage(2);
        } else {
            if (this.useDefaultFolder) {
                this.setDefaultFolder(this.dataFile.getAbsolutePath());
            }
            WorkspaceJob importJob = new WorkspaceJob(Messages.XMLImportDialog_4){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        try {
                            monitor.beginTask(NLS.bind((String)Messages.XMLImportDialog_5, (Object[])new Object[]{XMLImportDialog.this.dataFile.getName()}), -1);
                            SyncCommand.Status importStatus = XMLImportDialog.this.doImport(syncParameter);
                            if (importStatus == SyncCommand.Status.FAILED) {
                                status = this.handleImportError();
                            }
                        }
                        catch (PasswordException e) {
                            status = new Status(4, "sernet.gs.ui.rcp.main", Messages.XMLImportDialog_13, (Throwable)e);
                            monitor.done();
                        }
                        catch (Exception e) {
                            status = this.handleGenericError(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return status;
                }

                private IStatus handleImportError() {
                    Exception errorCause = XMLImportDialog.this.syncCommand.getErrorCause();
                    if (errorCause == null) {
                        return Status.OK_STATUS;
                    }
                    if (errorCause instanceof VnaSchemaException) {
                        VnaSchemaException archiveException = (VnaSchemaException)errorCause;
                        String vnaSchemaVersion = archiveException.getVnaSchemaVersion();
                        String compatibleVersions = StringUtils.join((Collection)archiveException.getOfferedVnaSchemaVersions(), (String)", ");
                        Object[] msgParams = new Object[]{vnaSchemaVersion, compatibleVersions};
                        String msg = null;
                        msg = archiveException.getOfferedVnaSchemaVersions().size() > 1 ? NLS.bind((String)Messages.XMLImportDialog_ARCHIV_IMPORT_ERROR_MULTI_VERSION, (Object[])msgParams) : NLS.bind((String)Messages.XMLImportDialog_ARCHIV_IMPORT_ERROR_SINGLE_VERSION, (Object[])msgParams);
                        return new Status(4, "sernet.gs.ui.rcp.main", msg);
                    }
                    return Status.OK_STATUS;
                }

                private IStatus handleGenericError(Exception e) {
                    LOG.error((Object)"Error while importing data.", (Throwable)e);
                    Status status = new Status(4, "sernet.gs.ui.rcp.main", Messages.XMLImportDialog_17, (Throwable)e);
                    return status;
                }
            };
            JobScheduler.scheduleJob(importJob, this.iSchedulingRule);
            this.close();
        }
    }

    private SyncParameter tryCreateSyncParameter() {
        try {
            return new SyncParameter(this.insert, this.update, this.delete, this.integrate, this.importAsCatalog, this.format);
        }
        catch (SyncParameterException ex) {
            LOG.debug((Object)ex.getLocalizedMessage());
            return null;
        }
    }

    private void setDefaultFolder(String dataPath) {
        String currentPath = "";
        try {
            if (dataPath != null && !dataPath.isEmpty()) {
                int lastSlash = dataPath.lastIndexOf(System.getProperty("file.separator"));
                currentPath = lastSlash != -1 ? dataPath.substring(0, lastSlash + 1) : dataPath.substring(0, lastSlash);
            }
            Activator.getDefault().getPreferenceStore().setValue("default_folder_import", currentPath);
        }
        catch (Exception exe) {
            LOG.error((Object)"Error while setting Preference Constants", (Throwable)exe);
        }
    }

    private void createErrorMessage(int caseNumber) {
        String messageBody;
        String titel = Messages.XMLImportDialog_18;
        switch (caseNumber) {
            case 1: {
                messageBody = Messages.XMLImportDialog_20;
                break;
            }
            case 2: {
                messageBody = Messages.XMLImportDialog_21;
                break;
            }
            case 3: {
                messageBody = Messages.XMLImportDialog_22;
                break;
            }
            case 4: {
                messageBody = Messages.XMLImportDialog_23;
                break;
            }
            default: {
                messageBody = Messages.XMLImportDialog_19;
            }
        }
        MessageDialog messageDialog = new MessageDialog(this.getShell(), titel, null, messageBody, 1, new String[]{Messages.XMLImportDialog_24}, 1);
        messageDialog.open();
    }

    protected Control createDialogArea(Composite parent) {
        int layoutNumColumns = 5;
        int layoutVerticalSpacing = 15;
        int separatorHorizontalSpan = 5;
        int operationHorizontalSpan = 5;
        int operationVerticalSpan = 3;
        int pbeNumColumns = 3;
        int cryptGroupHorizontalSpan = 5;
        int passwordWidthHint = 280;
        int dataGroupHorizontalSpan = 5;
        int dataGroupNumColumns = 4;
        int dataIntroHorizontalSpan = 4;
        int dataPathHorizontalSpan = 3;
        this.initDefaultFolder();
        final Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        Label seperator = new Label(container, 258);
        seperator.setLayoutData((Object)new GridData(4, 2, true, false, 5, 1));
        Group operationGroup = new Group(container, 0);
        operationGroup.setText(Messages.XMLImportDialog_6);
        operationGroup.setLayoutData((Object)new GridData(4, 2, true, false, 5, 3));
        layout = new GridLayout();
        layout.numColumns = 2;
        operationGroup.setLayout((Layout)layout);
        Label operationIntro = new Label((Composite)operationGroup, 16384);
        operationIntro.setText(Messages.XMLImportDialog_7);
        operationIntro.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.insert = true;
        SelectionAdapter insertListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLImportDialog.this.insert = e.getSource() instanceof Button ? ((Button)e.getSource()).getSelection() : XMLImportDialog.this.insert;
            }
        };
        this.insertButton = SWTElementFactory.generateCheckboxButton((Composite)operationGroup, Messages.XMLImportDialog_25, true, (SelectionListener)insertListener);
        this.insertButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        Label insertText = new Label((Composite)operationGroup, 16384);
        insertText.setText(Messages.XMLImportDialog_8);
        insertText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.update = true;
        SelectionAdapter updateCheckListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLImportDialog.this.update = e.getSource() instanceof Button ? ((Button)e.getSource()).getSelection() : XMLImportDialog.this.update;
            }
        };
        this.updateButton = SWTElementFactory.generateCheckboxButton((Composite)operationGroup, Messages.XMLImportDialog_26, true, (SelectionListener)updateCheckListener);
        this.updateButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        Label updateText = new Label((Composite)operationGroup, 16384);
        updateText.setText(Messages.XMLImportDialog_9);
        updateText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.delete = false;
        SelectionAdapter deleteCheckListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLImportDialog.this.delete = e.getSource() instanceof Button ? ((Button)e.getSource()).getSelection() : XMLImportDialog.this.delete;
            }
        };
        this.deleteCheck = SWTElementFactory.generateCheckboxButton((Composite)operationGroup, Messages.XMLImportDialog_27, false, (SelectionListener)deleteCheckListener);
        this.deleteCheck.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        Label deleteText = new Label((Composite)operationGroup, 16384);
        deleteText.setText(Messages.XMLImportDialog_10);
        deleteText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.integrate = false;
        SelectionAdapter integrateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLImportDialog.this.integrate = e.getSource() instanceof Button ? ((Button)e.getSource()).getSelection() : XMLImportDialog.this.integrate;
            }
        };
        this.integrateButton = SWTElementFactory.generateCheckboxButton((Composite)operationGroup, Messages.XMLImportDialog_31, false, (SelectionListener)integrateListener);
        this.integrateButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.integrateButton.setEnabled(true);
        Label integrateText = new Label((Composite)operationGroup, 16384);
        integrateText.setText(Messages.XMLImportDialog_37);
        integrateText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.createImportAsCatalogOption(container);
        Group cryptGroup = new Group(container, 0);
        cryptGroup.setText(Messages.XMLImportDialog_15);
        cryptGroup.setLayoutData((Object)new GridData(4, 2, true, false, 5, 1));
        GridLayout pbeLayout = new GridLayout(3, false);
        cryptGroup.setLayout((Layout)pbeLayout);
        SelectionAdapter noEncryptionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    XMLImportDialog.this.fileDialogFilterIndex = 0;
                }
            }
        };
        final Button useNoEncryptionRadio = SWTElementFactory.generateRadioButton((Composite)cryptGroup, Messages.XMLImportDialog_36, true, (SelectionListener)noEncryptionAdapter);
        new Label((Composite)cryptGroup, 0);
        new Label((Composite)cryptGroup, 0);
        SelectionAdapter passwordEncryptionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    XMLImportDialog.this.fileDialogFilterIndex = 2;
                }
            }
        };
        final Button passwordEncryptionRadio = SWTElementFactory.generateRadioButton((Composite)cryptGroup, Messages.XMLImportDialog_16, false, (SelectionListener)passwordEncryptionAdapter);
        Text passwordField = new Text((Composite)cryptGroup, 0x400800);
        GridData data = new GridData();
        data.widthHint = 280;
        passwordField.setLayoutData((Object)data);
        new Label((Composite)cryptGroup, 0);
        passwordField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                passwordEncryptionRadio.setSelection(true);
                useNoEncryptionRadio.setSelection(false);
                XMLImportDialog.this.usePasswordEncryption = true;
            }
        });
        passwordField.addModifyListener(e -> {
            String string = this.password = passwordField.getText();
        });
        useNoEncryptionRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLImportDialog.this.usePasswordEncryption = false;
                useNoEncryptionRadio.setSelection(true);
                passwordEncryptionRadio.setSelection(false);
            }
        });
        passwordEncryptionRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLImportDialog.this.usePasswordEncryption = true;
                passwordEncryptionRadio.setSelection(true);
                useNoEncryptionRadio.setSelection(false);
            }
        });
        cryptGroup.pack();
        Group dataGroup = new Group(container, 0);
        dataGroup.setText(Messages.XMLImportDialog_11);
        dataGroup.setLayoutData((Object)new GridData(4, 2, true, false, 5, 1));
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = true;
        dataGroup.setLayout((Layout)layout);
        Label dataIntro1 = new Label((Composite)dataGroup, 16384);
        dataIntro1.setText(Messages.XMLImportDialog_12);
        dataIntro1.setLayoutData((Object)new GridData(4, 2, true, false, 4, 1));
        this.dataPathText = new Text((Composite)dataGroup, 2048);
        this.dataPathText.setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        this.dataPathText.addModifyListener(e -> {
            this.dataFile = new File(this.dataPathText.getText());
            this.dataPathFlag = this.dataFile.exists();
        });
        this.useDefaultFolder = true;
        SelectionAdapter useDefaultFolderListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLImportDialog.this.useDefaultFolder = e.getSource() instanceof Button ? ((Button)e.getSource()).getSelection() : XMLImportDialog.this.useDefaultFolder;
            }
        };
        Button useDefaultFolderButton = SWTElementFactory.generateCheckboxButton(container, Messages.XMLImportDialog_38, true, (SelectionListener)useDefaultFolderListener);
        useDefaultFolderButton.setLayoutData((Object)new GridData(4, 131072, true, false, 2, 1));
        SelectionAdapter dataBrowseListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLImportDialog.this.displayFiles(container.getShell(), XMLImportDialog.this.dataPathText);
            }
        };
        Button dataBrowse = SWTElementFactory.generateButton((Composite)dataGroup, Messages.XMLImportDialog_14, null, (SelectionListener)dataBrowseListener);
        dataBrowse.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.dataPathText.setFocus();
        return container;
    }

    private void createImportAsCatalogOption(Composite container) {
        int importAsCatalogHorizontalSpan = 5;
        int importAsCatalogVerticalSpan = 3;
        Group importAsCatalogGroup = new Group(container, 0);
        importAsCatalogGroup.setText(Messages.XMLImportDialog_Import_As_Catalog_Model);
        importAsCatalogGroup.setLayoutData((Object)new GridData(4, 2, true, false, 5, 3));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        importAsCatalogGroup.setLayout((Layout)layout);
        Button importAsCatalogButton = SWTElementFactory.generateCheckboxButton((Composite)importAsCatalogGroup, Messages.XMLImportDialog_Import_As_Catalog_Option, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bl = XMLImportDialog.this.importAsCatalog = e.getSource() instanceof Button ? ((Button)e.getSource()).getSelection() : XMLImportDialog.this.importAsCatalog;
                if (XMLImportDialog.this.importAsCatalog) {
                    XMLImportDialog.this.setParametersForCatalogImport();
                }
            }
        });
        importAsCatalogButton.setEnabled(false);
        importAsCatalogButton.setSelection(this.importAsCatalog);
        importAsCatalogButton.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Label importAsCatalogText = new Label((Composite)importAsCatalogGroup, 16384);
        importAsCatalogText.setText(Messages.XMLImportDialog_Import_As_Catalog_Option_Description);
        importAsCatalogText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        importAsCatalogText.setEnabled(false);
        if (this.importAsCatalog) {
            this.setParametersForCatalogImport();
        }
    }

    private void setParametersForCatalogImport() {
        this.integrate = true;
        this.integrateButton.setSelection(true);
        this.integrateButton.setEnabled(false);
        this.insert = true;
        this.insertButton.setSelection(true);
        this.insertButton.setEnabled(false);
        this.update = false;
        this.updateButton.setSelection(false);
        this.updateButton.setEnabled(false);
        this.delete = false;
        this.deleteCheck.setSelection(false);
        this.deleteCheck.setEnabled(false);
    }

    private void displayFiles(Shell shell, Text pathText) {
        String path;
        FileDialog dialog = new FileDialog(shell, 0);
        if (this.usePasswordEncryption) {
            dialog.setFilterExtensions(new String[]{"*.pcr"});
            dialog.setFilterNames(new String[]{Messages.XMLImportDialog_34});
        } else {
            dialog.setFilterExtensions(new String[]{"*.vna", "*.xml"});
            dialog.setFilterNames(new String[]{Messages.XMLImportDialog_30, Messages.XMLImportDialog_33});
        }
        if (this.isFilePath()) {
            dialog.setFilterPath(this.getOldFolderPath());
        } else {
            dialog.setFilterPath(this.defaultFolder);
        }
        if (this.fileDialogFilterIndex <= dialog.getFilterNames().length) {
            dialog.setFilterIndex(this.fileDialogFilterIndex);
        }
        if ((path = dialog.open()) != null) {
            File f = new File(path);
            if (dialog.getFilterIndex() < 3) {
                this.format = dialog.getFilterIndex();
            }
            if (f.isFile()) {
                pathText.setText(f.getPath());
                pathText.setEditable(true);
            }
        }
    }

    boolean isFilePath() {
        return this.dataPathText != null && this.dataPathText.getText() != null && !this.dataPathText.getText().isEmpty();
    }

    private String getOldFolderPath() {
        return this.getFolderFromPath(this.dataPathText.getText());
    }

    private String getFolderFromPath(String path) {
        String returnPath = null;
        if (path != null && path.indexOf(File.separatorChar) != -1) {
            returnPath = path.substring(0, path.lastIndexOf(File.separatorChar) + 1);
        }
        return returnPath;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.XMLImportDialog_1);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean getInsertState() {
        return this.insert;
    }

    public boolean getUpdateState() {
        return this.update;
    }

    public boolean getDeleteState() {
        return this.delete;
    }

    private SyncCommand.Status doImport(SyncParameter parameter) {
        Activator.inheritVeriniceContextState();
        byte[] fileData = null;
        IEncryptionService service = ServiceFactory.lookupEncryptionService();
        try {
            if (this.usePasswordEncryption) {
                fileData = FileUtils.readFileToByteArray((File)this.dataFile);
                try {
                    fileData = this.decryptWithGenericSalt(fileData, service);
                }
                catch (EncryptionException e) {
                    fileData = this.decryptWithStaticSalt(fileData, service);
                }
                this.format = this.guessFormat(fileData);
                parameter.setFormat(this.format);
                this.syncCommand = new SyncCommand(parameter, fileData);
            } else if (Activator.getDefault().isStandalone()) {
                String path = this.dataFile.getPath();
                this.syncCommand = new SyncCommand(parameter, path);
            } else {
                fileData = FileUtils.readFileToByteArray((File)this.dataFile);
                this.syncCommand = new SyncCommand(parameter, fileData);
            }
            this.syncCommand = (SyncCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)this.syncCommand);
        }
        catch (PasswordException e) {
            LOG.warn((Object)"Wrong password while decrypting import file.");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Stacktrace: ", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.updateModelAndValidate(this.syncCommand);
        return this.syncCommand.getStatus();
    }

    private byte[] decryptWithGenericSalt(byte[] fileData, IEncryptionService service) throws PasswordException {
        byte[] saltBytes = new byte[8];
        System.arraycopy(fileData, 0, saltBytes, 0, 8);
        fileData = service.decrypt(fileData, this.password.toCharArray(), saltBytes);
        return fileData;
    }

    private byte[] decryptWithStaticSalt(byte[] fileData, IEncryptionService service) throws PasswordException {
        fileData = service.decrypt(fileData, this.password.toCharArray());
        return fileData;
    }

    private void updateModelAndValidate(final SyncCommand command) {
        CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
        if (Activator.getDefault().getPreferenceStore().getBoolean("use_automatic_validation") && !this.importAsCatalog) {
            WorkspaceJob validationCreationJob = new WorkspaceJob(Messages.XMLImportDialog_4){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        try {
                            monitor.beginTask(NLS.bind((String)Messages.XMLImportDialog_5, (Object[])new Object[]{XMLImportDialog.this.dataFile.getName()}), -1);
                            XMLImportDialog.this.createValidations(command.getImportedElementUUIDs());
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Exception while executing createValidationsJob", (Throwable)e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return status;
                }
            };
            JobScheduler.scheduleJob(validationCreationJob, this.iSchedulingRule);
        }
    }

    private Integer guessFormat(byte[] fileData) {
        Integer result = SyncParameter.EXPORT_FORMAT_VERINICE_ARCHIV;
        if (fileData != null) {
            String content = new String(fileData);
            if ((content = content.trim()).endsWith(SYNC_REQUEST)) {
                result = SyncParameter.EXPORT_FORMAT_XML_PURE;
            }
        }
        return result;
    }

    private void createValidations(Set<String> uuids) {
        try {
            Activator.inheritVeriniceContextState();
            if (!uuids.isEmpty()) {
                ServiceFactory.lookupValidationService().createValidationsByUuids(uuids);
                String oneUUID = uuids.iterator().next();
                CnATreeElement element = CnAElementHome.getInstance().loadElementsByUUID(Collections.singleton(oneUUID), new RetrieveInfo()).iterator().next();
                CnAElementFactory.getModel(element).validationAdded(element.getScopeId());
            }
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while executing validation creation command", (Throwable)e);
        }
    }

    private String initDefaultFolder() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.defaultFolder = prefs.getString("default_folder_import");
        if (this.defaultFolder == null || this.defaultFolder.isEmpty()) {
            this.defaultFolder = System.getProperty("user.home");
        }
        if (!this.defaultFolder.endsWith(System.getProperty("file.separator"))) {
            this.defaultFolder = String.valueOf(this.defaultFolder) + System.getProperty("file.separator");
        }
        return this.defaultFolder;
    }

    public boolean getUseDefaultFolder() {
        return this.useDefaultFolder;
    }
}

