/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.InputHelperFactory;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.Entity;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.swt.widgets.HitroUIComposite;
import sernet.snutils.DBException;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.rcp.Preferences;

public class PersonBulkEditDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(PersonBulkEditDialog.class);
    private String title;
    private boolean isScopeOnly;
    private boolean useRules = true;
    private Entity entity;
    private Text textPassword2;
    private String password2;
    private Text textPassword;
    private String password;

    private PersonBulkEditDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        IAuthService authService = (IAuthService)VeriniceContext.get((String)"authService");
        this.isScopeOnly = authService.isScopeOnly();
    }

    public PersonBulkEditDialog(Shell shell, String title) {
        this(shell);
        this.title = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        int shellWidth = 460;
        int shellHeight = 640;
        int cursorLocationXSubtrahend = 200;
        int cursorLocationYSubtrahend = 400;
        newShell.setText(this.title);
        newShell.setSize(460, 640);
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        newShell.setLocation(new Point(cursorLocation.x - 200, cursorLocation.y - 400));
    }

    protected Control createDialogArea(Composite parent) {
        try {
            this.setTitle(this.title);
            this.setMessage(Messages.PersonBulkEditDialog_UserAccountSettings);
            Composite container = (Composite)super.createDialogArea(parent);
            GridData gd = new GridData(512);
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            container.setLayoutData((Object)gd);
            ScrolledComposite scrolledComposite = new ScrolledComposite(container, 512);
            scrolledComposite.setLayoutData((Object)new GridData(1808));
            scrolledComposite.setExpandHorizontal(true);
            Composite innerComposite = new Composite((Composite)scrolledComposite, 0);
            scrolledComposite.setContent((Control)innerComposite);
            innerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            innerComposite.setLayout((Layout)new GridLayout(1, false));
            this.createPasswordComposite(innerComposite);
            HitroUIComposite huiComposite = new HitroUIComposite(innerComposite, false);
            try {
                this.entity = new Entity("configuration");
                String[] tags = Preferences.getEditorTags();
                boolean strict = Activator.getDefault().getPluginPreferences().getBoolean("hui_tags_strict");
                huiComposite.createView(this.entity, true, this.useRules, tags, strict, new ArrayList(0), Activator.getDefault().getPreferenceStore().getBoolean("use_validation_gui_hints"));
                this.configureScopeOnly((Combo)huiComposite.getField("configuration_scope"));
                InputHelperFactory.setInputHelpers(HUITypeFactory.getInstance().getEntityType(this.entity.getEntityType()), huiComposite);
            }
            catch (DBException e) {
                ExceptionUtil.log(e, Messages.BulkEditDialog_1);
            }
            scrolledComposite.setVisible(true);
            Point size = innerComposite.computeSize(-1, -1);
            innerComposite.setSize(size);
            container.layout();
            return container;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating account dialog", (Throwable)e);
            return null;
        }
    }

    public String getPassword2() {
        return this.password2;
    }

    public String getPassword() {
        return this.password;
    }

    private void configureScopeOnly(Combo combo) {
        if (this.isScopeOnly) {
            if (combo.getSelectionIndex() == -1) {
                combo.select(0);
            }
            combo.setEnabled(false);
        }
    }

    protected void okPressed() {
        this.password = this.textPassword.getText();
        this.password2 = this.textPassword2.getText();
        super.okPressed();
    }

    public Entity getEntity() {
        return this.entity;
    }

    private void createPasswordComposite(Composite composite) {
        GridData gd = new GridData(512);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        Composite compositePassword = new Composite(composite, 0);
        GridLayout layoutPassword = new GridLayout(2, false);
        compositePassword.setLayout((Layout)layoutPassword);
        compositePassword.setLayoutData((Object)gd);
        GridData gdText = new GridData(512);
        gdText.grabExcessHorizontalSpace = true;
        gdText.horizontalAlignment = 4;
        Label labelPassword = new Label(compositePassword, 0);
        labelPassword.setText(Messages.PersonBulkEditDialog_Password);
        this.textPassword = new Text(compositePassword, 0x400804);
        this.textPassword.setLayoutData((Object)gdText);
        Label labelPassword2 = new Label(compositePassword, 0);
        labelPassword2.setText(Messages.PersonBulkEditDialog_RetypePassword);
        this.textPassword2 = new Text(compositePassword, 0x400804);
        this.textPassword2.setLayoutData((Object)gdText);
    }
}

