/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.ui.rcp.main.bsi.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.verinice.model.bsi.BausteinUmsetzung;

public class KonsolidatorDialog
extends Dialog {
    private List<BausteinUmsetzung> selection;
    private BausteinUmsetzung source = null;

    public KonsolidatorDialog(Shell shell, List<BausteinUmsetzung> selectedElements) {
        super(shell);
        this.selection = selectedElements;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Label intro = new Label(container, 0);
        intro.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        intro.setText(Messages.KonsolidatorDialog_0);
        final ListViewer viewer = new ListViewer(container, 2080);
        viewer.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                BausteinUmsetzung bst = (BausteinUmsetzung)element;
                return String.valueOf(bst.getKapitel()) + ": " + bst.getParent().getTitle();
            }
        });
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(this.selection);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
                if (sel.size() == 1) {
                    KonsolidatorDialog.this.source = (BausteinUmsetzung)sel.getFirstElement();
                }
            }
        });
        return container;
    }

    public static boolean askConsolidate(Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)Messages.KonsolidatorDialog_2, (String)Messages.KonsolidatorDialog_3);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.KonsolidatorDialog_4);
    }

    public BausteinUmsetzung getSource() {
        return this.source;
    }
}

